/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.engine.log.ICCompilerLog;
import mrtjp.projectred.fabrication.gui.CompileTreeTab;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchCompileTab;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.RedUISprite;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CTNListNode
extends AbstractGuiNode {
    private final List<ICCompilerLog.CompileTreeNode> nodeList = new LinkedList<ICCompilerLog.CompileTreeNode>();
    private final AbstractGuiNode listParent = new AbstractGuiNode(this){};
    private double scroll = 0.0;

    public CTNListNode() {
        this.initSubNodes();
    }

    private void initSubNodes() {
        this.addChild((RedUINode)this.listParent);
    }

    public void setNodeList(List<ICCompilerLog.CompileTreeNode> nodeList) {
        if (!this.nodeList.equals(nodeList)) {
            this.nodeList.clear();
            this.nodeList.addAll(nodeList);
            this.refreshListItems();
        }
    }

    private void refreshListItems() {
        this.listParent.removeAllChildren();
        this.listParent.setPosition(0, 0);
        int y = 0;
        for (ICCompilerLog.CompileTreeNode node : this.nodeList) {
            CompileTreeNodeListItem item = new CompileTreeNodeListItem(node);
            item.setPosition(0, y);
            this.listParent.addChild((RedUINode)item);
            y += item.calculateAccumulatedFrame().height();
        }
        this.moveListToScroll();
    }

    public void setScrollPercentage(double scrollPercentage) {
        this.scroll = scrollPercentage;
        this.moveListToScroll();
    }

    private void moveListToScroll() {
        Rect subFrame = this.calculateChildrenFrame();
        if (subFrame.height() <= this.getFrame().height()) {
            return;
        }
        int totalScroll = subFrame.height() - this.getFrame().height();
        int dist = (int)((double)totalScroll * this.scroll);
        this.listParent.setPosition(0, -dist);
    }

    @Nullable
    public ICCompilerLog.CompileTreeNode getSelectedNode() {
        for (RedUINode child : this.listParent.getOurChildren()) {
            if (!(child instanceof CompileTreeNodeListItem)) continue;
            CompileTreeNodeListItem item = (CompileTreeNodeListItem)child;
            if (!item.selected) continue;
            return item.node;
        }
        return null;
    }

    public void onSubTreePreDrawBack() {
        Rect gl11Rect = this.calculateGL11Frame();
        RenderSystem.enableScissor((int)gl11Rect.x(), (int)gl11Rect.y(), (int)gl11Rect.width(), (int)gl11Rect.height());
    }

    public void onSubTreePostDrawBack() {
        RenderSystem.disableScissor();
    }

    private void selectNodeInList(CompileTreeNodeListItem node) {
        for (RedUINode child : this.listParent.getOurChildren()) {
            if (!(child instanceof CompileTreeNodeListItem)) continue;
            CompileTreeNodeListItem item = (CompileTreeNodeListItem)child;
            item.selected = item == node;
        }
    }

    private class CompileTreeNodeListItem
    extends AbstractGuiNode {
        private static final RedUISprite BACKGROUND_UNSELECTED = new RedUISprite(ICWorkbenchCompileTab.TAB_BACKGROUND, 1, 375, 79, 12, 512, 512);
        private static final RedUISprite BACKGROUND_SELECTED = new RedUISprite(ICWorkbenchCompileTab.TAB_BACKGROUND, 81, 375, 79, 12, 512, 512);
        private final ICCompilerLog.CompileTreeNode node;
        private boolean selected = false;

        public CompileTreeNodeListItem(ICCompilerLog.CompileTreeNode node) {
            this.node = node;
            this.setSize(68, 12);
        }

        public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
            this.blitSprite(graphics, this.selected ? BACKGROUND_SELECTED : BACKGROUND_UNSELECTED);
            Font fr = this.getRoot().getFontRenderer();
            MutableComponent c = CompileTreeTab.getTitleForCTNNode(this.node).copy().withStyle(ICWorkbenchEditor.UNIFORM);
            int n = this.getFrame().x() + 2;
            int n2 = this.getFrame().y() + this.getFrame().height() / 2;
            Objects.requireNonNull(fr);
            graphics.drawString(fr, (Component)c, n, n2 - 9 / 2, 0xFFFFFF, false);
        }

        public void drawFront(GuiGraphics graphics, Point mouse, float partialFrame) {
            if (!this.isFirstHit(mouse)) {
                return;
            }
            LinkedList<Component> toolTip = new LinkedList<Component>();
            CompileTreeTab.buildTooltipForCTNNode(this.node, toolTip);
            this.renderTooltip(graphics, mouse, toolTip);
        }

        public boolean checkHit(Point absPoint) {
            return super.checkHit(absPoint) && CTNListNode.this.convertParentRectToScreen(CTNListNode.this.getFrame()).contains(absPoint);
        }

        public boolean mouseClicked(Point p, int glfwMouseButton, boolean consumed) {
            if (!consumed && this.isFirstHit(p)) {
                CTNListNode.this.selectNodeInList(this);
                return true;
            }
            return false;
        }
    }
}

