/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractGuiNode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public abstract class AbstractButtonNode
extends AbstractGuiNode {
    public static final int BUTTON_STATE_DISABLED = 0;
    public static final int BUTTON_STATE_IDLE = 1;
    public static final int BUTTON_STATE_HIGHLIGHT = 2;
    private static final ResourceLocation[] buttonSprites = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted")};

    protected abstract void onButtonClicked();

    protected boolean isButtonDisabled() {
        return false;
    }

    protected void buildTooltip(List<Component> tooltip) {
    }

    protected int getButtonState(boolean mouseover) {
        return this.isButtonDisabled() ? 0 : (mouseover ? 2 : 1);
    }

    @Override
    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        boolean mouseover = this.getFrame().contains(mouse) && this.isFirstHit(mouse);
        int state = this.getButtonState(mouseover);
        this.drawMCButton(graphics, state);
        this.drawButtonBody(graphics, mouseover);
    }

    @Override
    public void drawFront(GuiGraphics graphics, Point mouse, float partialFrame) {
        if (!this.isFirstHit(mouse)) {
            return;
        }
        LinkedList<Component> tooltip = new LinkedList<Component>();
        this.buildTooltip(tooltip);
        if (!tooltip.isEmpty()) {
            this.renderTooltip(graphics, mouse, tooltip);
        }
    }

    @Override
    public boolean mouseClicked(Point p, int glfwMouseButton, boolean consumed) {
        if (!consumed && !this.isButtonDisabled() && this.isFirstHit(p)) {
            this.getRoot().getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.onButtonClicked();
            return true;
        }
        return false;
    }

    protected void drawMCButton(GuiGraphics graphics, int state) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getFrame().width();
        int height = this.getFrame().height();
        graphics.blitSprite(buttonSprites[state], x, y, width, height);
    }

    protected abstract void drawButtonBody(GuiGraphics var1, boolean var2);
}

