/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.power;

import java.util.List;
import mrtjp.projectred.core.power.IPowerConductorSource;
import net.minecraft.nbt.CompoundTag;

public class PowerConductor {
    private double vCap = 0.0;
    private double iCap = 0.0;
    private final double resistance;
    private final double capacitance;
    private final double inverseCapacitance;
    private long time = -1L;
    private final IPowerConductorSource parent;

    public PowerConductor(IPowerConductorSource parent, double resistance, double capacitance) {
        this.parent = parent;
        this.resistance = resistance;
        this.capacitance = capacitance;
        this.inverseCapacitance = 1.0 / capacitance;
    }

    public void save(CompoundTag tag) {
        tag.putDouble("vCap", this.vCap);
        tag.putDouble("iCap", this.iCap);
    }

    public void load(CompoundTag tag) {
        this.vCap = tag.getDouble("vCap");
        this.iCap = tag.getDouble("iCap");
    }

    public double getVoltage() {
        long t = this.parent.getTime();
        if (this.time != t) {
            this.time = t;
            this.vCap += 0.05 * this.iCap * this.inverseCapacitance;
            this.iCap = 0.0;
        }
        return this.vCap;
    }

    public double getCurrent() {
        return this.iCap * 0.05;
    }

    public double getEnergy() {
        return 0.5 * this.capacitance * this.vCap * this.vCap;
    }

    public void applyCurrent(double i) {
        this.getVoltage();
        this.iCap += i;
    }

    public void applyPower(double p) {
        double dVSquared = Math.abs(p) * 0.1 * this.inverseCapacitance;
        if (p < 0.0 && dVSquared >= this.vCap * this.vCap) {
            return;
        }
        double dI = 20.0 * Math.sqrt(dVSquared) * this.capacitance;
        this.applyCurrent(p < 0.0 ? -dI : dI);
    }

    public void tick() {
        this.getVoltage();
        List<PowerConductor> conductors = this.parent.getConnectedConductors();
        for (PowerConductor cond : conductors) {
            if (cond.getVoltage() > this.getVoltage()) continue;
            double v = this.getVoltage() - cond.getVoltage();
            double r = this.resistance + cond.resistance;
            double i = v / r;
            this.applyCurrent(-i);
            cond.applyCurrent(i);
        }
    }
}

