/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.part;

import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.BlockMultipart;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.part.IConnectablePart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;

public interface IConnectableCenterPart
extends MultiPart,
IConnectablePart {
    default public BlockPos posOfStraight(int s) {
        return this.pos().relative(Direction.values()[s]);
    }

    @Nullable
    default public IConnectable getStraight(int s) {
        BlockPos pos = this.pos().relative(Direction.values()[s]);
        MultiPart part = BlockMultipart.getPart((BlockGetter)this.level(), (BlockPos)pos, (int)6);
        return part instanceof IConnectable ? (IConnectable)part : null;
    }

    @Nullable
    default public IConnectable getInternal(int s) {
        MultiPart part = this.tile().getSlottedPart(s);
        return part instanceof IConnectable ? (IConnectable)part : null;
    }

    public boolean canConnectPart(IConnectable var1, int var2);

    default public boolean maskOpen(int s) {
        return (this.getConnMap() & 4096 << s) != 0;
    }

    default public boolean maskConnects(int s) {
        return (this.getConnMap() & 65 << s) != 0;
    }

    default public boolean maskConnectsOut(int s) {
        return (this.getConnMap() & 1 << s) != 0;
    }

    default public boolean maskConnectsIn(int s) {
        return (this.getConnMap() & 64 << s) != 0;
    }

    @Override
    default public boolean connectStraight(IConnectable part, int s, int edgeRot) {
        if (this.canConnectPart(part, s) && this.maskOpen(s)) {
            int connMap = this.getConnMap();
            if ((connMap |= 1 << s) != this.getConnMap()) {
                this.setConnMap(connMap);
                this.maskChangeEvent(false, true);
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean connectInternal(IConnectable part, int s) {
        if (this.canConnectPart(part, s)) {
            int connMap = this.getConnMap();
            if ((connMap |= 64 << s) != this.getConnMap()) {
                this.setConnMap(connMap);
                this.maskChangeEvent(true, false);
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean connectCorner(IConnectable part, int s, int edgeRot) {
        return false;
    }

    @Override
    default public boolean canConnectCorner(int r) {
        return false;
    }

    public boolean discoverOpen(int var1);

    default public boolean discoverStraight(int s) {
        IConnectable c = this.getStraight(s);
        if (c != null) {
            return this.canConnectPart(c, s) && c.connectStraight(this, s ^ 1, -1);
        }
        return this.discoverStraightOverride(s);
    }

    default public boolean discoverInternal(int s) {
        IConnectable c = this.getInternal(s);
        if (c != null) {
            return this.canConnectPart(c, s) && c.connectInternal(this, -1);
        }
        return this.discoverInternalOverride(s);
    }

    default public boolean discoverStraightOverride(int s) {
        return false;
    }

    default public boolean discoverInternalOverride(int s) {
        return false;
    }

    @Override
    default public boolean updateOpenConns() {
        int connMap = this.getConnMap() & 0xFFFC0FFF;
        for (int s = 0; s < 6; ++s) {
            if (!this.discoverOpen(s)) continue;
            connMap |= 4096 << s;
        }
        if (connMap != this.getConnMap()) {
            this.setConnMap(connMap);
            return true;
        }
        return false;
    }

    @Override
    default public boolean updateExternalConns() {
        int connMap = this.getConnMap() & 0xFFFFFFC0;
        for (int s = 0; s < 6; ++s) {
            if (!this.maskOpen(s) || !this.discoverStraight(s)) continue;
            connMap |= 1 << s;
        }
        if (connMap != this.getConnMap()) {
            this.setConnMap(connMap);
            return true;
        }
        return false;
    }

    @Override
    default public boolean updateInternalConns() {
        int connMap = this.getConnMap() & 0xFFFFF03F;
        for (int s = 0; s < 6; ++s) {
            if (!this.discoverInternal(s)) continue;
            connMap |= 64 << s;
        }
        if (connMap != this.getConnMap()) {
            this.setConnMap(connMap);
            return true;
        }
        return false;
    }

    @Override
    default public void notifyAllExternals() {
        this.notifyExternals(63);
    }

    default public void notifyExternals(int mask) {
        for (int s = 0; s < 6; ++s) {
            if ((mask & 1 << s) == 0 || !this.maskConnectsOut(s)) continue;
            this.notifyStraight(s);
        }
    }

    default public void notifyStraight(int r) {
        BlockPos pos = this.posOfStraight(r);
        this.level().neighborChanged(pos, this.tile().getBlockState().getBlock(), pos);
    }
}

