/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.inventory.container;

import codechicken.lib.inventory.container.CCLMenuType;
import java.util.Objects;
import mrtjp.projectred.core.init.CoreItems;
import mrtjp.projectred.core.init.CoreMenus;
import mrtjp.projectred.core.inventory.container.BasePoweredBlockEntityMenu;
import mrtjp.projectred.core.inventory.container.SimpleDataSlot;
import mrtjp.projectred.core.tile.ElectrotineGeneratorBlockEntity;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ElectrotineGeneratorMenu
extends BasePoweredBlockEntityMenu {
    public static final CCLMenuType<ElectrotineGeneratorMenu> FACTORY = (windowId, inventory, packet) -> {
        BlockPos pos = Objects.requireNonNull(packet).readPos();
        BlockEntity tile = inventory.player.level().getBlockEntity(pos);
        if (!(tile instanceof ElectrotineGeneratorBlockEntity)) {
            throw new IllegalStateException("Could not open ElectrotineGeneratorMenu for tile " + String.valueOf(tile) + " at pos " + String.valueOf(pos));
        }
        return new ElectrotineGeneratorMenu(inventory, (ElectrotineGeneratorBlockEntity)tile, windowId);
    };
    private final Inventory playerInventory;
    private final ElectrotineGeneratorBlockEntity tile;
    private int burnTimeRemaining = 0;
    private int powerStored = 0;

    public ElectrotineGeneratorMenu(Inventory playerInventory, ElectrotineGeneratorBlockEntity tile, int windowId) {
        super(CoreMenus.ELECTROTINE_GENERATOR_MENU.get(), windowId, tile);
        this.playerInventory = playerInventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory(playerInventory, 8, 89, x$0 -> this.addSlot((Slot)x$0));
        this.addElectrotineGeneratorInventory();
        this.addDataSlot(new SimpleDataSlot(tile::getBurnTimeRemaining, value -> {
            this.burnTimeRemaining = value;
        }));
        this.addDataSlot(new SimpleDataSlot(tile::getPowerStored, value -> {
            this.powerStored = value;
        }));
    }

    private void addElectrotineGeneratorInventory() {
        this.addSlot(new Slot(this, (Container)this.tile.getInventory(), 0, 134, 42){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() == CoreItems.ELECTROTINE_DUST_ITEM.get();
            }
        });
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (this.isFuel(slotIndex) ? !this.moveToEntireInventory(stack, false) : (stack.getItem() == CoreItems.ELECTROTINE_DUST_ITEM.get() ? !this.moveToFuel(stack, false) : (this.isPlayerInventory(slotIndex) ? !this.moveToHotbar(stack, false) : !this.moveToPlayerInventory(stack, false)))) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == originalStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return originalStack;
    }

    public int getBurnTimeScaled(int scale) {
        return this.burnTimeRemaining == 0 ? 0 : scale * this.burnTimeRemaining / this.tile.getMaxBurnTime();
    }

    public int getPowerStoredScaled(int scale) {
        return this.powerStored == 0 ? 0 : scale * this.powerStored / this.tile.getMaxStorage();
    }

    public boolean isPowerStorageFull() {
        return this.powerStored == this.tile.getMaxStorage();
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0;
    }

    public boolean isChargingStorage() {
        return this.burnTimeRemaining > this.tile.getBurnUseOnCharge() && this.powerStored < this.tile.getMaxStorage();
    }

    public boolean isChargingConductor() {
        return this.condCharge < this.tile.getDrawFloor() && (this.powerStored > 0 || this.burnTimeRemaining > this.tile.getBurnUseOnCharge());
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isFuel(int slotIndex) {
        return slotIndex == 36;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 0, 36, reverse);
    }

    private boolean moveToFuel(ItemStack stack, boolean reverse) {
        return this.moveItemStackTo(stack, 36, 37, reverse);
    }
}

