/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.client.particle;

import mrtjp.projectred.core.client.particle.BaseActionParticle;
import mrtjp.projectred.core.client.particle.ParticleAction;

public class ChangeAlphaToAction
extends ParticleAction {
    private final double targetAlpha;
    private final double duration;
    private double deltaAlpha;

    public ChangeAlphaToAction(double targetAlpha, double duration) {
        this.targetAlpha = targetAlpha;
        this.duration = duration;
    }

    @Override
    public ParticleAction copy() {
        return new ChangeAlphaToAction(this.targetAlpha, this.duration);
    }

    @Override
    public void beginAction(BaseActionParticle particle) {
        double startAlpha = particle.getAlpha();
        this.deltaAlpha = (this.targetAlpha - startAlpha) / this.duration;
    }

    @Override
    public void operateAction(BaseActionParticle particle, double time) {
        double newAlpha = (double)particle.getAlpha() + this.deltaAlpha * this.deltaTime(time);
        newAlpha = Math.max(0.0, Math.min(1.0, newAlpha));
        particle.setAlpha((float)newAlpha);
        if (time >= this.duration || newAlpha <= 0.0 || newAlpha >= 1.0 || ChangeAlphaToAction.equalsT(newAlpha, this.targetAlpha)) {
            this.finished = true;
        }
    }
}

