/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="immersiveengineering", bus=EventBusSubscriber.Bus.GAME)
public class RobotWolfItem
extends IEBaseItem {
    public static ResourceLocation REGISTRY_KEY = IEApi.ieLoc("robot");

    public RobotWolfItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        if (!(level instanceof ServerLevel) || player == null) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = ctx.getItemInHand();
        BlockPos targetPos = ctx.getClickedPos();
        Direction direction = ctx.getClickedFace();
        BlockState blockstate = level.getBlockState(targetPos);
        BlockPos spawnPos = blockstate.getCollisionShape((BlockGetter)level, targetPos).isEmpty() ? targetPos : targetPos.relative(direction);
        Wolf wolf = (Wolf)EntityType.WOLF.spawn((ServerLevel)level, itemstack, player, spawnPos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(targetPos, spawnPos) && direction == Direction.UP);
        if (wolf != null) {
            level.registryAccess().registryOrThrow(Registries.WOLF_VARIANT).getHolder(REGISTRY_KEY).ifPresent(arg_0 -> ((Wolf)wolf).setVariant(arg_0));
            wolf.tame(player);
            wolf.setOrderedToSit(true);
            wolf.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(6.0);
            wolf.getAttribute(Attributes.MAX_HEALTH).setBaseValue(50.0);
            wolf.setHealth(50.0f);
            itemstack.shrink(1);
            level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, targetPos);
        }
        return InteractionResult.CONSUME;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
    }

    @SubscribeEvent
    public static void onWolfInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Wolf wolf;
        Entity entity = event.getTarget();
        if (!(entity instanceof Wolf) || !(wolf = (Wolf)entity).getVariant().is(REGISTRY_KEY)) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (wolf.isFood(stack) || stack.getItem() instanceof SpawnEggItem) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getLevel().isClientSide()));
        } else if (wolf.getHealth() < wolf.getMaxHealth()) {
            ItemUtils.isHoldingBoth(event.getEntity(), IETags.hammers, IETags.repairsAutomaton).ifPresent(heldItems -> {
                wolf.heal(16.0f);
                ((ItemUtils.EquippedItem)heldItems.getFirst()).stack().hurtAndBreak(1, (LivingEntity)event.getEntity(), ((ItemUtils.EquippedItem)heldItems.getFirst()).slot());
                ((ItemUtils.EquippedItem)heldItems.getSecond()).stack().consume(1, (LivingEntity)event.getEntity());
                event.getEntity().playSound(SoundEvents.ANVIL_USE);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getLevel().isClientSide()));
            });
        }
    }
}

