/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.energy.IMutableEnergyStorage;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.ChunkLoaderLogic;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import com.google.common.collect.ArrayListMultimap;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collector;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ChunkLoaderMenu
extends IEContainerMenu {
    private static final BlockPos CRYSTAL_POS = new BlockPos(1, 3, 1);
    public final IEnergyStorage energy;
    public final GetterAndSetter<List<NearbyBlockEntity>> blockEntityList;
    public final GetterAndSetter<Integer> refreshTimer;
    public final GetterAndSetter<BlockPos> crystalPos;

    public static ChunkLoaderMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, IEContainerMenu.MultiblockMenuContext<ChunkLoaderLogic.State> ctx) {
        ChunkLoaderLogic.State state = ctx.mbContext().getState();
        return new ChunkLoaderMenu(ChunkLoaderMenu.multiblockCtx(type, id, ctx), invPlayer, (IItemHandler)state.inventory, state.energy, GetterAndSetter.getterOnly(() -> state.getNearbyBlockEntities(ctx.mbContext()).collect(Collector.of(ArrayListMultimap::create, (blockListMap, blockEntity) -> blockListMap.put((Object)blockEntity.getBlockState().getBlock(), (Object)blockEntity.getBlockPos()), (m1, m2) -> {
            for (Block key : m2.keySet()) {
                m1.get((Object)key).addAll(m2.get((Object)key));
            }
            return m1;
        }, multimap -> multimap.keySet().stream().sorted(Comparator.comparing(block -> block.getName().getString())).map(block -> new NearbyBlockEntity((Component)block.getName(), List.copyOf(multimap.get(block)))).toList(), new Collector.Characteristics[0]))), GetterAndSetter.getterOnly(() -> state.refreshTimer), GetterAndSetter.constant(ctx.mbContext().getLevel().toAbsolute(CRYSTAL_POS)));
    }

    public static ChunkLoaderMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new ChunkLoaderMenu(ChunkLoaderMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ItemStackHandler(1), new MutableEnergyStorage(32000), GetterAndSetter.standalone(List.of()), GetterAndSetter.standalone(0), GetterAndSetter.standalone(BlockPos.ZERO));
    }

    public ChunkLoaderMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, IItemHandler inv, IMutableEnergyStorage energy, GetterAndSetter<List<NearbyBlockEntity>> blockEntityList, GetterAndSetter<Integer> refreshTimer, GetterAndSetter<BlockPos> crystalPos) {
        super(ctx);
        int i;
        this.energy = energy;
        this.blockEntityList = blockEntityList;
        this.refreshTimer = refreshTimer;
        this.crystalPos = crystalPos;
        this.addSlot((Slot)new IESlot.Tagged(inv, this.ownSlotCount++, 124, 94, IETags.paper));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 160 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 218));
        }
        this.addGenericData(GenericContainerData.energy(energy));
        this.addGenericData(new GenericContainerData<List<NearbyBlockEntity>>(GenericDataSerializers.NEARBY_BLOCK_ENTITIES, blockEntityList));
        this.addGenericData(GenericContainerData.int32(refreshTimer.getter(), refreshTimer.setter()));
        this.addGenericData(new GenericContainerData<BlockPos>(GenericDataSerializers.BLOCK_POS, crystalPos));
    }

    public record NearbyBlockEntity(Component name, List<BlockPos> pos) {
        public static final StreamCodec<RegistryFriendlyByteBuf, NearbyBlockEntity> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC, NearbyBlockEntity::name, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), NearbyBlockEntity::pos, NearbyBlockEntity::new);

        public String getDisplayString() {
            return this.pos.size() + "x " + this.name.getString();
        }
    }
}

