/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class VerticalFacingBlock
extends IEBaseBlock {
    public VerticalFacingBlock(BlockBehaviour.Properties blockProps) {
        super(blockProps);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IEProperties.FACING_TOP_DOWN});
    }

    protected Direction getDefaultFacing() {
        return Direction.UP;
    }

    @Override
    protected BlockState getInitDefaultState() {
        BlockState ret = super.getInitDefaultState();
        return (BlockState)ret.setValue((Property)IEProperties.FACING_TOP_DOWN, (Comparable)this.getDefaultFacing());
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        if (pContext.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)this.defaultBlockState().setValue((Property)IEProperties.FACING_TOP_DOWN, (Comparable)pContext.getClickedFace());
        }
        Direction d = pContext.getClickLocation().y < 0.5 ? Direction.UP : Direction.DOWN;
        return (BlockState)this.defaultBlockState().setValue((Property)IEProperties.FACING_TOP_DOWN, (Comparable)d);
    }
}

