/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.jei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class FDRecipes {
    private final RecipeManager recipeManager;

    public FDRecipes() {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("minecraft world must not be null.");
        }
        this.recipeManager = level.getRecipeManager();
    }

    public List<RecipeHolder<CookingPotRecipe>> getCookingPotRecipes() {
        return this.recipeManager.getAllRecipesFor(ModRecipeTypes.COOKING.get());
    }

    public List<RecipeHolder<CuttingBoardRecipe>> getCuttingBoardRecipes() {
        return this.recipeManager.getAllRecipesFor(ModRecipeTypes.CUTTING.get());
    }

    public List<RecipeHolder<CraftingRecipe>> getSpecialWheatDoughRecipe() {
        Optional specialRecipe = this.recipeManager.byKey(ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"wheat_dough_from_water"));
        ArrayList recipes = Lists.newArrayList();
        specialRecipe.ifPresent(recipe -> {
            NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}), Ingredient.of((ItemLike[])new ItemLike[]{Items.WATER_BUCKET})});
            ItemStack output = new ItemStack((ItemLike)ModItems.WHEAT_DOUGH.get());
            ResourceLocation id = recipe.id();
            ShapelessRecipe newRecipe = new ShapelessRecipe("fd_dough", CraftingBookCategory.MISC, output, inputs);
            recipes.add(new RecipeHolder(id, (Recipe)newRecipe));
        });
        return recipes;
    }
}

