/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.features;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.features.ShaderSettingsConverter;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;

public class UpdateShaderConfig {
    private static final String EUPHORIA_IDENTIFIER = "AAA_THIS_IS_A_EUPHORIA_PATCHES_SETTINGS_FILE=true";
    private static final String VERSION_IDENTIFIER_PREFIX = "AAB_FOR_EUPHORIA_PATCHES_VERSION_";
    private static final String VERSION_IDENTIFIER_SUFFIX = "=true";
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "EuphoriaPatcher-FileWriter");
        t.setDaemon(true);
        return t;
    });

    public static void shutdownFileWriter() {
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(2L, TimeUnit.SECONDS)) {
                scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            scheduler.shutdownNow();
        }
    }

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[UpdateShaderConfig] " + message);
    }

    private static String getVersionIdentifier() {
        String version = "_1.7.0";
        version = version.substring(1);
        version = version.replace(".", "_");
        return VERSION_IDENTIFIER_PREFIX + version + VERSION_IDENTIFIER_SUFFIX;
    }

    private static String extractVersionFromIdentifier(String line) {
        if (line.startsWith(VERSION_IDENTIFIER_PREFIX) && line.endsWith(VERSION_IDENTIFIER_SUFFIX)) {
            String versionPart = line.substring(VERSION_IDENTIFIER_PREFIX.length(), line.length() - VERSION_IDENTIFIER_SUFFIX.length());
            return "_" + versionPart.replace("_", ".");
        }
        return null;
    }

    public static void updateShaderTxtConfigFile(boolean styleUnbound, boolean styleReimagined) {
        block18: {
            try (DirectoryStream<Path> oldConfigTextStream = Files.newDirectoryStream(EuphoriaPatcher.shaderpacks, path -> UpdateShaderConfig.isConfigFile(path, true));){
                Path oldShaderConfigFilePath = UpdateShaderConfig.findShaderConfigFile(oldConfigTextStream, true);
                if (oldShaderConfigFilePath != null) {
                    UpdateShaderConfig.doConfigFileCopy(oldShaderConfigFilePath, true, styleUnbound, styleReimagined);
                    break block18;
                }
                try (DirectoryStream<Path> baseShaderConfigTextStream = Files.newDirectoryStream(EuphoriaPatcher.shaderpacks, path -> UpdateShaderConfig.isConfigFile(path, false));){
                    Path baseShaderConfigFilePath = UpdateShaderConfig.findShaderConfigFile(baseShaderConfigTextStream, true);
                    if (baseShaderConfigFilePath != null) {
                        UpdateShaderConfig.doConfigFileCopy(baseShaderConfigFilePath, false, styleUnbound, styleReimagined);
                    }
                }
                catch (IOException e) {
                    EuphoriaPatcher.log(3, 0, "Error reading shaderpacks directory: " + e.getMessage());
                }
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, 0, "Error reading shaderpacks directory: " + e.getMessage());
            }
        }
        UpdateShaderConfig.markEuphoriaPatchesSettingsFiles();
    }

    public static void markEuphoriaPatchesSettingsFiles() {
        try {
            ArrayList<Path> filesToUpdate = new ArrayList<Path>();
            ArrayList<Boolean> addVersionFlags = new ArrayList<Boolean>();
            Pattern euphoriaFilePattern = Pattern.compile("(?:Comp\\d+(?:\\.\\d+)*[rdp]?\\d*EP_|.*(?:EuphoriaPatches|Euphoria-Patches))", 2);
            try (DirectoryStream<Path> configStream = Files.newDirectoryStream(EuphoriaPatcher.shaderpacks, path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".txt"));){
                for (Path configFile : configStream) {
                    String fileName = configFile.getFileName().toString();
                    if (!euphoriaFilePattern.matcher(fileName).find()) continue;
                    boolean addVersionIdentifier = fileName.contains("_1.7.0");
                    filesToUpdate.add(configFile);
                    addVersionFlags.add(addVersionIdentifier);
                    UpdateShaderConfig.debugLog("Identified settings file: " + fileName);
                }
            }
            if (!filesToUpdate.isEmpty()) {
                UpdateShaderConfig.debugLog("Scheduling identifier updates for " + filesToUpdate.size() + " files after shader reload");
                scheduler.schedule(() -> {
                    for (int i = 0; i < filesToUpdate.size(); ++i) {
                        Path configFile = (Path)filesToUpdate.get(i);
                        boolean addVersionIdentifier = (Boolean)addVersionFlags.get(i);
                        UpdateShaderConfig.debugLog("Delayed processing of file: " + configFile.getFileName());
                        UpdateShaderConfig.addIdentifierToSettingsFile(configFile, addVersionIdentifier);
                    }
                }, 1000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (IOException e) {
            EuphoriaPatcher.log(2, 0, "Error preparing to mark settings files: " + e.getMessage());
        }
    }

    private static void addIdentifierToSettingsFile(Path configFile, boolean addVersionIdentifier) {
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                List<String> convertedLines;
                if (attempt > 0) {
                    Thread.sleep(200 * attempt);
                    EuphoriaPatcher.log(0, "Retry attempt " + attempt + " for file: " + configFile.getFileName());
                }
                UpdateShaderConfig.debugLog("Starting to process file: " + configFile.getFileName());
                if (!Files.isWritable(configFile)) {
                    UpdateShaderConfig.debugLog("File is not writable: " + configFile.getFileName());
                    return;
                }
                List<String> lines = Files.readAllLines(configFile, StandardCharsets.UTF_8);
                boolean settingsChanged = !lines.equals(convertedLines = ShaderSettingsConverter.convertLines(lines));
                lines = convertedLines;
                UpdateShaderConfig.debugLog("Applied settings conversions to file: " + configFile.getFileName() + (settingsChanged ? " (changes applied)" : " (no changes needed)"));
                boolean mainIdentifierExists = false;
                String existingVersionIdentifier = null;
                for (String line : lines) {
                    if (line.trim().equals(EUPHORIA_IDENTIFIER)) {
                        mainIdentifierExists = true;
                        continue;
                    }
                    if (!line.startsWith(VERSION_IDENTIFIER_PREFIX) || !line.endsWith(VERSION_IDENTIFIER_SUFFIX)) continue;
                    existingVersionIdentifier = line;
                }
                boolean identifiersAtTop = UpdateShaderConfig.areIdentifiersAtTop(lines);
                if (!settingsChanged && mainIdentifierExists && (!addVersionIdentifier || existingVersionIdentifier != null && existingVersionIdentifier.equals(UpdateShaderConfig.getVersionIdentifier())) && identifiersAtTop) {
                    UpdateShaderConfig.debugLog("No settings changes needed and identifiers are correctly positioned for: " + configFile.getFileName());
                    return;
                }
                if (!identifiersAtTop) {
                    UpdateShaderConfig.debugLog("Identifiers exist but are not at the top - will reposition them for: " + configFile.getFileName());
                }
                ArrayList<String> newLines = new ArrayList<String>();
                for (String line : lines) {
                    if (!line.trim().startsWith("#")) continue;
                    newLines.add(line);
                }
                newLines.add(EUPHORIA_IDENTIFIER);
                if (addVersionIdentifier) {
                    newLines.add(UpdateShaderConfig.getVersionIdentifier());
                } else if (existingVersionIdentifier != null) {
                    newLines.add(existingVersionIdentifier);
                    UpdateShaderConfig.debugLog("Preserved existing version identifier: " + existingVersionIdentifier);
                }
                for (String line : lines) {
                    String trimmed = line.trim();
                    if (trimmed.startsWith("#") || trimmed.equals(EUPHORIA_IDENTIFIER) || trimmed.startsWith(VERSION_IDENTIFIER_PREFIX) && trimmed.endsWith(VERSION_IDENTIFIER_SUFFIX)) continue;
                    newLines.add(line);
                }
                UpdateShaderConfig.debugLog("About to write to file: " + configFile.getFileName());
                try (BufferedWriter writer = Files.newBufferedWriter(configFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                    for (String line : newLines) {
                        writer.write(line);
                        writer.newLine();
                    }
                    writer.flush();
                }
                UpdateShaderConfig.debugLog("Updated identifiers in settings file: " + configFile.getFileName());
                break;
            }
            catch (IOException e) {
                if (attempt != 2) continue;
                EuphoriaPatcher.log(2, 0, "Error adding identifier to settings file " + configFile.getFileName() + ": " + e.getMessage());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    private static boolean areIdentifiersAtTop(List<String> lines) {
        boolean foundMainIdentifier = false;
        for (String line : lines) {
            String trimmed = line.trim();
            if (trimmed.isEmpty() || trimmed.startsWith("#")) continue;
            if (!foundMainIdentifier) {
                if (trimmed.equals(EUPHORIA_IDENTIFIER)) {
                    foundMainIdentifier = true;
                    continue;
                }
                return false;
            }
            if (!foundMainIdentifier) continue;
            if (trimmed.startsWith(VERSION_IDENTIFIER_PREFIX) && trimmed.endsWith(VERSION_IDENTIFIER_SUFFIX)) {
                return true;
            }
            return true;
        }
        return foundMainIdentifier;
    }

    private static void doConfigFileCopy(Path configFilePath, boolean containsPatchName, boolean styleUnbound, boolean styleReimagined) {
        String style = styleUnbound ? "Unbound" : "Reimagined";
        String newName = "Complementary" + style + "_r5.6 + EuphoriaPatches_1.7.0.txt";
        try {
            Path newPath = configFilePath.resolveSibling(newName);
            Files.copy(configFilePath, newPath, new CopyOption[0]);
            UpdateShaderConfig.addIdentifierToSettingsFile(newPath, true);
            EuphoriaPatcher.log(0, "Successfully updated shader config file to the latest version!");
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, 0, "Could not rename the config file: " + e.getMessage());
        }
        if (styleUnbound && styleReimagined) {
            EuphoriaPatcher.log(0, "Both shader styles detected!");
            try (DirectoryStream<Path> latestConfigTextStream = Files.newDirectoryStream(EuphoriaPatcher.shaderpacks, path -> UpdateShaderConfig.isConfigFile(path, containsPatchName));){
                Path latestShaderConfigFilePath = UpdateShaderConfig.findShaderConfigFile(latestConfigTextStream, false);
                if (latestShaderConfigFilePath != null) {
                    style = latestShaderConfigFilePath.toString().contains("Unbound") ? "Reimagined" : "Unbound";
                    newName = "Complementary" + style + "_r5.6 + EuphoriaPatches_1.7.0.txt";
                    try {
                        Path newPath = latestShaderConfigFilePath.resolveSibling(newName);
                        Files.copy(latestShaderConfigFilePath, newPath, new CopyOption[0]);
                        UpdateShaderConfig.addIdentifierToSettingsFile(newPath, true);
                        EuphoriaPatcher.log(0, "Successfully copied shader config file and renamed it!");
                    }
                    catch (IOException e) {
                        EuphoriaPatcher.log(3, 0, "Could not copy and rename the config file: " + e.getMessage());
                    }
                }
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, 0, "Error reading shaderpacks directory: " + e.getMessage());
            }
        }
    }

    private static boolean isConfigFile(Path path, boolean containsPatchName) {
        String nameText = path.getFileName().toString();
        if (containsPatchName) {
            boolean hasStandardName;
            boolean bl = hasStandardName = nameText.matches("(?:Comp\\d\\.\\d|Complementary).*") && nameText.endsWith(".txt") && (nameText.contains("EuphoriaPatches") || nameText.contains(" + EP_"));
            if (!hasStandardName) {
                return nameText.endsWith(".txt");
            }
            return true;
        }
        return nameText.matches(".*Complementary.*(Reimagined|Unbound).*") && nameText.endsWith(".txt");
    }

    private static Path findShaderConfigFile(DirectoryStream<Path> textStream, boolean searchOldEuphoriaConfigs) {
        String latestName;
        ArrayList<Path> euphoriaFiles = new ArrayList<Path>();
        ArrayList<Path> baseFiles = new ArrayList<Path>();
        ArrayList<Path> flaggedFiles = new ArrayList<Path>();
        for (Path potentialTextFile : textStream) {
            String name = potentialTextFile.getFileName().toString();
            if (!name.endsWith(".txt")) continue;
            if (name.contains("EuphoriaPatches") || name.contains("EP_")) {
                euphoriaFiles.add(potentialTextFile);
                UpdateShaderConfig.debugLog("Found Euphoria named file: " + name);
                continue;
            }
            String versionFromFile = UpdateShaderConfig.getEuphoriaPatchesVersionFromFile(potentialTextFile);
            if (versionFromFile != null) {
                flaggedFiles.add(potentialTextFile);
                UpdateShaderConfig.debugLog("Found flagged file: " + name + " with version " + versionFromFile);
                continue;
            }
            if (name.matches(".*Complementary.*(Reimagined|Unbound).*")) {
                baseFiles.add(potentialTextFile);
                UpdateShaderConfig.debugLog("Found base file: " + name);
                continue;
            }
            UpdateShaderConfig.debugLog("Skipping non-matching file: " + name);
        }
        UpdateShaderConfig.debugLog("Found " + euphoriaFiles.size() + " Euphoria files, " + flaggedFiles.size() + " flagged files, and " + baseFiles.size() + " base files");
        if (!euphoriaFiles.isEmpty()) {
            UpdateShaderConfig.debugLog("Sorting Euphoria files by version...");
            euphoriaFiles.sort((p1, p2) -> UpdateShaderConfig.compareConfigFileVersions(UpdateShaderConfig.getConfigFileVersion(p1), UpdateShaderConfig.getConfigFileVersion(p2)));
            Path latestEuphoriaConfig = (Path)euphoriaFiles.get(euphoriaFiles.size() - 1);
            latestName = latestEuphoriaConfig.getFileName().toString();
            if (searchOldEuphoriaConfigs) {
                if (!latestName.contains("_1.7.0") || latestName.contains("dev")) {
                    UpdateShaderConfig.debugLog("Selected old Euphoria config: " + latestName);
                    return latestEuphoriaConfig;
                }
            } else {
                UpdateShaderConfig.debugLog("Selected latest Euphoria config: " + latestName);
                return latestEuphoriaConfig;
            }
        }
        if (!flaggedFiles.isEmpty()) {
            UpdateShaderConfig.debugLog("Sorting flagged files by embedded version...");
            flaggedFiles.sort((p1, p2) -> UpdateShaderConfig.compareConfigFileVersions(UpdateShaderConfig.getConfigFileVersion(p1), UpdateShaderConfig.getConfigFileVersion(p2)));
            Path latestFlaggedFile = (Path)flaggedFiles.get(flaggedFiles.size() - 1);
            latestName = latestFlaggedFile.getFileName().toString();
            UpdateShaderConfig.debugLog("Selected flagged file: " + latestName + " with embedded version: " + UpdateShaderConfig.getEuphoriaPatchesVersionFromFile(latestFlaggedFile));
            return latestFlaggedFile;
        }
        if (!baseFiles.isEmpty()) {
            UpdateShaderConfig.debugLog("No Euphoria files found, falling back to base files");
            baseFiles.sort((p1, p2) -> UpdateShaderConfig.compareConfigFileVersions(UpdateShaderConfig.getConfigFileVersion(p1), UpdateShaderConfig.getConfigFileVersion(p2)));
            Path latestBaseFile = (Path)baseFiles.get(baseFiles.size() - 1);
            UpdateShaderConfig.debugLog("Selected base file: " + latestBaseFile.getFileName());
            return latestBaseFile;
        }
        UpdateShaderConfig.debugLog("No suitable config file found");
        return null;
    }

    private static String getEuphoriaPatchesVersionFromFile(Path file) {
        try {
            List<String> lines = Files.readAllLines(file);
            boolean foundMainIdentifier = false;
            for (String line : lines) {
                if (line.trim().equals(EUPHORIA_IDENTIFIER)) {
                    foundMainIdentifier = true;
                    UpdateShaderConfig.debugLog("Found main identifier in file: " + file.getFileName());
                    continue;
                }
                if (!foundMainIdentifier || !line.startsWith(VERSION_IDENTIFIER_PREFIX) || !line.endsWith(VERSION_IDENTIFIER_SUFFIX)) continue;
                String version = UpdateShaderConfig.extractVersionFromIdentifier(line);
                UpdateShaderConfig.debugLog("Found version identifier in file: " + file.getFileName() + " - " + version);
                return version;
            }
            if (foundMainIdentifier) {
                UpdateShaderConfig.debugLog("Found main identifier but no version in file: " + file.getFileName() + " - using default 1.0.0");
                return "_1.0.0";
            }
            UpdateShaderConfig.debugLog("Main identifier not found in file: " + file.getFileName());
        }
        catch (IOException e) {
            EuphoriaPatcher.log(0, "Error reading file " + file.getFileName() + ": " + e.getMessage());
        }
        return null;
    }

    private static String getConfigFileVersion(Path path) {
        String versionFromFile = UpdateShaderConfig.getEuphoriaPatchesVersionFromFile(path);
        if (versionFromFile != null) {
            String result = versionFromFile.substring(1) + "|0";
            UpdateShaderConfig.debugLog("Using embedded version for " + path.getFileName() + ": " + result);
            return result;
        }
        String name = path.getFileName().toString();
        Pattern euphoriaPattern = Pattern.compile("(?:[a-zA-Z_]+)?[rdp]?(\\d+(?:\\.\\d+)*)(?:[rdp]\\d+)?(?: \\+ )?(?:EuphoriaPatches_|EP_)(\\d+(?:\\.\\d+)*(?:-dev\\d+)?)");
        Matcher euphoriaMatcher = euphoriaPattern.matcher(name);
        if (euphoriaMatcher.find()) {
            String mainVersion = euphoriaMatcher.group(1);
            String patchVersion = euphoriaMatcher.group(2);
            if (patchVersion != null) {
                String result = patchVersion + "|" + mainVersion;
                UpdateShaderConfig.debugLog("Extracted Euphoria version from filename " + name + ": " + result);
                return result;
            }
            UpdateShaderConfig.debugLog("Found main version only in " + name + ": 0|" + mainVersion);
            return "0|" + mainVersion;
        }
        Pattern basePattern = Pattern.compile(".*Complementary.*[_r]([\\d.]+).*");
        Matcher baseMatcher = basePattern.matcher(name);
        if (baseMatcher.find()) {
            String baseVersion = baseMatcher.group(1);
            String result = "0|" + baseVersion;
            UpdateShaderConfig.debugLog("Extracted base version from filename " + name + ": " + result);
            return result;
        }
        UpdateShaderConfig.debugLog("Could not extract any version from " + name + ", using default 0|0");
        return "0|0";
    }

    private static int compareConfigFileVersions(String v1, String v2) {
        String[] fullVersion2;
        String[] fullVersion1 = v1.split("\\|");
        int epCompare = UpdateShaderConfig.compareVersionParts(fullVersion1[0], (fullVersion2 = v2.split("\\|"))[0]);
        if (epCompare != 0) {
            UpdateShaderConfig.debugLog("Comparing versions: " + v1 + " vs " + v2 + " - patch versions differ: " + epCompare);
            return epCompare;
        }
        int result = UpdateShaderConfig.compareVersionParts(fullVersion1[1], fullVersion2[1]);
        UpdateShaderConfig.debugLog("Comparing versions: " + v1 + " vs " + v2 + " - main versions: " + result);
        return result;
    }

    private static int compareVersionParts(String p1, String p2) {
        String[] parts1 = p1.split("[.\\-]");
        String[] parts2 = p2.split("[.\\-]");
        int length = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            String part1 = i < parts1.length ? parts1[i] : "0";
            String part2 = i < parts2.length ? parts2[i] : "0";
            boolean isP1Dev = part1.contains("dev");
            boolean isP2Dev = part2.contains("dev");
            if (isP1Dev && isP2Dev) {
                String[] devParts1 = part1.split("dev");
                String[] devParts2 = part2.split("dev");
                UpdateShaderConfig.debugLog(devParts1[1] + "  " + devParts2[1]);
                int mainCompare = Integer.compare(Integer.parseInt(devParts1[1]), Integer.parseInt(devParts2[1]));
                if (mainCompare != 0) {
                    return mainCompare;
                }
                return Integer.parseInt(devParts1[1]);
            }
            if (isP1Dev) {
                return -1;
            }
            if (isP2Dev) {
                return 1;
            }
            int compare = Integer.compare(Integer.parseInt(part1), Integer.parseInt(part2));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

