/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject.vertexAttribute;

import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.AbstractVertexAttribute;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexPointer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.lwjgl.opengl.GL32;

public final class VertexAttributePreGL43
extends AbstractVertexAttribute {
    int strideSize = 0;
    int[][] bindingPointsToIndex;
    VertexPointer[] pointers;
    int[] pointersOffset;
    TreeMap<Integer, TreeSet<Integer>> bindingPointsToIndexBuilder = new TreeMap();
    ArrayList<VertexPointer> pointersBuilder = new ArrayList();

    @Override
    public void bindBufferToAllBindingPoints(int buffer) {
        int i;
        for (i = 0; i < this.pointers.length; ++i) {
            GL32.glEnableVertexAttribArray((int)i);
        }
        for (i = 0; i < this.pointers.length; ++i) {
            VertexPointer pointer = this.pointers[i];
            if (pointer == null) continue;
            if (pointer.useInteger) {
                GL32.glVertexAttribIPointer((int)i, (int)pointer.elementCount, (int)pointer.glType, (int)this.strideSize, (long)this.pointersOffset[i]);
                continue;
            }
            GL32.glVertexAttribPointer((int)i, (int)pointer.elementCount, (int)pointer.glType, (boolean)pointer.normalized, (int)this.strideSize, (long)this.pointersOffset[i]);
        }
    }

    @Override
    public void bindBufferToBindingPoint(int buffer, int bindingPoint) {
        int[] bindingPointIndexes;
        for (int bindingPointIndex : bindingPointIndexes = this.bindingPointsToIndex[bindingPoint]) {
            GL32.glEnableVertexAttribArray((int)bindingPointIndex);
        }
        for (int bindingPointIndex : bindingPointIndexes) {
            VertexPointer pointer = this.pointers[bindingPointIndex];
            if (pointer == null) continue;
            if (pointer.useInteger) {
                GL32.glVertexAttribIPointer((int)bindingPointIndex, (int)pointer.elementCount, (int)pointer.glType, (int)this.strideSize, (long)this.pointersOffset[bindingPointIndex]);
                continue;
            }
            GL32.glVertexAttribPointer((int)bindingPointIndex, (int)pointer.elementCount, (int)pointer.glType, (boolean)pointer.normalized, (int)this.strideSize, (long)this.pointersOffset[bindingPointIndex]);
        }
    }

    @Override
    public void unbindBuffersFromAllBindingPoint() {
        for (int i = 0; i < this.pointers.length; ++i) {
            GL32.glDisableVertexAttribArray((int)i);
        }
    }

    @Override
    public void unbindBuffersFromBindingPoint(int bindingPoint) {
        int[] bindingPointIndexes;
        for (int bindingPointIndex : bindingPointIndexes = this.bindingPointsToIndex[bindingPoint]) {
            GL32.glDisableVertexAttribArray((int)bindingPointIndex);
        }
    }

    @Override
    public void setVertexAttribute(int bindingPoint, int attributeIndex, VertexPointer attribute) {
        TreeSet intArray = this.bindingPointsToIndexBuilder.computeIfAbsent(bindingPoint, k -> new TreeSet());
        intArray.add(attributeIndex);
        while (this.pointersBuilder.size() <= attributeIndex) {
            this.pointersBuilder.add(null);
        }
        this.pointersBuilder.set(attributeIndex, attribute);
    }

    @Override
    public void completeAndCheck(int expectedStrideSize) {
        VertexPointer pointer;
        int i2;
        int maxBindPointNumber = this.bindingPointsToIndexBuilder.lastKey();
        this.bindingPointsToIndex = new int[maxBindPointNumber + 1][];
        this.bindingPointsToIndexBuilder.forEach((i, set) -> {
            this.bindingPointsToIndex[i.intValue()] = new int[set.size()];
            Iterator iter = set.iterator();
            for (int j = 0; j < set.size(); ++j) {
                this.bindingPointsToIndex[i.intValue()][j] = (Integer)iter.next();
            }
        });
        this.pointers = this.pointersBuilder.toArray(new VertexPointer[this.pointersBuilder.size()]);
        this.pointersOffset = new int[this.pointers.length];
        this.pointersBuilder = null;
        this.bindingPointsToIndexBuilder = null;
        int currentOffset = 0;
        for (i2 = 0; i2 < this.pointers.length; ++i2) {
            pointer = this.pointers[i2];
            if (pointer == null) {
                GLProxy.GL_LOGGER.warn("Vertex Attribute index " + i2 + " is not set! No index should be skipped normally!", new Object[0]);
                continue;
            }
            this.pointersOffset[i2] = currentOffset;
            currentOffset += pointer.byteSize;
        }
        if (currentOffset != expectedStrideSize) {
            GLProxy.GL_LOGGER.error("Vertex Attribute calculated stride size " + currentOffset + " does not match the provided expected stride size " + expectedStrideSize + "!", new Object[0]);
            throw new IllegalArgumentException("Vertex Attribute Incorrect Format");
        }
        this.strideSize = currentOffset;
        GLProxy.GL_LOGGER.info("Vertex Attribute (pre GL43) completed.", new Object[0]);
        GLProxy.GL_LOGGER.debug("AttributeIndex: ElementCount, glType, normalized, strideSize, offset", new Object[0]);
        for (i2 = 0; i2 < this.pointers.length; ++i2) {
            pointer = this.pointers[i2];
            if (pointer == null) {
                GLProxy.GL_LOGGER.debug(i2 + ": Null!!!!", new Object[0]);
                continue;
            }
            GLProxy.GL_LOGGER.debug(i2 + ": " + pointer.elementCount + ", " + pointer.glType + ", " + pointer.normalized + ", " + this.strideSize + ", " + this.pointersOffset[i2], new Object[0]);
        }
    }
}

