/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.storage_container;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.packager.InventoryIdentifier;
import com.simibubi.create.foundation.ICapabilityProvider;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryWrapper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.lopyluna.dndecor.content.blocks.storage_container.ColoredStorageContainerBlock;
import dev.lopyluna.dndecor.register.DnDecorBETypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class ColoredStorageContainerBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Inventory {
    protected ICapabilityProvider<IItemHandler> itemCapability;
    protected InventoryIdentifier invId;
    protected ItemStackHandler inventory;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    protected int radius;
    protected int length;
    protected Direction.Axis axis;
    protected int checkTickRate;
    protected int checkTickCounter;

    public ColoredStorageContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setCheckTickRate(4);
        this.inventory = new ItemStackHandler((Integer)AllConfigs.server().logistics.vaultCapacity.get()){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ColoredStorageContainerBlockEntity.this.updateComparators();
            }
        };
        this.radius = 1;
        this.length = 1;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)DnDecorBETypes.COLORED_STORAGE_CONTAINER.get(), (be, context) -> {
            be.initCapability();
            if (be.itemCapability == null) {
                return null;
            }
            return (IItemHandler)be.itemCapability.getCapability();
        });
    }

    public void initialize() {
        super.initialize();
        this.repairContainer();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (Objects.requireNonNull(this.getLevel()).isClientSide()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
        this.updateColors();
    }

    protected void updateComparators() {
        ColoredStorageContainerBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        Objects.requireNonNull(this.getLevel()).blockEntityChanged(controllerBE.worldPosition);
        BlockPos pos = controllerBE.getBlockPos();
        for (int y = 0; y < controllerBE.radius; ++y) {
            for (int z = 0; z < (controllerBE.axis == Direction.Axis.X ? controllerBE.radius : controllerBE.length); ++z) {
                for (int x = 0; x < (controllerBE.axis == Direction.Axis.Z ? controllerBE.radius : controllerBE.length); ++x) {
                    this.getLevel().updateNeighbourForOutputSignal(pos.offset(x, y, z), this.getBlockState().getBlock());
                }
            }
        }
    }

    public void updateCheck() {
        if (this.getControllerBE() == null) {
            return;
        }
        if (this.getControllerBE().getBlockState().getValue(ColoredStorageContainerBlock.COLOR) != this.getBlockState().getValue(ColoredStorageContainerBlock.COLOR)) {
            this.updateColors();
        }
    }

    public void repairContainer() {
        if (this.getControllerBE() == null) {
            return;
        }
        if (this.getControllerBE().getBlockState().getValue(ColoredStorageContainerBlock.COLOR) != this.getBlockState().getValue(ColoredStorageContainerBlock.COLOR)) {
            Objects.requireNonNull(this.getLevel()).setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(ColoredStorageContainerBlock.COLOR, (Comparable)((DyeColor)this.getControllerBE().getBlockState().getValue(ColoredStorageContainerBlock.COLOR))));
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.checkTickCounter <= 0) {
            this.checkTickCounter = this.checkTickRate;
            this.repairContainer();
        } else {
            this.updateCheck();
        }
    }

    public void setCheckTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.getBlockPos();
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition) && this.worldPosition != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.worldPosition;
    }

    public ColoredStorageContainerBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = Objects.requireNonNull(this.getLevel()).getBlockEntity(this.controller);
        if (blockEntity instanceof ColoredStorageContainerBlockEntity) {
            ColoredStorageContainerBlockEntity be = (ColoredStorageContainerBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    public void removeController(boolean keepContents) {
        if (Objects.requireNonNull(this.getLevel()).isClientSide()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.length = 1;
        BlockState state = this.getBlockState();
        if (ColoredStorageContainerBlock.isVault(state)) {
            state = (BlockState)state.setValue((Property)ColoredStorageContainerBlock.LARGE, (Comparable)Boolean.valueOf(false));
            this.getLevel().setBlock(this.worldPosition, state, 22);
        }
        this.itemCapability = null;
        this.invalidateCapabilities();
        this.setChanged();
        this.sendData();
    }

    public void setController(BlockPos controller) {
        if (Objects.requireNonNull(this.getLevel()).isClientSide && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.itemCapability = null;
        this.invalidateCapabilities();
        this.setChanged();
        this.sendData();
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    public void updateColors() {
        Objects.requireNonNull(this.getLevel()).setBlockAndUpdate(this.getControllerBE().getBlockPos(), (BlockState)this.getControllerBE().getBlockState().setValue(ColoredStorageContainerBlock.COLOR, (Comparable)this.getMostColor()));
        if (this.isController()) {
            for (int y = 0; y < this.radius; ++y) {
                for (int z = 0; z < (this.getControllerBE().axis == Direction.Axis.X ? this.radius : this.length); ++z) {
                    for (int x = 0; x < (this.getControllerBE().axis == Direction.Axis.Z ? this.radius : this.length); ++x) {
                        BlockPos pos = this.getControllerBE().getBlockPos().offset(x, y, z);
                        BlockState stateAtPos = Objects.requireNonNull(this.getLevel()).getBlockState(pos);
                        BlockEntity blockEntity = this.getLevel().getBlockEntity(pos);
                        if (blockEntity instanceof ColoredStorageContainerBlockEntity) {
                            ColoredStorageContainerBlockEntity be = (ColoredStorageContainerBlockEntity)blockEntity;
                            if (this.getController() != be.getController()) continue;
                        }
                        if (stateAtPos.isAir() || !stateAtPos.hasProperty(ColoredStorageContainerBlock.COLOR) || this.getMostColor() == null) continue;
                        this.getLevel().setBlockAndUpdate(pos, (BlockState)stateAtPos.setValue(ColoredStorageContainerBlock.COLOR, (Comparable)this.getMostColor()));
                    }
                }
            }
        }
    }

    public DyeColor getMostColor() {
        HashMap<DyeColor, Integer> colorCountMap = new HashMap<DyeColor, Integer>();
        DyeColor colorController = (DyeColor)this.getControllerBE().getBlockState().getValue(ColoredStorageContainerBlock.COLOR);
        colorCountMap.put(colorController, colorCountMap.getOrDefault(colorController, 0) + 1);
        if (this.isController()) {
            for (int y = 0; y < this.radius; ++y) {
                for (int z = 0; z < (this.getControllerBE().axis == Direction.Axis.X ? this.radius : this.length); ++z) {
                    for (int x = 0; x < (this.getControllerBE().axis == Direction.Axis.Z ? this.radius : this.length); ++x) {
                        BlockPos pos = this.getControllerBE().getBlockPos().offset(x, y, z);
                        BlockState stateAtPos = Objects.requireNonNull(this.getLevel()).getBlockState(pos);
                        BlockEntity blockEntity = this.getLevel().getBlockEntity(pos);
                        if (blockEntity instanceof ColoredStorageContainerBlockEntity) {
                            ColoredStorageContainerBlockEntity be = (ColoredStorageContainerBlockEntity)blockEntity;
                            if (this.getController() != be.getController()) continue;
                        }
                        if (stateAtPos.isAir() || !stateAtPos.hasProperty(ColoredStorageContainerBlock.COLOR)) continue;
                        DyeColor color = (DyeColor)stateAtPos.getValue(ColoredStorageContainerBlock.COLOR);
                        colorCountMap.put(color, colorCountMap.getOrDefault(color, 0) + 1);
                    }
                }
            }
        }
        return colorCountMap.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(null);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, registries, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevLength = this.length;
        this.updateConnectivity = compound.contains("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.contains("LastKnownPos")) {
            this.lastKnownPos = NBTHelper.readBlockPos((CompoundTag)compound, (String)"LastKnownPos");
        }
        if (compound.contains("Controller")) {
            this.controller = NBTHelper.readBlockPos((CompoundTag)compound, (String)"Controller");
        }
        if (this.isController()) {
            this.radius = compound.getInt("Size");
            this.length = compound.getInt("Length");
        }
        if (!clientPacket) {
            this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (this.hasLevel() && (changeOfController || prevSize != this.radius || prevLength != this.length)) {
            Objects.requireNonNull(this.getLevel()).setBlocksDirty(this.getBlockPos(), Blocks.AIR.defaultBlockState(), this.getBlockState());
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.putInt("Size", this.radius);
            compound.putInt("Length", this.length);
        }
        super.write(compound, registries, clientPacket);
        if (!clientPacket) {
            compound.putString("StorageType", "CombinedInv");
            compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        }
    }

    public ItemStackHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, i < handler.getSlots() ? handler.getStackInSlot(i) : ItemStack.EMPTY);
        }
    }

    private void initCapability() {
        assert (this.level != null);
        if (this.itemCapability != null && this.itemCapability.getCapability() != null) {
            return;
        }
        if (!this.isController()) {
            ColoredStorageContainerBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            controllerBE.initCapability();
            this.itemCapability = ICapabilityProvider.of(() -> {
                if (controllerBE.isRemoved()) {
                    return null;
                }
                if (controllerBE.itemCapability == null) {
                    return null;
                }
                return (IItemHandler)controllerBE.itemCapability.getCapability();
            });
            this.invId = controllerBE.invId;
            return;
        }
        boolean alongZ = ColoredStorageContainerBlock.getVaultBlockAxis(this.getBlockState()) == Direction.Axis.Z;
        IItemHandlerModifiable[] invs = new IItemHandlerModifiable[this.length * this.radius * this.radius];
        for (int yOffset = 0; yOffset < this.length; ++yOffset) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    BlockPos vaultPos = alongZ ? this.worldPosition.offset(xOffset, zOffset, yOffset) : this.worldPosition.offset(yOffset, xOffset, zOffset);
                    ColoredStorageContainerBlockEntity vaultAt = (ColoredStorageContainerBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)DnDecorBETypes.COLORED_STORAGE_CONTAINER.get()), (BlockGetter)this.level, (BlockPos)vaultPos);
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = vaultAt != null ? vaultAt.inventory : new ItemStackHandler();
                }
            }
        }
        this.itemCapability = ICapabilityProvider.of((Object)new VersionedInventoryWrapper((IItemHandlerModifiable)new CombinedInvWrapper(invs)));
        BlockPos farCorner = alongZ ? this.worldPosition.offset(this.radius, this.radius, this.length) : this.worldPosition.offset(this.length, this.radius, this.radius);
        BoundingBox bounds = BoundingBox.fromCorners((Vec3i)this.worldPosition, (Vec3i)farCorner);
        this.invId = new InventoryIdentifier.Bounds(bounds);
    }

    public static int getMaxLength(int radius) {
        return radius * 3;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.getBlockState();
        if (ColoredStorageContainerBlock.isVault(state)) {
            Objects.requireNonNull(this.getLevel()).setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)ColoredStorageContainerBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
        }
        this.itemCapability = null;
        this.invalidateCapabilities();
        this.setChanged();
    }

    public Direction.Axis getMainConnectionAxis() {
        return this.getMainAxisOf((BlockEntity)this);
    }

    public InventoryIdentifier getInvId() {
        this.initCapability();
        return this.invId;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return this.getMaxWidth();
        }
        return ColoredStorageContainerBlockEntity.getMaxLength(width);
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.length;
    }

    public int getWidth() {
        return this.radius;
    }

    public void setHeight(int height) {
        this.length = height;
    }

    public void setWidth(int width) {
        this.radius = width;
    }

    public boolean hasInventory() {
        return true;
    }
}

