/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.texture;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.util.ResourceUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TextureUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static int[] loadTextureData(ResourceLocation resource) {
        BufferedImage img = TextureUtils.loadBufferedImage(resource);
        if (img == null) {
            return new int[0];
        }
        int w = img.getWidth();
        int h = img.getHeight();
        int[] data = new int[w * h];
        img.getRGB(0, 0, w, h, data, 0, w);
        return data;
    }

    public static Colour[] loadTextureColours(ResourceLocation resource) {
        int[] idata = TextureUtils.loadTextureData(resource);
        Colour[] data = new Colour[idata.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new ColourARGB(idata[i]);
        }
        return data;
    }

    @Nullable
    public static BufferedImage loadBufferedImage(ResourceLocation textureFile) {
        try {
            return TextureUtils.loadBufferedImage(ResourceUtils.getResourceAsStream(textureFile));
        }
        catch (Exception ex) {
            LOGGER.error("failed to load texture {}", (Object)textureFile, (Object)ex);
            return null;
        }
    }

    public static BufferedImage loadBufferedImage(InputStream in) throws IOException {
        BufferedImage img = ImageIO.read(in);
        in.close();
        return img;
    }

    public static void copySubImg(int[] fromTex, int fromWidth, int fromX, int fromY, int width, int height, int[] toTex, int toWidth, int toX, int toY) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int fp = (y + fromY) * fromWidth + x + fromX;
                int tp = (y + toX) * toWidth + x + toX;
                toTex[tp] = fromTex[fp];
            }
        }
    }

    public static TextureManager getTextureManager() {
        return Minecraft.getInstance().getTextureManager();
    }

    public static TextureAtlas getTextureMap() {
        return Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS);
    }

    public static TextureAtlasSprite getMissingSprite() {
        return TextureUtils.getTextureMap().getSprite(MissingTextureAtlasSprite.getLocation());
    }

    public static TextureAtlasSprite getTexture(String location) {
        return TextureUtils.getTextureMap().getSprite(ResourceLocation.parse((String)location));
    }

    public static TextureAtlasSprite getTexture(ResourceLocation location) {
        return TextureUtils.getTextureMap().getSprite(location);
    }

    public static TextureAtlasSprite getBlockTexture(String string) {
        return TextureUtils.getBlockTexture(ResourceLocation.parse((String)string));
    }

    public static TextureAtlasSprite getBlockTexture(ResourceLocation location) {
        return TextureUtils.getTexture(ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("block/" + location.getPath())));
    }

    public static TextureAtlasSprite getItemTexture(String string) {
        return TextureUtils.getItemTexture(ResourceLocation.parse((String)string));
    }

    public static TextureAtlasSprite getItemTexture(ResourceLocation location) {
        return TextureUtils.getTexture(ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("items/" + location.getPath())));
    }
}

