/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakedmodels;

import codechicken.lib.model.CachedFormat;
import codechicken.lib.model.PerspectiveModel;
import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.render.particle.IModelParticleProvider;
import codechicken.lib.util.VertexUtils;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.ConcatenatedListView;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class AbstractBakedPropertiesModel
implements PerspectiveModel,
IModelParticleProvider,
BakedModel {
    protected final ModelProperties properties;

    public AbstractBakedPropertiesModel(ModelProperties properties) {
        this.properties = properties;
    }

    public boolean useAmbientOcclusion() {
        return this.properties.isAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.properties.isGui3d();
    }

    public boolean isCustomRenderer() {
        return this.properties.isBuiltInRenderer();
    }

    public boolean usesBlockLight() {
        return this.properties.usesBlockLight();
    }

    @Override
    public TextureAtlasSprite getParticleIcon() {
        return this.properties.getParticleTexture();
    }

    protected List<BakedQuad> getAllQuads(BlockState state, ModelData modelData) {
        LinkedList<List> quadsList = new LinkedList<List>();
        for (RenderType layer : this.getRenderTypes(state, RandomSource.create((long)42L), modelData)) {
            quadsList.add(this.getQuads(state, null, RandomSource.create((long)0L), modelData, layer));
            for (Direction face : Direction.BY_3D_DATA) {
                quadsList.add(this.getQuads(state, face, RandomSource.create((long)0L), modelData, layer));
            }
        }
        return ConcatenatedListView.of(quadsList);
    }

    @Override
    public Set<TextureAtlasSprite> getHitEffects(BlockHitResult traceResult, BlockState state, BlockAndTintGetter world, BlockPos pos, ModelData modelData) {
        Vector3 vec = new Vector3(traceResult.getLocation()).subtract((Vec3i)traceResult.getBlockPos());
        return this.getAllQuads(state, modelData).stream().filter(quad -> quad.getDirection() == traceResult.getDirection()).filter(quad -> this.checkDepth((BakedQuad)quad, vec, traceResult.getDirection())).map(BakedQuad::getSprite).collect(Collectors.toSet());
    }

    protected boolean checkDepth(BakedQuad quad, Vector3 hit, Direction hitFace) {
        int[] quadData = quad.getVertices();
        CachedFormat format = CachedFormat.lookup(DefaultVertexFormat.BLOCK);
        Vector3 posVec = new Vector3();
        float[] pos = new float[4];
        for (int v = 0; v < 4; ++v) {
            VertexUtils.unpack(quadData, pos, format.format, v, format.positionIndex);
            posVec.add(pos[0], pos[1], pos[2]);
        }
        posVec.divide(4.0);
        double diff = switch (hitFace.getAxis()) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> Math.abs(hit.x - posVec.x);
            case Direction.Axis.Y -> Math.abs(hit.y - posVec.y);
            case Direction.Axis.Z -> Math.abs(hit.z - posVec.z);
        };
        return !(diff > 0.01);
    }

    @Override
    public Set<TextureAtlasSprite> getDestroyEffects(BlockState state, BlockAndTintGetter world, BlockPos pos, ModelData data) {
        return this.getAllQuads(state, data).stream().map(BakedQuad::getSprite).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public PerspectiveModelState getModelState() {
        PerspectiveModelState perspectiveModelState;
        ModelProperties modelProperties = this.properties;
        if (modelProperties instanceof ModelProperties.PerspectiveProperties) {
            ModelProperties.PerspectiveProperties props = (ModelProperties.PerspectiveProperties)modelProperties;
            perspectiveModelState = props.getTransforms();
        } else {
            perspectiveModelState = null;
        }
        return perspectiveModelState;
    }

    @Override
    public BakedModel applyTransform(ItemDisplayContext context, PoseStack pStack, boolean leftFlip) {
        return PerspectiveModel.super.applyTransform(context, pStack, leftFlip);
    }
}

