/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.elements;

import codechicken.lib.colour.Colour;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiManipulable;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiSlider;
import codechicken.lib.gui.modular.elements.GuiTextField;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.ColourState;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.SliderState;
import codechicken.lib.gui.modular.lib.TextState;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class GuiColourPicker
extends GuiManipulable {
    private ColourState colourState = ColourState.create();
    private final Colour initialColour;
    private boolean blockOutsideClicks = false;
    private boolean closeOnOutsideClick = false;
    private GuiButton okButton;
    private GuiButton cancelButton;

    public GuiColourPicker(@NotNull GuiParent<?> parent, Colour initialColour) {
        super(parent);
        this.initialColour = initialColour;
    }

    public static GuiColourPicker create(GuiParent<?> guiParent, ColourState colourState) {
        return GuiColourPicker.create(guiParent, colourState, true);
    }

    public static GuiColourPicker create(GuiParent<?> guiParent, ColourState colourState, boolean hasAlpha) {
        GuiColourPicker picker = new GuiColourPicker(guiParent.getModularGui().getRoot(), colourState.getColour());
        picker.setOpaque(true);
        picker.setColourState(colourState);
        Constraints.size(picker, 80.0, hasAlpha ? 80.0 : 70.0);
        GuiRectangle background = GuiRectangle.toolTipBackground(picker.getContentElement());
        Constraints.bind(background, picker.getContentElement());
        GuiTextField.TextField hexField = GuiTextField.create(background, -16777216, -11513776, 0xE0E0E0);
        hexField.field().setTextState(picker.getTextState()).setMaxLength(hasAlpha ? 8 : 6).setFilter(s -> s.isEmpty() || GuiColourPicker.validHex(s));
        ((GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)hexField.container().setOpaque(true)).constrain(GeoParam.HEIGHT, Constraint.literal(12.0))).constrain(GeoParam.TOP, Constraint.relative(background.get(GeoParam.TOP), 4.0))).constrain(GeoParam.LEFT, Constraint.relative(background.get(GeoParam.LEFT), 4.0))).constrain(GeoParam.RIGHT, Constraint.relative(background.get(GeoParam.RIGHT), -4.0));
        SliderBG slider = (SliderBG)GuiColourPicker.makeSlider(background, -65536, picker.sliderStateRed()).constrain(GeoParam.TOP, Constraint.relative(hexField.container().get(GeoParam.BOTTOM), 2.0));
        slider = (SliderBG)GuiColourPicker.makeSlider(background, -16711936, picker.sliderStateGreen()).constrain(GeoParam.TOP, Constraint.relative(slider.get(GeoParam.BOTTOM), 1.0));
        slider = (SliderBG)GuiColourPicker.makeSlider(background, -16776961, picker.sliderStateBlue()).constrain(GeoParam.TOP, Constraint.relative(slider.get(GeoParam.BOTTOM), 1.0));
        if (hasAlpha) {
            slider = (SliderBG)GuiColourPicker.makeSlider(background, -1, picker.sliderStateAlpha()).constrain(GeoParam.TOP, Constraint.relative(slider.get(GeoParam.BOTTOM), 1.0));
        } else {
            colourState.set(colourState.getColour().aF(0));
        }
        ColourPreview preview = (ColourPreview)((ColourPreview)((ColourPreview)((ColourPreview)((ColourPreview)new ColourPreview(background, () -> hasAlpha ? colourState.get() : colourState.get() | 0xFF000000).setOpaque(true)).constrain(GeoParam.HEIGHT, Constraint.literal(6.0))).constrain(GeoParam.TOP, Constraint.relative(slider.get(GeoParam.BOTTOM), 2.0))).constrain(GeoParam.LEFT, Constraint.relative(background.get(GeoParam.LEFT), 4.0))).constrain(GeoParam.RIGHT, Constraint.relative(background.get(GeoParam.RIGHT), -4.0));
        picker.cancelButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)GuiButton.flatColourButton(background, () -> Component.translatable((String)"gui.cancel"), e -> -16777216, e -> e != false ? -8947849 : -11184811).setOpaque(true)).onPress(picker::cancel).constrain(GeoParam.HEIGHT, Constraint.literal(10.0))).constrain(GeoParam.TOP, Constraint.relative(preview.get(GeoParam.BOTTOM), 2.0))).constrain(GeoParam.LEFT, Constraint.midPoint(background.get(GeoParam.LEFT), background.get(GeoParam.RIGHT), -4.0))).constrain(GeoParam.RIGHT, Constraint.relative(background.get(GeoParam.RIGHT), -4.0));
        picker.okButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)GuiButton.flatColourButton(background, () -> Component.translatable((String)"gui.ok"), e -> -16777216, e -> e != false ? -8947849 : -11184811).setOpaque(true)).onPress(() -> picker.getParent().removeChild(picker)).constrain(GeoParam.HEIGHT, Constraint.literal(10.0))).constrain(GeoParam.TOP, Constraint.relative(preview.get(GeoParam.BOTTOM), 2.0))).constrain(GeoParam.LEFT, Constraint.relative(background.get(GeoParam.LEFT), 4.0))).constrain(GeoParam.RIGHT, Constraint.dynamic(() -> picker.cancelButton.isEnabled() ? picker.cancelButton.xMin() - 2.0 : background.xMax() - 4.0));
        return picker;
    }

    public static SliderBG makeSlider(GuiElement<?> background, int colour, SliderState state) {
        SliderBG slideBG = (SliderBG)((SliderBG)((SliderBG)((SliderBG)new SliderBG(background, -11513776, 0x30FFFFFF).setOpaque(true)).constrain(GeoParam.HEIGHT, Constraint.literal(9.0))).constrain(GeoParam.LEFT, Constraint.relative(background.get(GeoParam.LEFT), 4.0))).constrain(GeoParam.RIGHT, Constraint.relative(background.get(GeoParam.RIGHT), -4.0));
        GuiSlider slider = new GuiSlider(slideBG, Axis.X).setSliderState(state);
        Constraints.bind(slider, slideBG, 0.0, 1.0, 0.0, 1.0);
        slideBG.slider = slider;
        GuiRectangle handle = (GuiRectangle)new GuiRectangle(slider).fill(colour).border(-16777216).borderWidth(0.5).constrain(GeoParam.WIDTH, Constraint.literal(4.0));
        slider.installSlider(handle).bindSliderWidth();
        return slideBG;
    }

    public GuiColourPicker setBlockOutsideClicks(boolean blockOutsideClicks) {
        this.blockOutsideClicks = blockOutsideClicks;
        return this;
    }

    public GuiColourPicker setCancelOnOutsideClick(boolean closeOnOutsideClick) {
        this.closeOnOutsideClick = closeOnOutsideClick;
        return this;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button, boolean consumed) {
        if (this.closeOnOutsideClick && !this.getContentElement().getRectangle().contains(mouseX, mouseY)) {
            this.cancel();
        }
        return super.mouseClicked(mouseX, mouseY, button, consumed) || this.blockOutsideClicks;
    }

    public void cancel() {
        if (this.cancelButton != null && this.cancelButton.isEnabled()) {
            this.colourState.set(this.initialColour);
        }
        this.close();
    }

    public void close() {
        this.getParent().removeChild(this);
    }

    private static boolean validHex(String value) {
        try {
            Integer.parseUnsignedInt(value, 16);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public GuiColourPicker setColourState(ColourState colourState) {
        this.colourState = colourState;
        return this;
    }

    public ColourState getState() {
        return this.colourState;
    }

    public SliderState sliderStateAlpha() {
        return SliderState.forSlider(() -> this.colourState.getColour().aF(), e -> this.colourState.set(this.colourState.getColour().aF(e.floatValue())), () -> -1.0 / (double)(Screen.hasShiftDown() ? 16 : 64));
    }

    public SliderState sliderStateRed() {
        return SliderState.forSlider(() -> this.colourState.getColour().rF(), e -> this.colourState.set(this.colourState.getColour().rF(e.floatValue())), () -> -1.0 / (double)(Screen.hasShiftDown() ? 16 : 64));
    }

    public SliderState sliderStateGreen() {
        return SliderState.forSlider(() -> this.colourState.getColour().gF(), e -> this.colourState.set(this.colourState.getColour().gF(e.floatValue())), () -> -1.0 / (double)(Screen.hasShiftDown() ? 16 : 64));
    }

    public SliderState sliderStateBlue() {
        return SliderState.forSlider(() -> this.colourState.getColour().bF(), e -> this.colourState.set(this.colourState.getColour().bF(e.floatValue())), () -> -1.0 / (double)(Screen.hasShiftDown() ? 16 : 64));
    }

    public TextState getTextState() {
        return TextState.create(this.colourState::getHexColour, this.colourState::setHexColour);
    }

    public GuiButton getOkButton() {
        return this.okButton;
    }

    public GuiButton getCancelButton() {
        return this.cancelButton;
    }

    public static class SliderBG
    extends GuiElement<SliderBG>
    implements BackgroundRender {
        public int colour;
        public int highlight;
        public GuiSlider slider;
        public boolean pressed = false;

        public SliderBG(@NotNull GuiParent<?> parent, int colour, int highlight) {
            super(parent);
            this.colour = colour;
            this.highlight = highlight;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button, boolean consumed) {
            this.pressed = button == 0;
            return super.mouseClicked(mouseX, mouseY, button, consumed);
        }

        @Override
        public boolean mouseReleased(double mouseX, double mouseY, int button, boolean consumed) {
            if (button == 0) {
                this.pressed = false;
            }
            return super.mouseReleased(mouseX, mouseY, button, consumed);
        }

        @Override
        public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            render.fill(this.xMin(), this.yMin(), this.xMin() + 1.0, this.yMax(), this.colour);
            render.fill(this.xMax() - 1.0, this.yMin(), this.xMax(), this.yMax(), this.colour);
            render.fill(this.xMin() + 1.0, this.yCenter() - 0.5, this.xMax() - 1.0, this.yCenter() + 0.5, this.colour);
            if (this.isMouseOver() && !this.pressed || this.slider.isDragging()) {
                render.rect(this.getRectangle(), this.highlight);
            }
        }
    }

    public static class ColourPreview
    extends GuiElement<ColourPreview>
    implements BackgroundRender {
        private final Supplier<Integer> colour;
        public int colourA = -6710887;
        public int colourB = -10066330;

        public ColourPreview(@NotNull GuiParent<?> parent, Supplier<Integer> colour) {
            super(parent);
            this.colour = colour;
        }

        @Override
        public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            render.pushScissorRect(this.xMin(), this.yMin(), this.xSize(), this.ySize());
            int x = 0;
            while (this.xMin() + (double)(x * 2) < this.xMax()) {
                int y = 0;
                while (this.yMin() + (double)(y * 2) < this.yMax()) {
                    int col = (y & 1) == 0 ? ((x & 1) == 0 ? this.colourA : this.colourB) : ((x & 1) == 0 ? this.colourB : this.colourA);
                    render.rect(this.xMin() + (double)(x * 2), this.yMin() + (double)(y * 2), 2.0, 2.0, col);
                    ++y;
                }
                ++x;
            }
            render.popScissor();
            render.rect(this.getRectangle(), this.colour.get());
        }
    }
}

