/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config.parser;

import codechicken.lib.config.ConfigCategoryImpl;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.ConfigValueImpl;
import codechicken.lib.config.ConfigValueListImpl;
import codechicken.lib.config.ValueType;
import codechicken.lib.config.parser.ConfigSerializer;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import net.covers1624.quack.io.IndentPrintWriter;

public class JsonConfigSerializer
implements ConfigSerializer {
    @Override
    public void parse(Path file, ConfigCategoryImpl rootTag) throws IOException {
        try (JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(file));){
            reader.setLenient(true);
            this.readCategory(reader, rootTag);
        }
    }

    private void readCategory(JsonReader reader, ConfigCategoryImpl cat) throws IOException {
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            JsonToken next = reader.peek();
            if (next == JsonToken.BEGIN_OBJECT) {
                this.readCategory(reader, cat.getCategory(name));
                continue;
            }
            if (next == JsonToken.BEGIN_ARRAY) {
                this.readList(reader, cat.getValueList(name));
                continue;
            }
            cat.getValue(name).setValue(this.readObject(reader));
        }
        reader.endObject();
    }

    private void readList(JsonReader reader, ConfigValueListImpl val) throws IOException {
        reader.beginArray();
        LinkedList<Object> list = new LinkedList<Object>();
        while (reader.hasNext()) {
            list.add(this.readObject(reader));
        }
        val.setValue(list);
        reader.endArray();
    }

    private Object readObject(JsonReader reader) throws IOException {
        JsonToken next = reader.peek();
        return switch (next) {
            case JsonToken.STRING -> reader.nextString();
            case JsonToken.NUMBER -> new LazilyParsedNumber(reader.nextString());
            case JsonToken.BOOLEAN -> reader.nextBoolean();
            default -> throw new IllegalStateException("Unknown Token for object type: " + String.valueOf(next));
        };
    }

    @Override
    public void save(Path file, ConfigCategoryImpl rootTag) throws IOException {
        try (IndentPrintWriter pw = new IndentPrintWriter(new PrintWriter(Files.newOutputStream(file, new OpenOption[0]), true), "\t");){
            this.writeCategory(pw, rootTag);
            pw.println();
            pw.flush();
        }
    }

    private void writeTag(IndentPrintWriter pw, ConfigTag tag) {
        if (tag instanceof ConfigCategoryImpl) {
            ConfigCategoryImpl cat = (ConfigCategoryImpl)tag;
            this.writeCategory(pw, cat);
        } else if (tag instanceof ConfigValueImpl) {
            ConfigValueImpl val = (ConfigValueImpl)tag;
            this.writeValue(pw, val);
        } else if (tag instanceof ConfigValueListImpl) {
            ConfigValueListImpl lst = (ConfigValueListImpl)tag;
            this.writeValueList(pw, lst);
        }
    }

    private void writeCategory(IndentPrintWriter pw, ConfigCategoryImpl cat) {
        pw.println("{");
        pw.pushIndent();
        boolean first = true;
        for (ConfigTag child : cat.getChildren()) {
            if (child.isNetworkTag()) continue;
            if (!first) {
                pw.print(",");
                pw.println();
                pw.println();
            }
            for (String s : child.getComment()) {
                pw.println("// " + s);
            }
            pw.print("\"" + child.getName() + "\": ");
            this.writeTag(pw, child);
            first = false;
        }
        if (!first) {
            pw.println();
        }
        pw.popIndent();
        pw.print("}");
    }

    private void writeValue(IndentPrintWriter pw, ConfigValueImpl val) {
        pw.print(JsonConfigSerializer.toString(val.getRawValue(), val.getType()));
    }

    private void writeValueList(IndentPrintWriter pw, ConfigValueListImpl lst) {
        pw.println("[");
        pw.pushIndent();
        boolean first = true;
        for (Object o : lst.getRawValue()) {
            if (!first) {
                pw.println(",");
            }
            pw.print(JsonConfigSerializer.toString(o, lst.getType()));
            first = false;
        }
        if (!first) {
            pw.println();
        }
        pw.popIndent();
        pw.print("]");
    }

    private static String toString(Object val, ValueType type) {
        if (type == ValueType.HEX) {
            return "\"0x" + Long.toString((long)((Integer)val).intValue() << 32 >>> 32, 16).toUpperCase() + "\"";
        }
        if (type == ValueType.STRING) {
            return "\"" + String.valueOf(val) + "\"";
        }
        return val.toString();
    }
}

