/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.lib.data.MCDataByteBuf;
import codechicken.lib.data.MCDataInput;
import codechicken.multipart.api.TickableTile;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.init.CBMultipartModContent;
import codechicken.multipart.network.MultiPartSPH;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MultipartLoadHandler {
    private static final Logger logger = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already initialized.");

    public static void init() {
        LOCK.lock();
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, MultipartLoadHandler::onChunkLoad);
    }

    private static void onChunkLoad(ChunkEvent.Load event) {
        Object object;
        if (event.getLevel().isClientSide() && (object = event.getChunk()) instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)object;
            for (BlockEntity be : List.copyOf(chunk.getBlockEntities().values())) {
                if (!(be instanceof TileNBTContainer)) continue;
                TileNBTContainer tile = (TileNBTContainer)be;
                if (tile.updateTag == null) continue;
                byte[] data = tile.updateTag.getByteArray("data");
                TileMultipart.handleDescPacket(tile.getLevel(), tile.getBlockPos(), (MCDataInput)new MCDataByteBuf(Unpooled.wrappedBuffer((byte[])data)));
            }
        }
    }

    public static class TileNBTContainer
    extends BlockEntity
    implements TickableTile {
        private int ticks;
        private boolean failed;
        private boolean loaded;
        @Nullable
        public CompoundTag tag;
        @Nullable
        public CompoundTag updateTag;

        public TileNBTContainer(BlockPos pos, BlockState state) {
            super((BlockEntityType)CBMultipartModContent.MULTIPART_TILE_TYPE.get(), pos, state);
        }

        public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
            if (!tag.contains("data")) {
                logger.warn("Received update tag without 'data' field. Ignoring..");
                return;
            }
            this.updateTag = tag;
        }

        public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
            super.loadAdditional(compound, registries);
            this.tag = compound.copy();
        }

        public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
            super.saveAdditional(compound, registries);
            if (this.tag != null) {
                compound.merge(this.tag);
            }
        }

        @Override
        public void tick() {
            if (this.level == null || this.level.isClientSide) {
                return;
            }
            if (!this.failed && !this.loaded) {
                if (this.tag != null) {
                    TileMultipart newTile = TileMultipart.fromNBT(this.tag, this.getBlockPos(), (HolderLookup.Provider)this.getLevel().registryAccess());
                    if (newTile != null) {
                        newTile.clearRemoved();
                        this.level.setBlockEntity((BlockEntity)newTile);
                        newTile.notifyTileChange();
                        newTile.notifyShapeChange();
                        MultiPartSPH.sendDescUpdate(newTile);
                    } else {
                        this.level.removeBlock(this.getBlockPos(), false);
                    }
                    this.loaded = true;
                } else {
                    ++this.ticks;
                    if (this.ticks % 600 == 0) {
                        this.failed = true;
                        logger.warn("TileNBTContainer at '{}' still exists after {} ticks! Deleting..", (Object)this.getBlockPos(), (Object)this.ticks);
                        this.level.removeBlock(this.getBlockPos(), false);
                    }
                }
            }
        }
    }
}

