/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.client.MultipartModelData;
import java.util.IdentityHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class TileMultipartClient
extends TileMultipart {
    public TileMultipartClient(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public boolean isClientTile() {
        return true;
    }

    @Override
    public void markRender() {
        if (this.getLevel() instanceof ClientLevel) {
            this.requestModelDataUpdate();
            BlockPos pos = this.getBlockPos();
            Minecraft.getInstance().levelRenderer.setBlocksDirty(pos.getX(), pos.getY(), pos.getZ(), pos.getX(), pos.getY(), pos.getZ());
        }
    }

    public ModelData getModelData() {
        IdentityHashMap<MultiPart, ModelData> partData = new IdentityHashMap<MultiPart, ModelData>();
        for (MultiPart part : this.getPartList()) {
            ModelData data = part.getModelData();
            if (data == ModelData.EMPTY) continue;
            partData.put(part, data);
        }
        return ModelData.of(MultipartModelData.DATA, (Object)new MultipartModelData(this.tile(), partData));
    }
}

