/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.lib.math.MathHelper;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NeighborTileChangePart;
import codechicken.multipart.block.TileMultipart;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;

public class TTileChangeTile
extends TileMultipart {
    private boolean weakTileChanges = false;

    public TTileChangeTile(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void copyFrom(TileMultipart that) {
        super.copyFrom(that);
        if (that instanceof TTileChangeTile) {
            this.weakTileChanges = ((TTileChangeTile)that).weakTileChanges;
        }
    }

    @Override
    public void bindPart(MultiPart part) {
        super.bindPart(part);
        if (part instanceof NeighborTileChangePart) {
            this.weakTileChanges |= ((NeighborTileChangePart)part).weakTileChanges();
        }
    }

    @Override
    public void partRemoved(MultiPart part, int p) {
        super.partRemoved(part, p);
        this.weakTileChanges = this.getPartList().stream().anyMatch(e -> e instanceof NeighborTileChangePart && ((NeighborTileChangePart)e).weakTileChanges());
    }

    @Override
    public boolean getWeakChanges() {
        return super.getWeakChanges() || this.weakTileChanges;
    }

    @Override
    public void onNeighborTileChange(BlockPos neighborPos) {
        super.onNeighborTileChange(neighborPos);
        BlockPos offset = neighborPos.subtract((Vec3i)this.getBlockPos());
        int diff = MathHelper.absSum((BlockPos)offset);
        Direction side = MathHelper.getSide((BlockPos)offset);
        if (side == null || diff <= 0 || diff > 2) {
            return;
        }
        boolean weak = diff == 2;
        List<MultiPart> jPartList = this.getPartList();
        for (MultiPart part : jPartList) {
            if (!(part instanceof NeighborTileChangePart)) continue;
            ((NeighborTileChangePart)part).onNeighborTileChanged(side, weak);
        }
    }
}

