/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.PartialOcclusionPart;
import codechicken.multipart.block.TileMultipart;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TPartialOcclusionTile
extends TileMultipart {
    @Nullable
    private static Iterable<MultiPart> lastTestParts = null;
    @Nullable
    private static VoxelShape lastTestShape = null;
    private static boolean lastTestResult = false;

    public TPartialOcclusionTile(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void markShapeChange() {
        super.markShapeChange();
        lastTestParts = null;
        lastTestShape = null;
    }

    @Override
    public boolean occlusionTest(Iterable<MultiPart> parts, MultiPart npart) {
        if (npart instanceof PartialOcclusionPart) {
            PartialOcclusionPart newPart = (PartialOcclusionPart)npart;
            VoxelShape newShape = newPart.getPartialOcclusionShape();
            if (!this.getLevel().isClientSide() || lastTestParts != parts || lastTestShape != newShape) {
                lastTestParts = parts;
                lastTestShape = newShape;
                lastTestResult = TPartialOcclusionTile.partialOcclusionTest(parts, newPart);
            }
            if (!lastTestResult) {
                return false;
            }
        }
        return super.occlusionTest(parts, npart);
    }

    private static boolean partialOcclusionTest(Iterable<MultiPart> allParts, PartialOcclusionPart newPart) {
        LinkedList<PartialOcclusionPart> parts = new LinkedList<PartialOcclusionPart>();
        for (MultiPart part : allParts) {
            if (!(part instanceof PartialOcclusionPart)) continue;
            parts.add((PartialOcclusionPart)part);
        }
        parts.add(newPart);
        for (PartialOcclusionPart part1 : parts) {
            if (part1.allowCompleteOcclusion()) continue;
            VoxelShape uniqueShape = part1.getPartialOcclusionShape();
            for (PartialOcclusionPart part2 : parts) {
                if (part1 == part2) continue;
                uniqueShape = Shapes.join((VoxelShape)uniqueShape, (VoxelShape)part2.getPartialOcclusionShape(), (BooleanOp)BooleanOp.ONLY_FIRST);
            }
            if (!uniqueShape.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

