/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.AnimateTickPart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.minecraft.McSidedStatePart;
import codechicken.multipart.minecraft.MinecraftMultipartModContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TorchPart
extends McSidedStatePart
implements AnimateTickPart {
    public static VoxelShape STANDING_OCCLUSION;
    public static VoxelShape[] WALL_OCCLUSION;

    public TorchPart() {
    }

    public TorchPart(BlockState state) {
        super(state);
    }

    @Override
    public MultipartType<?> getType() {
        return (MultipartType)MinecraftMultipartModContent.TORCH_PART.get();
    }

    protected Block getStandingBlock() {
        return Blocks.TORCH;
    }

    protected Block getWallBlock() {
        return Blocks.WALL_TORCH;
    }

    @Override
    public BlockState defaultBlockState() {
        return this.getStandingBlock().defaultBlockState();
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((ItemLike)this.getStandingBlock());
    }

    @Override
    public Direction getSide() {
        return this.state.getBlock() == this.getStandingBlock() ? Direction.DOWN : ((Direction)this.state.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite();
    }

    @Override
    public VoxelShape getOcclusionShape() {
        if (this.state.getBlock() == this.getStandingBlock()) {
            return STANDING_OCCLUSION;
        }
        return WALL_OCCLUSION[this.getSide().get2DDataValue()];
    }

    @Override
    @Nullable
    public MultiPart setStateOnPlacement(BlockPlaceContext context) {
        BlockState state;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        if (face == Direction.DOWN) {
            return null;
        }
        BlockState blockState = state = face == Direction.UP ? this.getStandingBlock().defaultBlockState() : (BlockState)this.getWallBlock().defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)face);
        if (state.canSurvive((LevelReader)world, pos)) {
            this.state = state;
            return this;
        }
        return null;
    }

    @Override
    public void animateTick(RandomSource random) {
        this.state.getBlock().animateTick(this.state, this.level(), this.pos(), random);
    }

    static {
        WALL_OCCLUSION = new VoxelShape[4];
        STANDING_OCCLUSION = VoxelShapeCache.getShape((Cuboid6)new Cuboid6(0.4, 0.0, 0.4, 0.6, 0.6, 0.6));
        Cuboid6 wall = new Cuboid6(0.35, 0.2, 0.7, 0.65, 0.8, 1.0);
        for (int i = 0; i < 4; ++i) {
            TorchPart.WALL_OCCLUSION[i] = VoxelShapeCache.getShape((Cuboid6)wall.copy().apply(Rotation.quarterRotations[i].at(Vector3.CENTER)));
        }
    }
}

