/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.redstone.FaceRedstonePart;
import codechicken.multipart.minecraft.McSidedStatePart;
import codechicken.multipart.minecraft.MinecraftMultipartModContent;
import codechicken.multipart.util.PartRayTraceResult;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class ButtonPart
extends McSidedStatePart
implements FaceRedstonePart {
    private final MultipartType<?> type;
    private final ButtonBlock block;

    public ButtonPart(MultipartType<?> type, ButtonBlock block) {
        this(type, block, block.defaultBlockState());
    }

    public ButtonPart(MultipartType<?> type, ButtonBlock block, BlockState state) {
        super((BlockState)state.setValue((Property)ButtonBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
        this.block = block;
    }

    @Override
    public MultipartType<?> getType() {
        return this.type;
    }

    @Override
    public BlockState defaultBlockState() {
        return this.block.defaultBlockState();
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((ItemLike)this.block);
    }

    @Override
    public Direction getSide() {
        return FaceAttachedHorizontalDirectionalBlock.getConnectedDirection((BlockState)this.state).getOpposite();
    }

    @Override
    @Nullable
    public MultiPart setStateOnPlacement(BlockPlaceContext context) {
        BlockState state;
        Direction face = context.getClickedFace();
        switch (face) {
            case DOWN: {
                BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ButtonBlock.FACE, (Comparable)AttachFace.CEILING)).setValue((Property)ButtonBlock.FACING, (Comparable)context.getHorizontalDirection());
                break;
            }
            case UP: {
                BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ButtonBlock.FACE, (Comparable)AttachFace.FLOOR)).setValue((Property)ButtonBlock.FACING, (Comparable)context.getHorizontalDirection());
                break;
            }
            default: {
                BlockState blockState = state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ButtonBlock.FACE, (Comparable)AttachFace.WALL)).setValue((Property)ButtonBlock.FACING, (Comparable)face);
            }
        }
        if (state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) {
            this.state = state;
            return this;
        }
        return null;
    }

    public int delay() {
        return this.block.ticksToStayPressed;
    }

    public boolean canArrowsPress() {
        return this.block.type.canButtonBeActivatedByArrows();
    }

    @Override
    public InteractionResult useWithoutItem(Player player, PartRayTraceResult hit) {
        if (this.pressed()) {
            return InteractionResult.CONSUME;
        }
        if (!this.level().isClientSide) {
            this.toggle();
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void scheduledTick() {
        if (this.pressed()) {
            this.updateState();
        }
    }

    public boolean pressed() {
        return (Boolean)this.state.getValue((Property)ButtonBlock.POWERED);
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (!this.pressed() && !this.level().isClientSide && entity instanceof Arrow) {
            this.updateState();
        }
    }

    private void toggle() {
        this.state = (BlockState)this.state.cycle((Property)ButtonBlock.POWERED);
        boolean on = this.pressed();
        this.block.playSound(null, (LevelAccessor)this.level(), this.pos(), on);
        if (on) {
            this.scheduleTick(this.delay());
        }
        this.sendUpdate(this::writeDesc);
        this.tile().setChanged();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(this.getSide().ordinal());
    }

    private void updateState() {
        boolean pressed;
        boolean arrows = this.canArrowsPress() && !this.level().getEntitiesOfClass(Arrow.class, this.getShape(CollisionContext.empty()).bounds().move(this.pos())).isEmpty();
        if (arrows != (pressed = this.pressed())) {
            this.toggle();
        }
        if (arrows && pressed) {
            this.scheduleTick(this.delay());
        }
    }

    @Override
    public void onRemoved() {
        if (this.pressed()) {
            this.tile().notifyNeighborChange(this.getSide().ordinal());
        }
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.pressed() ? 15 : 0;
    }

    @Override
    public int strongPowerLevel(int side) {
        return this.pressed() && side == this.getSide().ordinal() ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return this.getSide().ordinal();
    }

    public static class WarpedButtonPart
    extends ButtonPart {
        public WarpedButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.WARPED_BUTTON_PART.get(), (ButtonBlock)Blocks.WARPED_BUTTON);
        }

        public WarpedButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.WARPED_BUTTON_PART.get(), (ButtonBlock)Blocks.WARPED_BUTTON, state);
        }
    }

    public static class CrimsonButtonPart
    extends ButtonPart {
        public CrimsonButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.CRIMSON_BUTTON_PART.get(), (ButtonBlock)Blocks.CRIMSON_BUTTON);
        }

        public CrimsonButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.CRIMSON_BUTTON_PART.get(), (ButtonBlock)Blocks.CRIMSON_BUTTON, state);
        }
    }

    public static class DarkOakButtonPart
    extends ButtonPart {
        public DarkOakButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.DARK_OAK_BUTTON_PART.get(), (ButtonBlock)Blocks.DARK_OAK_BUTTON);
        }

        public DarkOakButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.DARK_OAK_BUTTON_PART.get(), (ButtonBlock)Blocks.DARK_OAK_BUTTON, state);
        }
    }

    public static class AcaciaButtonPart
    extends ButtonPart {
        public AcaciaButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.ACACIA_BUTTON_PART.get(), (ButtonBlock)Blocks.ACACIA_BUTTON);
        }

        public AcaciaButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.ACACIA_BUTTON_PART.get(), (ButtonBlock)Blocks.ACACIA_BUTTON, state);
        }
    }

    public static class JungleButtonPart
    extends ButtonPart {
        public JungleButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.JUNGLE_BUTTON_PART.get(), (ButtonBlock)Blocks.JUNGLE_BUTTON);
        }

        public JungleButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.JUNGLE_BUTTON_PART.get(), (ButtonBlock)Blocks.JUNGLE_BUTTON, state);
        }
    }

    public static class BirchButtonPart
    extends ButtonPart {
        public BirchButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.BIRCH_BUTTON_PART.get(), (ButtonBlock)Blocks.BIRCH_BUTTON);
        }

        public BirchButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.BIRCH_BUTTON_PART.get(), (ButtonBlock)Blocks.BIRCH_BUTTON, state);
        }
    }

    public static class SpruceButtonPart
    extends ButtonPart {
        public SpruceButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.SPRUCE_BUTTON_PART.get(), (ButtonBlock)Blocks.SPRUCE_BUTTON);
        }

        public SpruceButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.SPRUCE_BUTTON_PART.get(), (ButtonBlock)Blocks.SPRUCE_BUTTON, state);
        }
    }

    public static class OakButtonPart
    extends ButtonPart {
        public OakButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.OAK_BUTTON_PART.get(), (ButtonBlock)Blocks.OAK_BUTTON);
        }

        public OakButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.OAK_BUTTON_PART.get(), (ButtonBlock)Blocks.OAK_BUTTON, state);
        }
    }

    public static class PolishedBlackstoneButtonPart
    extends ButtonPart {
        public PolishedBlackstoneButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.POLISHED_BLACKSTONE_BUTTON_PART.get(), (ButtonBlock)Blocks.POLISHED_BLACKSTONE_BUTTON);
        }

        public PolishedBlackstoneButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.POLISHED_BLACKSTONE_BUTTON_PART.get(), (ButtonBlock)Blocks.POLISHED_BLACKSTONE_BUTTON, state);
        }
    }

    public static class StoneButtonPart
    extends ButtonPart {
        public StoneButtonPart() {
            super((MultipartType)MinecraftMultipartModContent.STONE_BUTTON_PART.get(), (ButtonBlock)Blocks.STONE_BUTTON);
        }

        public StoneButtonPart(BlockState state) {
            super((MultipartType)MinecraftMultipartModContent.STONE_BUTTON_PART.get(), (ButtonBlock)Blocks.STONE_BUTTON, state);
        }
    }
}

