/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.block;

import codechicken.lib.capability.CapabilityCache;
import codechicken.lib.data.MCDataByteBuf;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Vector3;
import codechicken.lib.world.IChunkLoadTile;
import codechicken.multipart.api.part.BaseMultipart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.BlockMultipart;
import codechicken.multipart.init.CBMultipartModContent;
import codechicken.multipart.init.MultiPartRegistries;
import codechicken.multipart.network.MultiPartSPH;
import codechicken.multipart.util.MergedVoxelShapeHolder;
import codechicken.multipart.util.MultipartGenerator;
import codechicken.multipart.util.MultipartHelper;
import codechicken.multipart.util.MultipartVoxelShape;
import codechicken.multipart.util.PartRayTraceResult;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.jetbrains.annotations.Nullable;

public class TileMultipart
extends BlockEntity
implements IChunkLoadTile {
    private List<MultiPart> partList = new CopyOnWriteArrayList<MultiPart>();
    private final CapabilityCache capabilityCache = new CapabilityCache();
    private final MergedVoxelShapeHolder<MultiPart> outlineShapeHolder = new MergedVoxelShapeHolder(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<MultiPart> collisionShapeHolder = new MergedVoxelShapeHolder(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<MultiPart> occlusionShapeHolder = new MergedVoxelShapeHolder(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<MultiPart> interactionShapeHolder = new MergedVoxelShapeHolder(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<MultiPart> supportShapeHolder = new MergedVoxelShapeHolder(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<MultiPart> visualShapeHolder = new MergedVoxelShapeHolder(e -> new MultipartVoxelShape((VoxelShape)e, this));

    public TileMultipart(BlockPos pos, BlockState state) {
        super((BlockEntityType)CBMultipartModContent.MULTIPART_TILE_TYPE.get(), pos, state);
    }

    public List<MultiPart> getPartList() {
        return this.partList;
    }

    public void from(TileMultipart that) {
        this.copyFrom(that);
        this.loadFrom(that);
        that.loadTo(this);
    }

    public void copyFrom(TileMultipart that) {
        this.partList = that.partList;
        this.markShapeChange();
    }

    public void loadFrom(TileMultipart that) {
        this.partList.forEach(e -> ((BaseMultipart)e).bind(this));
    }

    public void loadTo(TileMultipart that) {
    }

    public void clearParts() {
        this.partList = new CopyOnWriteArrayList<MultiPart>();
        this.markShapeChange();
    }

    public void bindPart(MultiPart part) {
    }

    public void partAdded(MultiPart part) {
    }

    public void partRemoved(MultiPart part, int p) {
    }

    public boolean getWeakChanges() {
        return false;
    }

    public void onNeighborTileChange(BlockPos neighborPos) {
    }

    @Nullable
    public MultiPart getSlottedPart(int slot) {
        return null;
    }

    public void onRemoved() {
    }

    @Nullable
    public <T, C> T getCapability(BlockCapability<T, C> capability, C context) {
        return null;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ListTag parts = new ListTag();
        for (MultiPart part : this.partList) {
            parts.add((Object)MultiPartRegistries.savePart(new CompoundTag(), part, registries));
        }
        tag.put("parts", (Tag)parts);
    }

    public final CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        MCDataByteBuf desc = new MCDataByteBuf(this.getLevel().registryAccess());
        this.writeDesc((MCDataOutput)desc);
        desc.writeToNBT(tag, "data");
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        TileMultipart.handleDescPacket(this.getLevel(), this.getBlockPos(), (MCDataInput)MCDataByteBuf.readFromNBT((CompoundTag)tag, (String)"data", (RegistryAccess)this.getLevel().registryAccess()));
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte(this.partList.size());
        for (MultiPart part : this.partList) {
            MultiPartRegistries.writePart(packet, part);
        }
    }

    public boolean canAddPart(MultiPart part) {
        return !this.partList.contains(part) && this.occlusionTest(this.partList, part);
    }

    public boolean canReplacePart(MultiPart oPart, MultiPart nPart) {
        if (oPart != nPart && this.partList.contains(nPart)) {
            return false;
        }
        return this.occlusionTest((Iterable<MultiPart>)FastStream.of(this.partList).filter(e -> e != oPart), nPart);
    }

    public boolean occlusionTest(Iterable<MultiPart> parts, MultiPart nPart) {
        return ColUtils.allMatch(parts, part -> part.occlusionTest(nPart) && nPart.occlusionTest((MultiPart)part));
    }

    public void addPart_impl(MultiPart part) {
        if (!this.level.isClientSide) {
            MultiPartSPH.sendAddPart(this, part);
        }
        this.addPart_do(part);
        part.onAdded();
        this.partAdded(part);
        this.notifyPartChange(part);
        this.notifyTileChange();
        this.setChanged();
        this.markRender();
    }

    public void addPart_do(MultiPart part) {
        this.partList.add(part);
        this.bindPart(part);
        this.markShapeChange();
        ((BaseMultipart)part).bind(this);
    }

    @Nullable
    public TileMultipart remPart(MultiPart part) {
        Preconditions.checkArgument((!this.level.isClientSide ? 1 : 0) != 0, (Object)"Cannot remove MultiParts from a client tile.");
        return this.remPart_impl(part);
    }

    @Nullable
    public TileMultipart remPart_impl(MultiPart part) {
        this.remPart_do(part, !this.level.isClientSide);
        if (!this.isRemoved()) {
            TileMultipart tile = TileMultipart.partRemoved(this);
            tile.notifyPartChange(part);
            tile.notifyShapeChange();
            tile.setChanged();
            tile.markRender();
            return tile;
        }
        return null;
    }

    private int remPart_do(MultiPart part, boolean sendPacket) {
        int idx = this.partList.indexOf(part);
        if (idx < 0) {
            throw new IllegalArgumentException("Tried to remove a non-existent part");
        }
        part.preRemove();
        this.partList.removeIf(e -> e == part);
        if (sendPacket) {
            MultiPartSPH.sendRemPart(this, idx);
        }
        this.partRemoved(part, idx);
        part.onRemoved();
        ((BaseMultipart)part).bind(null);
        this.markShapeChange();
        this.recalcLight(false, true);
        if (this.partList.isEmpty()) {
            this.level.removeBlock(this.worldPosition, false);
        }
        return idx;
    }

    private void loadParts(Iterable<MultiPart> parts) {
        this.clearParts();
        parts.forEach(this::addPart_do);
        if (this.level != null) {
            if (this.level.isClientSide) {
                this.operate(MultiPart::onWorldJoin);
            }
            this.notifyPartChange(null);
        }
    }

    public final void setValid(boolean b) {
        if (b) {
            this.clearRemoved();
        } else {
            this.setRemoved();
        }
    }

    public void setRemoved() {
        if (!this.isRemoved()) {
            super.setRemoved();
            this.onRemoved();
            if (this.level != null) {
                this.partList.forEach(MultiPart::onWorldSeparate);
            }
        }
    }

    public VoxelShape getShape(CollisionContext context) {
        return this.outlineShapeHolder.update(this.partList, part -> part.getShape(context));
    }

    public VoxelShape getCollisionShape(CollisionContext context) {
        return this.collisionShapeHolder.update(this.partList, part -> part.getCollisionShape(context));
    }

    public VoxelShape getRenderOcclusionShape() {
        return this.occlusionShapeHolder.update(this.partList, MultiPart::getRenderOcclusionShape);
    }

    public VoxelShape getInteractionShape() {
        return this.interactionShapeHolder.update(this.partList, MultiPart::getInteractionShape);
    }

    public VoxelShape getBlockSupportShape() {
        return this.supportShapeHolder.update(this.partList, MultiPart::getBlockSupportShape);
    }

    public VoxelShape getVisualShape(CollisionContext context) {
        return this.visualShapeHolder.update(this.partList, part -> part.getVisualShape(context));
    }

    public void harvestPart(PartRayTraceResult hit, Player player) {
        hit.part.harvest(player, hit);
    }

    public List<ItemStack> getDrops() {
        return this.partList.stream().map(MultiPart::getDrops).flatMap(e -> StreamSupport.stream(e.spliterator(), false)).collect(Collectors.toList());
    }

    public ItemStack getCloneStack(PartRayTraceResult hit) {
        return hit.part.getCloneStack(hit);
    }

    public float getExplosionResistance(Explosion explosion) {
        return (float)this.partList.stream().mapToDouble(e -> e.getExplosionResistance(explosion)).max().orElse(0.0);
    }

    public float getDestroyProgress(Player player, PartRayTraceResult hit) {
        return hit.part.getStrength(player, hit);
    }

    public void onChunkUnloaded() {
        this.operate(MultiPart::onChunkUnload);
    }

    public void onChunkLoad(LevelChunk chunk) {
        this.operate(e -> e.onChunkLoad(chunk));
    }

    public void onMoved() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.capabilityCache.setLevelPos(serverLevel, this.worldPosition);
        }
        this.operate(MultiPart::onMoved);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, Player player, PartRayTraceResult hit, InteractionHand hand) {
        return hit.part.useItemOn(stack, player, hit, hand);
    }

    public InteractionResult useWithoutItem(Player player, PartRayTraceResult hit) {
        return hit.part.useWithoutItem(player, hit);
    }

    public void attack(Player player, PartRayTraceResult hit) {
        hit.part.click(player, hit, player.getMainHandItem());
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.capabilityCache.setLevelPos(serverLevel, this.worldPosition);
        }
    }

    public void entityInside(Entity entity) {
        this.operate(e -> e.onEntityCollision(entity));
    }

    public void stepOn(Entity entity) {
        this.operate(e -> e.onEntityStanding(entity));
    }

    public void onNeighborBlockChanged(BlockPos pos) {
        this.operate(e -> e.onNeighborBlockChanged(pos));
    }

    public boolean canConnectRedstone(int side) {
        return false;
    }

    public int getDirectSignal(int side) {
        return 0;
    }

    public int getSignal(int side) {
        return 0;
    }

    public void animateTick(RandomSource random) {
    }

    public boolean isClientTile() {
        return false;
    }

    public TileMultipart tile() {
        return this;
    }

    public void addLandingEffects(Vector3 entity, int numberOfParticles) {
        PartRayTraceResult hit = this.hitFeet(entity);
        if (hit == null) {
            return;
        }
        hit.part.addLandingEffects(hit, entity, numberOfParticles);
    }

    public void addRunningEffects(Entity entity) {
        PartRayTraceResult hit = this.hitFeet(Vector3.fromEntity((Entity)entity));
        if (hit == null) {
            return;
        }
        hit.part.addRunningEffects(hit, entity);
    }

    @Nullable
    private PartRayTraceResult hitFeet(Vector3 entityPos) {
        BlockHitResult hit = this.getCollisionShape(CollisionContext.empty()).clip(entityPos.copy().add(0.0, 0.01, 0.0).vec3(), entityPos.copy().add(0.0, -0.01, 0.0).vec3(), this.getBlockPos());
        if (!(hit instanceof PartRayTraceResult)) {
            return null;
        }
        PartRayTraceResult pHit = (PartRayTraceResult)hit;
        double dist = entityPos.copy().subtract(hit.getLocation()).mag();
        if (!MathHelper.between((double)-0.01, (double)dist, (double)0.01)) {
            return null;
        }
        return pHit;
    }

    public void notifyTileChange() {
        if (this.level != null) {
            this.level.updateNeighborsAt(this.worldPosition, (Block)CBMultipartModContent.MULTIPART_BLOCK.get());
        }
    }

    public void notifyShapeChange() {
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.getBlockPos());
            state.updateNeighbourShapes((LevelAccessor)this.level, this.getBlockPos(), 19, 512);
            state.updateIndirectNeighbourShapes((LevelAccessor)this.level, this.getBlockPos(), 19, 512);
        }
    }

    public void notifyPartChange(@Nullable MultiPart part) {
        this.internalPartChange(part);
        this.updateLight();
        BlockState state = ((BlockMultipart)((Object)CBMultipartModContent.MULTIPART_BLOCK.get())).defaultBlockState();
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        this.level.updateNeighborsAt(this.worldPosition, (Block)CBMultipartModContent.MULTIPART_BLOCK.get());
        this.level.getChunkSource().getLightEngine().checkBlock(this.worldPosition);
    }

    public void internalPartChange(@Nullable MultiPart part) {
        this.operate(e -> {
            if (e != part) {
                e.onPartChanged(part);
            }
        });
    }

    public void multiPartChange(Collection<MultiPart> parts) {
        this.operate(p -> {
            if (!parts.contains(p)) {
                parts.forEach(p::onPartChanged);
            }
        });
    }

    public void setChanged() {
        super.setChanged();
    }

    public void markRender() {
    }

    private int getLightEmission() {
        int light = 0;
        for (MultiPart multiPart : this.partList) {
            int lightEmission = multiPart.getLightEmission();
            if (lightEmission <= light) continue;
            light = lightEmission;
        }
        return light;
    }

    public void updateLight() {
        AuxiliaryLightManager lightManager = Objects.requireNonNull(this.getLevel()).getAuxLightManager(this.getBlockPos());
        if (lightManager != null) {
            lightManager.setLightAt(this.getBlockPos(), this.getLightEmission());
        }
    }

    public void recalcLight(boolean sky, boolean block) {
        LevelLightEngine lm = this.level.getLightEngine();
        if (sky && lm.skyEngine != null) {
            lm.skyEngine.checkBlock(this.worldPosition);
        }
        if (block && lm.blockEngine != null) {
            lm.blockEngine.checkBlock(this.worldPosition);
        }
    }

    public void markShapeChange() {
        this.outlineShapeHolder.clear();
        this.collisionShapeHolder.clear();
        this.occlusionShapeHolder.clear();
        this.interactionShapeHolder.clear();
    }

    public void notifyNeighborChange(Direction side) {
        this.level.updateNeighborsAt(this.worldPosition.relative(side), (Block)CBMultipartModContent.MULTIPART_BLOCK.get());
    }

    public void notifyNeighborChange(int side) {
        this.notifyNeighborChange(Direction.from3DDataValue((int)side));
    }

    public void dropItems(Iterable<ItemStack> items) {
        Vector3 pos = Vector3.fromTileCenter((BlockEntity)this);
        items.forEach(e -> TileMultipart.dropItem(e, this.level, pos));
    }

    public void operate(Consumer<MultiPart> cons) {
        for (MultiPart part : this.partList) {
            if (!part.hasTile()) continue;
            cons.accept(part);
        }
    }

    public CapabilityCache getCapCache() {
        return this.capabilityCache;
    }

    public static boolean canPlacePart(UseOnContext context, MultiPart part) {
        BlockPos pos;
        Level level = context.getLevel();
        if (!TileMultipart.isUnobstructed(level, pos = context.getClickedPos(), part)) {
            return false;
        }
        TileMultipart tile = MultipartHelper.getOrConvertTile(level, pos);
        if (tile != null) {
            return tile.canAddPart(part);
        }
        return TileMultipart.replaceable(level, pos, context);
    }

    public static boolean isUnobstructed(Level world, BlockPos pos, MultiPart part) {
        return world.isUnobstructed(null, part.getCollisionShape(CollisionContext.empty()).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
    }

    public static boolean replaceable(Level world, BlockPos pos, UseOnContext context) {
        BlockState state = world.getBlockState(pos);
        return state.isAir() || state.canBeReplaced(new BlockPlaceContext(context));
    }

    public static TileMultipart addPart(Level world, BlockPos pos, MultiPart part) {
        return MultipartHelper.addPart(world, pos, part);
    }

    public static void handleDescPacket(Level world, BlockPos pos, MCDataInput packet) {
        ArrayList<MultiPart> parts = new ArrayList<MultiPart>();
        int nParts = packet.readUByte();
        for (int i = 0; i < nParts; ++i) {
            parts.add(MultiPartRegistries.readPart(packet));
        }
        if (parts.isEmpty()) {
            return;
        }
        BlockEntity t = world.getBlockEntity(pos);
        TileMultipart tile = MultipartGenerator.INSTANCE.generateCompositeTile(t, pos, parts, true);
        if (tile != t) {
            world.setBlockAndUpdate(pos, ((BlockMultipart)((Object)CBMultipartModContent.MULTIPART_BLOCK.get())).defaultBlockState());
            MultipartHelper.silentAddTile(world, pos, tile);
        }
        tile.loadParts(parts);
        tile.notifyTileChange();
        tile.notifyShapeChange();
        tile.markRender();
    }

    @Nullable
    public static TileMultipart fromNBT(CompoundTag tag, BlockPos pos, HolderLookup.Provider registries) {
        ListTag partList = tag.getList("parts", 10);
        ArrayList<MultiPart> parts = new ArrayList<MultiPart>();
        for (int i = 0; i < partList.size(); ++i) {
            MultiPart part = MultiPartRegistries.loadPart(partList.getCompound(i), registries);
            if (part == null) continue;
            parts.add(part);
        }
        if (parts.isEmpty()) {
            return null;
        }
        TileMultipart tile = MultipartGenerator.INSTANCE.generateCompositeTile(null, pos, parts, false);
        tile.loadWithComponents(tag, registries);
        tile.loadParts(parts);
        return tile;
    }

    public static void dropItem(ItemStack stack, Level level, Vector3 pos) {
        ItemEntity item = new ItemEntity(level, pos.x, pos.y, pos.z, stack);
        item.setDeltaMovement(level.random.nextGaussian() * 0.05, level.random.nextGaussian() * 0.05 + 0.2, level.random.nextGaussian() * 0.05);
        item.setPickUpDelay(10);
        level.addFreshEntity((Entity)item);
    }

    private static TileMultipart partRemoved(TileMultipart tile) {
        TileMultipart newTile = MultipartGenerator.INSTANCE.generateCompositeTile(tile, tile.getBlockPos(), tile.getPartList(), tile.level.isClientSide);
        if (tile != newTile) {
            tile.setValid(false);
            MultipartHelper.silentAddTile(tile.level, tile.getBlockPos(), newTile);
            newTile.from(tile);
            newTile.notifyTileChange();
            newTile.notifyShapeChange();
        }
        return newTile;
    }
}

