/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.api;

import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.BaseMultipart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NormalOcclusionPart;
import codechicken.multipart.api.part.PartialOcclusionPart;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NormalOcclusionTest {
    public static boolean test(NormalOcclusionPart part1, MultiPart part2) {
        MultiPart p;
        VoxelShape shape = Shapes.empty();
        if (part2 instanceof NormalOcclusionPart) {
            p = (NormalOcclusionPart)part2;
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)p.getOcclusionShape());
        }
        if (part2 instanceof PartialOcclusionPart) {
            p = (PartialOcclusionPart)part2;
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)p.getPartialOcclusionShape());
        }
        return !Shapes.joinIsNotEmpty((VoxelShape)shape, (VoxelShape)part1.getOcclusionShape(), (BooleanOp)BooleanOp.AND);
    }

    public static NormalOcclusionPart of(VoxelShape shape) {
        return new NormallyOccludedPart(shape);
    }

    private static class NormallyOccludedPart
    extends BaseMultipart
    implements NormalOcclusionPart {
        private final VoxelShape shape;

        private NormallyOccludedPart(VoxelShape shape) {
            this.shape = shape;
        }

        @Override
        public MultipartType<?> getType() {
            return null;
        }

        @Override
        public VoxelShape getOcclusionShape() {
            return this.shape;
        }
    }
}

