/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.util;

import codechicken.lib.vec.Cuboid6;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public record MaskedCuboid(Cuboid6 box, int sideMask) {
    private static final Cache<MaskedCuboid, MaskedCuboid> CUBOID_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();

    public static MaskedCuboid intern(MaskedCuboid cuboid) {
        return (MaskedCuboid)CUBOID_CACHE.asMap().computeIfAbsent(cuboid, Function.identity());
    }

    public static MaskedCuboid of(Cuboid6 box, int sideMask) {
        return MaskedCuboid.intern(new MaskedCuboid(box.copy(), sideMask));
    }
}

