/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.init;

import codechicken.microblock.api.BlockMicroMaterial;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.init.MicroMaterialConfig;
import codechicken.microblock.item.ItemMicroBlock;
import codechicken.microblock.item.MicroMaterialComponent;
import codechicken.microblock.item.SawItem;
import codechicken.microblock.part.StandardMicroFactory;
import codechicken.microblock.part.corner.CornerMicroFactory;
import codechicken.microblock.part.edge.EdgeMicroFactory;
import codechicken.microblock.part.edge.PostMicroblockFactory;
import codechicken.microblock.part.face.FaceMicroFactory;
import codechicken.microblock.part.hollow.HollowMicroFactory;
import codechicken.microblock.recipe.MicroRecipe;
import codechicken.microblock.util.MicroMaterialRegistry;
import codechicken.multipart.api.MultipartType;
import java.nio.file.Paths;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CBMicroblockModContent {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already initialized.");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"cb_microblock");
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"cb_microblock");
    private static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"cb_microblock");
    private static final DeferredRegister<MultipartType<?>> MULTIPART_TYPES = DeferredRegister.create(MultipartType.MULTIPART_TYPES, (String)"cb_microblock");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"cb_microblock");
    public static final DeferredHolder<Item, ItemMicroBlock> MICRO_BLOCK_ITEM = ITEMS.register("microblock", () -> new ItemMicroBlock(new Item.Properties()));
    public static final DeferredHolder<Item, Item> STONE_ROD_ITEM = ITEMS.register("stone_rod", () -> new Item(new Item.Properties()));
    public static final DeferredHolder<Item, SawItem> STONE_SAW = ITEMS.register("stone_saw", () -> new SawItem((Tier)Tiers.STONE, new Item.Properties().setNoRepair()));
    public static final DeferredHolder<Item, SawItem> IRON_SAW = ITEMS.register("iron_saw", () -> new SawItem((Tier)Tiers.IRON, new Item.Properties().setNoRepair()));
    public static final DeferredHolder<Item, SawItem> DIAMOND_SAW = ITEMS.register("diamond_saw", () -> new SawItem((Tier)Tiers.DIAMOND, new Item.Properties().setNoRepair()));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<MicroMaterialComponent>> MICRO_MATERIAL_COMPONENT = DATA_COMPONENTS.register("micro_material", () -> DataComponentType.builder().persistent(MicroMaterialComponent.CODEC).networkSynchronized(MicroMaterialComponent.STREAM_CODEC).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MICRO_TAB = TABS.register("microblocks", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.cb_microblock")).icon(() -> ItemMicroBlock.create(1, 2, MicroMaterialRegistry.getMaterial(BlockMicroMaterial.makeMaterialKey(Blocks.GRASS_BLOCK.defaultBlockState())))).displayItems((p, o) -> {
        for (StandardMicroFactory factory : StandardMicroFactory.FACTORIES.values()) {
            for (int size : new int[]{1, 2, 4}) {
                for (MicroMaterial material : MicroMaterialRegistry.microMaterials()) {
                    o.accept(ItemMicroBlock.create(factory.factoryId, size, material));
                }
            }
        }
    }).withSearchBar().build());
    public static final DeferredHolder<MultipartType<?>, FaceMicroFactory> FACE_MICROBLOCK_PART = MULTIPART_TYPES.register("face", FaceMicroFactory::new);
    public static final DeferredHolder<MultipartType<?>, HollowMicroFactory> HOLLOW_MICROBLOCK_PART = MULTIPART_TYPES.register("hollow", HollowMicroFactory::new);
    public static final DeferredHolder<MultipartType<?>, CornerMicroFactory> CORNER_MICROBLOCK_PART = MULTIPART_TYPES.register("corner", CornerMicroFactory::new);
    public static final DeferredHolder<MultipartType<?>, EdgeMicroFactory> EDGE_MICROBLOCK_PART = MULTIPART_TYPES.register("edge", EdgeMicroFactory::new);
    public static final DeferredHolder<MultipartType<?>, PostMicroblockFactory> POST_MICROBLOCK_PART = MULTIPART_TYPES.register("post", PostMicroblockFactory::new);
    public static final DeferredHolder<RecipeSerializer<?>, SimpleCraftingRecipeSerializer<?>> MICRO_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("microblock", () -> new SimpleCraftingRecipeSerializer(e -> new MicroRecipe()));

    public static void init(IEventBus modBus) {
        LOCK.lock();
        ITEMS.register(modBus);
        DATA_COMPONENTS.register(modBus);
        TABS.register(modBus);
        MULTIPART_TYPES.register(modBus);
        RECIPE_SERIALIZERS.register(modBus);
        modBus.addListener(CBMicroblockModContent::onCreativeTabBuild);
        modBus.addListener(CBMicroblockModContent::onRegisterMicroMaterials);
        modBus.addListener(CBMicroblockModContent::onProcessIMC);
    }

    private static void onCreativeTabBuild(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept((ItemLike)STONE_SAW.get());
            event.accept((ItemLike)IRON_SAW.get());
            event.accept((ItemLike)DIAMOND_SAW.get());
        }
    }

    private static void onProcessIMC(InterModProcessEvent event) {
        CBMicroblockModContent.processIMC(event);
        MicroMaterialConfig.parse(Paths.get("config", "custom-micromaterials.cfg"));
    }

    private static void onRegisterMicroMaterials(RegisterEvent event) {
        event.register(MicroMaterial.MULTIPART_TYPES, r -> {
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GRANITE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.POLISHED_GRANITE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DIORITE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.POLISHED_DIORITE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ANDESITE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.POLISHED_ANDESITE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GRASS_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DIRT));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.COARSE_DIRT));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PODZOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.COBBLESTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.OAK_PLANKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SPRUCE_PLANKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BIRCH_PLANKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.JUNGLE_PLANKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ACACIA_PLANKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CHERRY_PLANKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DARK_OAK_PLANKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MANGROVE_PLANKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BAMBOO_PLANKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BAMBOO_MOSAIC));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SAND));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.RED_SAND));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GRAVEL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GOLD_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEEPSLATE_GOLD_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.IRON_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEEPSLATE_IRON_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.COAL_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEEPSLATE_COAL_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.NETHER_GOLD_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.OAK_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SPRUCE_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BIRCH_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.JUNGLE_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ACACIA_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CHERRY_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DARK_OAK_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MANGROVE_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MANGROVE_ROOTS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MUDDY_MANGROVE_ROOTS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_SPRUCE_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_BIRCH_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_JUNGLE_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_ACACIA_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_CHERRY_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_DARK_OAK_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_OAK_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_MANGROVE_LOG));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_BAMBOO_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.OAK_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SPRUCE_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BIRCH_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.JUNGLE_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ACACIA_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CHERRY_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DARK_OAK_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MANGROVE_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_OAK_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_SPRUCE_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_BIRCH_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_JUNGLE_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_ACACIA_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_CHERRY_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_DARK_OAK_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_MANGROVE_WOOD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.OAK_LEAVES));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SPRUCE_LEAVES));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BIRCH_LEAVES));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.JUNGLE_LEAVES));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ACACIA_LEAVES));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CHERRY_LEAVES));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DARK_OAK_LEAVES));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MANGROVE_LEAVES));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.AZALEA_LEAVES));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.FLOWERING_AZALEA_LEAVES));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SPONGE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WET_SPONGE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LAPIS_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEEPSLATE_LAPIS_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LAPIS_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SANDSTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CHISELED_SANDSTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CUT_SANDSTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WHITE_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ORANGE_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MAGENTA_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIGHT_BLUE_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.YELLOW_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIME_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PINK_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GRAY_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIGHT_GRAY_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CYAN_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PURPLE_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLUE_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BROWN_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GREEN_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.RED_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLACK_WOOL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GOLD_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.IRON_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.TNT));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BOOKSHELF));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CHISELED_BOOKSHELF));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MOSSY_COBBLESTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.OBSIDIAN));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DIAMOND_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEEPSLATE_DIAMOND_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DIAMOND_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CRAFTING_TABLE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.REDSTONE_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEEPSLATE_REDSTONE_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ICE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SNOW_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CLAY));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PUMPKIN));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.NETHERRACK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SOUL_SAND));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SOUL_SOIL));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BASALT));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.POLISHED_BASALT));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GLOWSTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CARVED_PUMPKIN));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.JACK_O_LANTERN));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WHITE_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ORANGE_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MAGENTA_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIGHT_BLUE_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.YELLOW_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIME_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PINK_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GRAY_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIGHT_GRAY_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CYAN_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PURPLE_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLUE_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BROWN_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GREEN_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.RED_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLACK_STAINED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STONE_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MOSSY_STONE_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CRACKED_STONE_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CHISELED_STONE_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PACKED_MUD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MUD_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BROWN_MUSHROOM_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.RED_MUSHROOM_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MUSHROOM_STEM));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MELON));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MYCELIUM));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.NETHER_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.END_STONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial((BlockState)Blocks.REDSTONE_LAMP.defaultBlockState().setValue((Property)RedstoneLampBlock.LIT, (Comparable)Boolean.valueOf(true))));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.EMERALD_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEEPSLATE_EMERALD_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.EMERALD_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.REDSTONE_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.NETHER_QUARTZ_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.QUARTZ_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CHISELED_QUARTZ_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.QUARTZ_PILLAR));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WHITE_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ORANGE_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MAGENTA_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIGHT_BLUE_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.YELLOW_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIME_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PINK_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GRAY_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIGHT_GRAY_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CYAN_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PURPLE_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLUE_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BROWN_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GREEN_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.RED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLACK_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SLIME_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PRISMARINE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PRISMARINE_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DARK_PRISMARINE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SEA_LANTERN));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.HAY_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.COAL_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PACKED_ICE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.RED_SANDSTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CHISELED_RED_SANDSTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CUT_RED_SANDSTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SMOOTH_STONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SMOOTH_SANDSTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SMOOTH_QUARTZ));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SMOOTH_RED_SANDSTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PURPUR_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PURPUR_PILLAR));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.END_STONE_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DIRT_PATH));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MAGMA_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.NETHER_WART_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.RED_NETHER_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BONE_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WHITE_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ORANGE_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MAGENTA_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.YELLOW_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIME_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PINK_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GRAY_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CYAN_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PURPLE_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLUE_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BROWN_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GREEN_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.RED_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLACK_GLAZED_TERRACOTTA));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WHITE_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ORANGE_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MAGENTA_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIGHT_BLUE_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.YELLOW_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIME_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PINK_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GRAY_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIGHT_GRAY_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CYAN_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PURPLE_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLUE_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BROWN_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GREEN_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.RED_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLACK_CONCRETE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WHITE_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ORANGE_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MAGENTA_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIGHT_BLUE_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.YELLOW_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIME_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PINK_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GRAY_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LIGHT_GRAY_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CYAN_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PURPLE_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLUE_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BROWN_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GREEN_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.RED_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLACK_CONCRETE_POWDER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DRIED_KELP_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEAD_TUBE_CORAL_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEAD_BRAIN_CORAL_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEAD_BUBBLE_CORAL_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEAD_FIRE_CORAL_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEAD_HORN_CORAL_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.TUBE_CORAL_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BRAIN_CORAL_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BUBBLE_CORAL_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.FIRE_CORAL_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.HORN_CORAL_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLUE_ICE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WARPED_STEM));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_WARPED_STEM));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WARPED_HYPHAE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_WARPED_HYPHAE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WARPED_NYLIUM));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WARPED_WART_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CRIMSON_STEM));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_CRIMSON_STEM));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CRIMSON_HYPHAE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.STRIPPED_CRIMSON_HYPHAE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CRIMSON_NYLIUM));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CRIMSON_PLANKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WARPED_PLANKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.HONEY_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.HONEYCOMB_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.NETHERITE_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ANCIENT_DEBRIS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CRYING_OBSIDIAN));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.LODESTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.BLACKSTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.POLISHED_BLACKSTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.POLISHED_BLACKSTONE_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CHISELED_POLISHED_BLACKSTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.GILDED_BLACKSTONE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CHISELED_NETHER_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CRACKED_NETHER_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.QUARTZ_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.AMETHYST_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.TUFF));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CALCITE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.TINTED_GLASS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.OXIDIZED_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WEATHERED_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.EXPOSED_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.COPPER_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.COPPER_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEEPSLATE_COPPER_ORE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.OXIDIZED_CUT_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WEATHERED_CUT_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.EXPOSED_CUT_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CUT_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WAXED_COPPER_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WAXED_WEATHERED_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WAXED_EXPOSED_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WAXED_OXIDIZED_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WAXED_OXIDIZED_CUT_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WAXED_WEATHERED_CUT_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WAXED_EXPOSED_CUT_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.WAXED_CUT_COPPER));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DRIPSTONE_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.ROOTED_DIRT));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.MUD));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEEPSLATE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.COBBLED_DEEPSLATE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.POLISHED_DEEPSLATE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEEPSLATE_TILES));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.DEEPSLATE_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CHISELED_DEEPSLATE));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CRACKED_DEEPSLATE_BRICKS));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.CRACKED_DEEPSLATE_TILES));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.SMOOTH_BASALT));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.RAW_IRON_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.RAW_COPPER_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.RAW_GOLD_BLOCK));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.OCHRE_FROGLIGHT));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.VERDANT_FROGLIGHT));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.PEARLESCENT_FROGLIGHT));
            CBMicroblockModContent.registerMaterial((RegisterEvent.RegisterHelper<MicroMaterial>)r, new BlockMicroMaterial(Blocks.REINFORCED_DEEPSLATE));
        });
    }

    private static void registerMaterial(RegisterEvent.RegisterHelper<MicroMaterial> r, BlockMicroMaterial material) {
        r.register(BlockMicroMaterial.makeMaterialKey(material.state), (Object)material);
    }

    private static void processIMC(InterModProcessEvent event) {
        MappedRegistry registry = (MappedRegistry)MicroMaterialRegistry.microMaterials();
        registry.unfreeze();
        event.getIMCStream().forEach(e -> {
            BlockMicroMaterial material;
            if (!e.method().equals("micro_material")) {
                return;
            }
            String sender = e.senderModId();
            Object sent = e.messageSupplier().get();
            if (sent instanceof Block) {
                Block b = (Block)sent;
                material = new BlockMicroMaterial(b);
            } else if (sent instanceof BlockState) {
                BlockState s = (BlockState)sent;
                material = new BlockMicroMaterial(s);
            } else {
                LOGGER.error("Mod {} tried to register a MicroMaterial with an invalid message. Object: '{}', Class: '{}'. IMC only supports Block or BlockState messages.", (Object)sender, sent, sent != null ? sent.getClass().getName() : null);
                return;
            }
            ResourceLocation key = BlockMicroMaterial.makeMaterialKey(material.state);
            if (registry.containsKey(key)) {
                LOGGER.warn("Mod '{}' tried to register a duplicate MicroMaterial. '{}'. Ignoring.", (Object)sender, (Object)key);
                return;
            }
            Registry.register((Registry)registry, (ResourceLocation)key, (Object)material);
        });
        registry.freeze();
    }
}

