/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.bettergrass.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import dev.ultimatchamp.bettergrass.model.BetterGrassifyBakedModel;
import java.util.List;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.SectionCompiler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.event.AddSectionGeometryEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SectionCompiler.class})
public abstract class SectionCompilerMixin {
    @Shadow
    @Final
    private BlockRenderDispatcher blockRenderer;

    @Inject(method={"compile(Lnet/minecraft/core/SectionPos;Lnet/minecraft/client/renderer/chunk/RenderChunkRegion;Lcom/mojang/blaze3d/vertex/VertexSorting;Lnet/minecraft/client/renderer/SectionBufferBuilderPack;Ljava/util/List;)Lnet/minecraft/client/renderer/chunk/SectionCompiler$Results;"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/block/BlockRenderDispatcher;renderBatched(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/BlockAndTintGetter;Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;ZLnet/minecraft/util/RandomSource;Lnet/neoforged/neoforge/client/model/data/ModelData;Lnet/minecraft/client/renderer/RenderType;)V")})
    private void bettergrass$render(SectionPos sectionPos, RenderChunkRegion region, VertexSorting vertexSorting, SectionBufferBuilderPack sectionBufferBuilderPack, List<AddSectionGeometryEvent.AdditionalSectionRenderer> additionalRenderers, CallbackInfoReturnable<SectionCompiler.Results> cir, @Local(ordinal=2) BlockPos blockPos, @Local PoseStack matrixStack, @Local BufferBuilder bufferBuilder, @Local RandomSource random) {
        BlockState layerNeighbour = BetterGrassifyBakedModel.getLayerNeighbour((BlockAndTintGetter)region, blockPos);
        if (layerNeighbour != null && BetterGrassifyBakedModel.canHaveGhostLayer((BlockAndTintGetter)region, blockPos)) {
            matrixStack.pushPose();
            this.blockRenderer.renderBatched(layerNeighbour, blockPos, (BlockAndTintGetter)region, matrixStack, (VertexConsumer)bufferBuilder, true, random);
            matrixStack.popPose();
        }
    }

    @ModifyVariable(method={"compile(Lnet/minecraft/core/SectionPos;Lnet/minecraft/client/renderer/chunk/RenderChunkRegion;Lcom/mojang/blaze3d/vertex/VertexSorting;Lnet/minecraft/client/renderer/SectionBufferBuilderPack;Ljava/util/List;)Lnet/minecraft/client/renderer/chunk/SectionCompiler$Results;"}, at=@At(value="STORE"), ordinal=0)
    private BlockState bettergrass$setGrassState(BlockState state, @Local(ordinal=2) BlockPos blockPos, @Local(argsOnly=true) RenderChunkRegion region) {
        if (state.getOptionalValue((Property)BlockStateProperties.SNOWY).isEmpty()) {
            return state;
        }
        if (!BetterGrassifyBakedModel.isLayerNeighbourSnow((BlockAndTintGetter)region, blockPos.above())) {
            return state;
        }
        if (BetterGrassifyBakedModel.canHaveGhostLayer((BlockAndTintGetter)region, blockPos.above())) {
            return (BlockState)state.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }
}

