#version 150

in vec3 Position;
in vec4 Color;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;

out vec3 texDirection;
out vec4 vertexColor;

void main() {
    mat4 viewRotation = mat4(mat3(ModelViewMat));
    gl_Position = ProjMat * viewRotation * vec4(Position, 1.0);

    texDirection = Position;
    vertexColor = Color;
}
