/*
 * Decompiled with CFR 0.152.
 */
package dev.penguinencounter.figurav5addon;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class GsonTypeByField<T>
implements TypeAdapterFactory {
    private final Class<T> targetType;
    private final Function<JsonElement, @Nullable String> discriminator;
    private Class<? extends T> fallbackType = null;
    private final Map<String, Class<? extends T>> understoodTypes = new HashMap<String, Class<? extends T>>();

    public GsonTypeByField(Class<T> targetType, Function<JsonElement, @Nullable String> discriminator) {
        this.targetType = targetType;
        this.discriminator = discriminator;
    }

    public GsonTypeByField(Class<T> targetType, String discriminatorField) {
        this(targetType, (JsonElement element) -> {
            JsonElement field = element.getAsJsonObject().get(discriminatorField);
            if (field == null || !field.isJsonPrimitive() || !field.getAsJsonPrimitive().isString()) {
                return null;
            }
            return field.getAsString();
        });
    }

    public <R> TypeAdapter<R> create(Gson gson, TypeToken<R> type) {
        if (type == null) {
            return null;
        }
        Class klass = type.getRawType();
        if (!klass.equals(this.targetType)) {
            return null;
        }
        final TypeAdapter element = gson.getAdapter(JsonElement.class);
        final HashMap<String, TypeAdapter> subtypes = new HashMap<String, TypeAdapter>();
        for (Map.Entry<String, Class<T>> entry : this.understoodTypes.entrySet()) {
            TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(entry.getValue()));
            subtypes.put(entry.getKey(), delegate);
        }
        final TypeAdapter fallbackDelegate = this.fallbackType != null ? gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(this.fallbackType)) : null;
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) {
                throw new IllegalArgumentException("Cannot serialize elements using this adapter");
            }

            private T fallback(JsonElement contents, Exception reason) {
                if (fallbackDelegate == null) {
                    throw new JsonParseException("No match: " + reason.toString(), (Throwable)reason);
                }
                return fallbackDelegate.fromJsonTree(contents);
            }

            private T fallback(JsonElement contents, String attempted) {
                if (fallbackDelegate == null) {
                    throw new JsonParseException("No match on '" + attempted + "'");
                }
                return fallbackDelegate.fromJsonTree(contents);
            }

            public T read(JsonReader in) throws IOException {
                String type;
                JsonElement it = (JsonElement)element.read(in);
                try {
                    type = GsonTypeByField.this.discriminator.apply(it);
                }
                catch (RuntimeException err) {
                    return this.fallback(it, err);
                }
                if (type == null) {
                    return this.fallback(it, "<unknown>");
                }
                TypeAdapter delegate = (TypeAdapter)subtypes.get(type);
                if (delegate == null) {
                    return this.fallback(it, type);
                }
                return delegate.fromJsonTree(it);
            }
        };
    }

    public GsonTypeByField<T> bind(String value, Class<? extends T> target) {
        this.understoodTypes.put(value, target);
        return this;
    }

    public GsonTypeByField<T> withFallback(Class<? extends T> fallback) {
        this.fallbackType = fallback;
        return this;
    }
}

