/*
 * Decompiled with CFR 0.152.
 */
package dev.penguinencounter.figurav5addon;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.penguinencounter.figurav5addon.BlockbenchCommonTypes;
import dev.penguinencounter.figurav5addon.BlockbenchParser2;
import dev.penguinencounter.figurav5addon.availability.Polyfills;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.jetbrains.annotations.Nullable;

public class BlockbenchV5Model
extends BlockbenchCommonTypes.ModelFormat {
    private static final FiguraVec3 ZERO = FiguraVec3.of((double)0.0, (double)0.0, (double)0.0);
    BlockbenchCommonTypes.IntPair resolution;
    List<BlockbenchCommonTypes.Element> elements;
    List<Group> groups;
    List<OutlinerItem> outliner;
    List<BlockbenchCommonTypes.Texture> textures;
    List<BlockbenchCommonTypes.Animation> animations;
    List<BlockbenchCommonTypes.Collection> collections;
    public static final IllegalStateException WRONG_FORMAT = new IllegalStateException("Tried to execute the v5 parser on a model file of a different version");
    public static final JsonDeserializer<BlockbenchV5Model> MODEL_DESERIALIZER = (json, typeOfT, context) -> {
        JsonObject obj = json.getAsJsonObject();
        BlockbenchV5Model instance = new BlockbenchV5Model();
        JsonObject meta = obj.getAsJsonObject("meta");
        instance.formatVersion = meta.get("format_version").getAsString();
        instance.modelFormat = meta.get("model_format").getAsString();
        if (!instance.formatVersion.startsWith("5.")) {
            throw WRONG_FORMAT;
        }
        JsonObject resolution = obj.getAsJsonObject("resolution");
        instance.resolution = new BlockbenchCommonTypes.IntPair(resolution.get("width").getAsInt(), resolution.get("height").getAsInt());
        instance.elements = new ArrayList<BlockbenchCommonTypes.Element>();
        if (obj.has("elements")) {
            for (JsonElement item : obj.getAsJsonArray("elements")) {
                instance.elements.add((BlockbenchCommonTypes.Element)context.deserialize(item, BlockbenchCommonTypes.Element.class));
            }
        }
        instance.groups = new ArrayList<Group>();
        if (obj.has("groups")) {
            for (JsonElement item : obj.getAsJsonArray("groups")) {
                instance.groups.add((Group)context.deserialize(item, Group.class));
            }
        }
        instance.outliner = new ArrayList<OutlinerItem>();
        if (obj.has("outliner")) {
            for (JsonElement item : obj.getAsJsonArray("outliner")) {
                instance.outliner.add((OutlinerItem)context.deserialize(item, OutlinerItem.class));
            }
        }
        instance.textures = new ArrayList<BlockbenchCommonTypes.Texture>();
        if (obj.has("textures")) {
            for (JsonElement item : obj.getAsJsonArray("textures")) {
                instance.textures.add((BlockbenchCommonTypes.Texture)context.deserialize(item, BlockbenchCommonTypes.Texture.class));
            }
        }
        instance.animations = new ArrayList<BlockbenchCommonTypes.Animation>();
        if (obj.has("animations")) {
            for (JsonElement item : obj.getAsJsonArray("animations")) {
                instance.animations.add((BlockbenchCommonTypes.Animation)context.deserialize(item, BlockbenchCommonTypes.Animation.class));
            }
        }
        instance.collections = new ArrayList<BlockbenchCommonTypes.Collection>();
        if (obj.has("collections")) {
            for (JsonElement item : obj.getAsJsonArray("collections")) {
                instance.collections.add((BlockbenchCommonTypes.Collection)context.deserialize(item, BlockbenchCommonTypes.Collection.class));
            }
        }
        return instance;
    };
    public static final Pattern DEFINITELY_STMT = Pattern.compile("^\\s*([:;]|break|goto|do|while|repeat|if|for|function\\s*[^\\s(]|local)");
    public static final Pattern RETURN_BOUNDARY = Pattern.compile("\\breturn\\b");

    @Override
    public Map<String, BlockbenchCommonTypes.UUIDReferable> getAllReferences() {
        HashMap<String, BlockbenchCommonTypes.UUIDReferable> refs = new HashMap<String, BlockbenchCommonTypes.UUIDReferable>();
        for (BlockbenchCommonTypes.Element element : this.elements) {
            refs.put(element.uuid, element);
        }
        for (Group group : this.groups) {
            refs.put(group.uuid, group);
        }
        return refs;
    }

    public static String negateLua(String source) {
        if (RETURN_BOUNDARY.matcher(source).find() || DEFINITELY_STMT.matcher(source).find()) {
            return source;
        }
        return String.format("-(%s)", source);
    }

    @Override
    public CompoundTag convert(BlockbenchParser2.Intermediary target) {
        target.defaultRes = this.resolution;
        target.loadTextures(this.textures);
        target.loadAnimations(this.animations);
        for (BlockbenchCommonTypes.Element element : this.elements) {
            target.elements.put(element.uuid, element);
        }
        target.referents.putAll(this.getAllReferences());
        target.loadCollections(this.collections);
        CompoundTag tag = new CompoundTag();
        tag.putString("name", target.name);
        BlockbenchCommonTypes.parseParent(target.name, tag);
        ListTag chld = new ListTag();
        for (OutlinerItem item : this.outliner) {
            CompoundTag itemTag = item.toNBT(target);
            if (itemTag == null) continue;
            chld.add((Object)itemTag);
        }
        tag.put("chld", (Tag)chld);
        ListTag cn = new ListTag();
        for (BlockbenchParser2.Intermediary.CollectionRepresentation collRep : target.collections) {
            cn.add((Object)StringTag.valueOf((String)collRep.name));
        }
        tag.put("cn", (Tag)cn);
        tag.put("_v", (Tag)ByteTag.valueOf((byte)2));
        return tag;
    }

    public static class Group
    implements BlockbenchCommonTypes.UUIDReferable {
        String name;
        String uuid;
        @Nullable
        Boolean visibility;
        @Nullable
        Boolean export;
        FiguraVec3 origin;
        FiguraVec3 rotation;

        @Override
        public String getUUID() {
            return this.uuid;
        }
    }

    public static abstract class OutlinerItem
    implements BlockbenchCommonTypes.NBTRepresentation<CompoundTag> {
        public static final JsonDeserializer<OutlinerItem> DESERIALIZER = (json, typeOfT, context) -> {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                return new Element(json.getAsString());
            }
            if (json.isJsonObject()) {
                JsonObject theObject = json.getAsJsonObject();
                Container instance = new Container(theObject.get("uuid").getAsString());
                for (JsonElement child : theObject.getAsJsonArray("children")) {
                    instance.children.add((OutlinerItem)context.deserialize(child, OutlinerItem.class));
                }
                return instance;
            }
            throw new JsonParseException("Expecting an outliner item (string or object), but found " + json.getClass().getSimpleName() + " instead");
        };
        final String uuid;

        @Override
        @Nullable
        public abstract CompoundTag toNBT(BlockbenchParser2.Intermediary var1);

        public OutlinerItem(String uuid) {
            this.uuid = uuid;
        }

        public static final class Element
        extends OutlinerItem {
            public Element(String uuid) {
                super(uuid);
            }

            @Override
            public CompoundTag toNBT(BlockbenchParser2.Intermediary context) {
                return context.elements.get(this.uuid).toNBT(context);
            }
        }

        public static final class Container
        extends OutlinerItem {
            final List<OutlinerItem> children = new ArrayList<OutlinerItem>();

            public Container(String uuid) {
                super(uuid);
            }

            @Override
            @Nullable
            public CompoundTag toNBT(BlockbenchParser2.Intermediary context) {
                Set<BlockbenchParser2.Intermediary.AnimationRepresentation> animations;
                BlockbenchCommonTypes.UUIDReferable groupProbably = context.referents.get(this.uuid);
                if (!(groupProbably instanceof Group)) {
                    FiguraMod.LOGGER.warn("Broken reference (in model '{}'): expected a group at UUID {} but found {} instead", new Object[]{context.name, this.uuid, groupProbably == null ? "(nothing with that UUID!)" : groupProbably.getClass().getSimpleName()});
                    return null;
                }
                Group group = (Group)groupProbably;
                if (Boolean.FALSE.equals(group.export)) {
                    return null;
                }
                CompoundTag tag = new CompoundTag();
                tag.putString("name", group.name);
                if (Boolean.FALSE.equals(group.visibility)) {
                    tag.putBoolean("vsb", false);
                }
                if (group.origin != null && !group.origin.equals((Object)ZERO)) {
                    tag.put("piv", (Tag)BlockbenchCommonTypes.vecToList(group.origin));
                }
                if (group.rotation != null && !group.rotation.equals((Object)ZERO)) {
                    tag.put("rot", (Tag)BlockbenchCommonTypes.vecToList(group.rotation));
                }
                BlockbenchCommonTypes.parseParent(group.name, tag);
                ListTag chld = new ListTag();
                for (OutlinerItem child : this.children) {
                    CompoundTag childTag = child.toNBT(context);
                    if (childTag == null) continue;
                    if (childTag.contains("vsb") && Objects.equals(group.visibility, Polyfills.CompoundTag_getBoolean(childTag, "vsb"))) {
                        childTag.remove("vsb");
                    }
                    chld.add((Object)childTag);
                }
                if (!chld.isEmpty()) {
                    tag.put("chld", (Tag)chld);
                }
                if ((animations = context.animationsByElement.get(this.uuid)) != null) {
                    ListTag anim = new ListTag();
                    for (BlockbenchParser2.Intermediary.AnimationRepresentation animation : animations) {
                        BlockbenchCommonTypes.Animator animator = animation.partAnimators.get(this.uuid);
                        if (animator == null) {
                            throw new RuntimeException("inconsistent state!! animationsByElement indicated an animator, but none actually present");
                        }
                        CompoundTag attachment = animator.getNBT(animation, true);
                        if (attachment == null) continue;
                        anim.add((Object)attachment);
                    }
                    tag.put("anim", (Tag)anim);
                }
                BlockbenchCommonTypes.attachCollections(context, group.uuid, tag);
                return tag;
            }
        }
    }
}

