/*
 * Decompiled with CFR 0.152.
 */
package dev.penguinencounter.figurav5addon;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import dev.penguinencounter.figurav5addon.BlockbenchCommonTypes;
import dev.penguinencounter.figurav5addon.BlockbenchParser2;
import dev.penguinencounter.figurav5addon.GsonTypeByField;
import dev.penguinencounter.figurav5addon.availability.Polyfills;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.jetbrains.annotations.Nullable;

public class BlockbenchV4Model
extends BlockbenchCommonTypes.ModelFormat {
    private static final FiguraVec3 ZERO = FiguraVec3.of((double)0.0, (double)0.0, (double)0.0);
    BlockbenchCommonTypes.IntPair resolution;
    List<BlockbenchCommonTypes.Element> elements;
    List<OutlinerItem> outliner;
    List<BlockbenchCommonTypes.Texture> textures;
    List<BlockbenchCommonTypes.Animation> animations;
    List<BlockbenchCommonTypes.Collection> collections;
    public static final IllegalStateException WRONG_FORMAT = new IllegalStateException("Tried to execute the v4 parser on a model file of a different version");
    public static final JsonDeserializer<BlockbenchV4Model> MODEL_DESERIALIZER = (json, typeOfT, context) -> {
        JsonObject obj = json.getAsJsonObject();
        BlockbenchV4Model instance = new BlockbenchV4Model();
        JsonObject meta = obj.getAsJsonObject("meta");
        instance.formatVersion = meta.get("format_version").getAsString();
        instance.modelFormat = meta.get("model_format").getAsString();
        if (!instance.formatVersion.startsWith("4.")) {
            throw WRONG_FORMAT;
        }
        JsonObject resolution = obj.getAsJsonObject("resolution");
        instance.resolution = new BlockbenchCommonTypes.IntPair(resolution.get("width").getAsInt(), resolution.get("height").getAsInt());
        instance.elements = new ArrayList<BlockbenchCommonTypes.Element>();
        if (obj.has("elements")) {
            for (JsonElement item : obj.getAsJsonArray("elements")) {
                instance.elements.add((BlockbenchCommonTypes.Element)context.deserialize(item, BlockbenchCommonTypes.Element.class));
            }
        }
        instance.outliner = new ArrayList<OutlinerItem>();
        if (obj.has("outliner")) {
            for (JsonElement item : obj.getAsJsonArray("outliner")) {
                instance.outliner.add((OutlinerItem)context.deserialize(item, OutlinerItem.class));
            }
        }
        instance.textures = new ArrayList<BlockbenchCommonTypes.Texture>();
        if (obj.has("textures")) {
            for (JsonElement item : obj.getAsJsonArray("textures")) {
                instance.textures.add((BlockbenchCommonTypes.Texture)context.deserialize(item, BlockbenchCommonTypes.Texture.class));
            }
        }
        instance.animations = new ArrayList<BlockbenchCommonTypes.Animation>();
        if (obj.has("animations")) {
            for (JsonElement item : obj.getAsJsonArray("animations")) {
                instance.animations.add((BlockbenchCommonTypes.Animation)context.deserialize(item, BlockbenchCommonTypes.Animation.class));
            }
        }
        instance.collections = new ArrayList<BlockbenchCommonTypes.Collection>();
        if (obj.has("collections")) {
            for (JsonElement item : obj.getAsJsonArray("collections")) {
                instance.collections.add((BlockbenchCommonTypes.Collection)context.deserialize(item, BlockbenchCommonTypes.Collection.class));
            }
        }
        return instance;
    };

    @Override
    public Map<String, BlockbenchCommonTypes.UUIDReferable> getAllReferences() {
        HashMap<String, BlockbenchCommonTypes.UUIDReferable> refs = new HashMap<String, BlockbenchCommonTypes.UUIDReferable>();
        for (BlockbenchCommonTypes.Element element : this.elements) {
            refs.put(element.uuid, element);
        }
        for (OutlinerItem item : this.outliner) {
            item.fillContainedRefs(refs);
        }
        return refs;
    }

    @Override
    public CompoundTag convert(BlockbenchParser2.Intermediary target) {
        target.defaultRes = this.resolution;
        target.loadTextures(this.textures);
        for (BlockbenchCommonTypes.Element element : this.elements) {
            target.elements.put(element.uuid, element);
        }
        target.referents.putAll(this.getAllReferences());
        target.loadAnimations(this.animations);
        target.loadCollections(this.collections);
        CompoundTag tag = new CompoundTag();
        tag.putString("name", target.name);
        BlockbenchCommonTypes.parseParent(target.name, tag);
        ListTag chld = new ListTag();
        for (OutlinerItem item : this.outliner) {
            CompoundTag itemTag = item.toNBT(target);
            if (itemTag == null) continue;
            chld.add((Object)itemTag);
        }
        tag.put("chld", (Tag)chld);
        ListTag cn = new ListTag();
        for (BlockbenchParser2.Intermediary.CollectionRepresentation collRep : target.collections) {
            cn.add((Object)StringTag.valueOf((String)collRep.name));
        }
        tag.put("cn", (Tag)cn);
        return tag;
    }

    public static abstract class OutlinerItem
    implements BlockbenchCommonTypes.NBTRepresentation<CompoundTag> {
        public static final TypeAdapterFactory ADAPTER_FACTORY = new GsonTypeByField<OutlinerItem>(OutlinerItem.class, e -> {
            if (e.isJsonObject()) {
                return "group";
            }
            return "element";
        }).bind("group", Group.class).bind("element", Element.class);
        final String uuid;

        @Override
        @Nullable
        public abstract CompoundTag toNBT(BlockbenchParser2.Intermediary var1);

        public OutlinerItem(String uuid) {
            this.uuid = uuid;
        }

        public abstract void fillContainedRefs(Map<String, BlockbenchCommonTypes.UUIDReferable> var1);

        public static final class Group
        extends OutlinerItem
        implements BlockbenchCommonTypes.UUIDReferable {
            @Nullable
            final List<OutlinerItem> children = new ArrayList<OutlinerItem>();
            String name;
            @Nullable
            Boolean visibility;
            @Nullable
            Boolean export;
            FiguraVec3 origin;
            FiguraVec3 rotation;

            public Group(String uuid) {
                super(uuid);
            }

            @Override
            public void fillContainedRefs(Map<String, BlockbenchCommonTypes.UUIDReferable> to) {
                to.put(this.uuid, this);
                if (this.children != null) {
                    this.children.forEach(it -> it.fillContainedRefs(to));
                }
            }

            @Override
            public String getUUID() {
                return this.uuid;
            }

            @Override
            @Nullable
            public CompoundTag toNBT(BlockbenchParser2.Intermediary context) {
                Set<BlockbenchParser2.Intermediary.AnimationRepresentation> animations;
                if (Boolean.FALSE.equals(this.export)) {
                    return null;
                }
                CompoundTag tag = new CompoundTag();
                tag.putString("name", this.name);
                if (Boolean.FALSE.equals(this.visibility)) {
                    tag.putBoolean("vsb", false);
                }
                if (this.origin != null && !this.origin.equals((Object)ZERO)) {
                    tag.put("piv", (Tag)BlockbenchCommonTypes.vecToList(this.origin));
                }
                if (this.rotation != null && !this.rotation.equals((Object)ZERO)) {
                    tag.put("rot", (Tag)BlockbenchCommonTypes.vecToList(this.rotation));
                }
                BlockbenchCommonTypes.parseParent(this.name, tag);
                if (this.children != null) {
                    ListTag chld = new ListTag();
                    for (OutlinerItem child : this.children) {
                        CompoundTag childTag = child.toNBT(context);
                        if (childTag == null) continue;
                        if (childTag.contains("vsb") && Objects.equals(this.visibility, Polyfills.CompoundTag_getBoolean(childTag, "vsb"))) {
                            childTag.remove("vsb");
                        }
                        chld.add((Object)childTag);
                    }
                    if (!chld.isEmpty()) {
                        tag.put("chld", (Tag)chld);
                    }
                }
                if ((animations = context.animationsByElement.get(this.uuid)) != null) {
                    ListTag anim = new ListTag();
                    for (BlockbenchParser2.Intermediary.AnimationRepresentation animation : animations) {
                        BlockbenchCommonTypes.Animator animator = animation.partAnimators.get(this.uuid);
                        if (animator == null) {
                            throw new RuntimeException("inconsistent state!! animationsByElement indicated an animator, but none actually present");
                        }
                        CompoundTag attachment = animator.getNBT(animation, false);
                        if (attachment == null) continue;
                        anim.add((Object)attachment);
                    }
                    tag.put("anim", (Tag)anim);
                }
                BlockbenchCommonTypes.attachCollections(context, this.uuid, tag);
                return tag;
            }
        }

        public static final class Element
        extends OutlinerItem {
            public static final JsonDeserializer<Element> DESERIALIZER = (json, typeOfT, context) -> new Element(json.getAsString());

            public Element(String uuid) {
                super(uuid);
            }

            @Override
            public void fillContainedRefs(Map<String, BlockbenchCommonTypes.UUIDReferable> to) {
            }

            @Override
            @Nullable
            public CompoundTag toNBT(BlockbenchParser2.Intermediary context) {
                BlockbenchCommonTypes.Element ref = context.elements.get(this.uuid);
                if (ref == null) {
                    return null;
                }
                return ref.toNBT(context);
            }
        }
    }
}

