/*
 * Decompiled with CFR 0.152.
 */
package dev.penguinencounter.figurav5addon;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.Gson;
import dev.penguinencounter.figurav5addon.BlockbenchCommonTypes;
import dev.penguinencounter.figurav5addon.ModelParseResult;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.utils.IOUtils;
import org.jetbrains.annotations.Nullable;

public class BlockbenchParser2 {
    private static final Gson GSON = BlockbenchCommonTypes.getGson();
    private int nextTexture = 0;
    private int nextAnimation = 0;

    public ModelParseResult parseModel(Path avatarRoot, Path modelPath, String json, String modelName, String locatedWithin, @Nullable LoadOptions options) throws Exception {
        try {
            boolean validFormat;
            BlockbenchCommonTypes.ModelFormat model = (BlockbenchCommonTypes.ModelFormat)GSON.fromJson(json, BlockbenchCommonTypes.ModelFormat.class);
            boolean bl = validFormat = model.modelFormat.equals("free") || model.modelFormat.contains("figura");
            if (!validFormat) {
                throw new Exception(String.format("Model \"%s\" has an incompatible model format: \"%s\".\nCompatibility is limited to the \"Generic Model\" format and third-party %s-specific formats.", modelName, model.modelFormat, "Figura"));
            }
            Intermediary container = new Intermediary(this, options == null ? LoadOptions.DEFAULT : options);
            container.name = modelName;
            container.avatarRoot = avatarRoot;
            container.modelPath = modelPath;
            container.locatedWithin = locatedWithin;
            CompoundTag nbt = model.convert(container);
            return new ModelParseResult(container.getTexturesNBT(), container.getAnimationsNBT(), nbt);
        }
        catch (Exception e) {
            throw new Exception(String.format("model \"%s\": %s", modelName, e.getMessage()), e);
        }
    }

    public static class Intermediary {
        private final BlockbenchParser2 parser;
        public final LoadOptions options;
        public String name;
        public Path modelPath;
        public Path avatarRoot;
        public String locatedWithin;
        public BlockbenchCommonTypes.IntPair defaultRes;
        private final List<TextureRepresentation> textures = new ArrayList<TextureRepresentation>();
        private final HashMap<String, Map<String, TextureRepresentation>> textureNames = new HashMap();
        public final Map<String, BlockbenchCommonTypes.Element> elements = new HashMap<String, BlockbenchCommonTypes.Element>();
        public final Map<String, BlockbenchCommonTypes.UUIDReferable> referents = new HashMap<String, BlockbenchCommonTypes.UUIDReferable>();
        public final List<AnimationRepresentation> animations = new ArrayList<AnimationRepresentation>();
        public final Map<String, Set<AnimationRepresentation>> animationsByElement = new HashMap<String, Set<AnimationRepresentation>>();
        public final List<CollectionRepresentation> collections = new ArrayList<CollectionRepresentation>();
        public final Multimap<String, Integer> collectionsByElement = MultimapBuilder.hashKeys().hashSetValues().build();

        public Intermediary(BlockbenchParser2 parser, LoadOptions options) {
            this.parser = parser;
            this.options = options;
        }

        public void loadTextures(List<BlockbenchCommonTypes.Texture> textures) {
            int i = 0;
            for (BlockbenchCommonTypes.Texture texture : textures) {
                TextureRepresentation texRep = new TextureRepresentation(texture);
                texRep.localID = i++;
                this.textureNames.compute(texRep.name, (k, v) -> {
                    if (v == null) {
                        texRep.globalID = this.parser.nextTexture++;
                        v = new HashMap<String, TextureRepresentation>();
                    } else {
                        texRep.globalID = ((TextureRepresentation)v.values().iterator().next()).globalID;
                    }
                    v.put(texRep.textureType, texRep);
                    return v;
                });
                this.textures.add(texRep);
            }
        }

        public void loadAnimations(List<BlockbenchCommonTypes.Animation> animations) {
            for (BlockbenchCommonTypes.Animation animation : animations) {
                AnimationRepresentation animRep = new AnimationRepresentation(this.parser.nextAnimation++, animation);
                this.animations.add(animRep);
            }
        }

        public void loadCollections(List<BlockbenchCommonTypes.Collection> collections) {
            int i = 0;
            for (BlockbenchCommonTypes.Collection collection : collections) {
                CollectionRepresentation coll = new CollectionRepresentation(i++, collection);
                this.collections.add(coll);
            }
        }

        @Nullable
        public Integer getTextureGlobalID(int localID) {
            if (localID < 0 || this.textures.size() <= localID) {
                return null;
            }
            return this.textures.get((int)localID).globalID;
        }

        public FiguraVec2 getTextureFixedSize(int localID) {
            return this.textures.get((int)localID).fixedSize;
        }

        public CompoundTag getTexturesNBT() {
            CompoundTag tag = new CompoundTag();
            CompoundTag sources = new CompoundTag();
            LinkedHashMap<String, CompoundTag> buildData = new LinkedHashMap<String, CompoundTag>();
            for (TextureRepresentation texture : this.textures) {
                sources.put(texture.path, (Tag)texture.getSourceNBT());
                buildData.compute(texture.name, (k, it) -> {
                    if (it == null) {
                        it = new CompoundTag();
                    }
                    if (it.contains(texture.textureType)) {
                        throw new RuntimeException("Model \"" + this.name + "\" contains texture with duplicate name \"" + texture.name + "\"");
                    }
                    it.putString(texture.textureType, texture.path);
                    return it;
                });
            }
            ListTag data = new ListTag();
            data.addAll(buildData.values());
            tag.put("src", (Tag)sources);
            tag.put("data", (Tag)data);
            return tag;
        }

        public List<CompoundTag> getAnimationsNBT() {
            ArrayList<CompoundTag> list = new ArrayList<CompoundTag>();
            for (AnimationRepresentation animation : this.animations) {
                list.add(animation.getAnimNBT());
            }
            return list;
        }

        public class TextureRepresentation {
            public String name;
            public int globalID;
            public int localID;
            public final String textureType;
            public String path;
            public byte[] source;
            public final FiguraVec2 fixedSize;

            public TextureRepresentation(BlockbenchCommonTypes.Texture texture) {
                this.name = texture.name;
                if (this.name.endsWith(".png")) {
                    this.name = this.name.substring(0, this.name.length() - 4);
                }
                this.textureType = this.name.endsWith("_e") ? "e" : (this.name.endsWith("_n") ? "n" : (this.name.endsWith("_s") ? "s" : "d"));
                try {
                    if (texture.relative_path == null) {
                        throw new RuntimeException("load from source");
                    }
                    Path p = Intermediary.this.modelPath.getParent().resolve(texture.relative_path);
                    if (p.getFileSystem() == FileSystems.getDefault()) {
                        p = p.toFile().getCanonicalFile().toPath();
                    }
                    if ((!Files.exists(p = p.normalize(), new LinkOption[0]) || Intermediary.this.avatarRoot.getNameCount() > 1 && !p.startsWith(Intermediary.this.avatarRoot)) && texture.relative_path.startsWith("../")) {
                        p = Intermediary.this.modelPath.resolve(texture.relative_path);
                        if (p.getFileSystem() == FileSystems.getDefault()) {
                            p = p.toFile().getCanonicalFile().toPath();
                        }
                        p = p.normalize();
                    }
                    if (!Files.exists(p, new LinkOption[0])) {
                        throw new FileNotFoundException("Could not locate texture '" + texture.name + "'");
                    }
                    if (Intermediary.this.avatarRoot.getNameCount() > 1 && !p.startsWith(Intermediary.this.avatarRoot) || p.getFileSystem() != Intermediary.this.avatarRoot.getFileSystem()) {
                        throw new IllegalStateException("Texture '" + texture.name + "' is a reference outside the avatar folder");
                    }
                    FiguraMod.debug((String)"Loading texture {}: path is {}", (Object[])new Object[]{texture.name, p.toString()});
                    this.source = IOUtils.readFileBytes((Path)p);
                    this.path = Intermediary.this.avatarRoot.relativize(p).toString().replace(p.getFileSystem().getSeparator(), ".");
                    this.path = this.path.substring(0, this.path.length() - 4);
                    this.name = Intermediary.this.locatedWithin + this.name;
                    FiguraMod.debug((String)"Loaded {} texture \"{}\" as path {} (from {})", (Object[])new Object[]{this.textureType, this.name, this.path, p});
                }
                catch (Exception e) {
                    if (e instanceof IOException || e instanceof NullPointerException) {
                        FiguraMod.LOGGER.error("", (Throwable)e);
                    }
                    if (texture.source == null || !texture.source.startsWith("data:image/png;base64,")) {
                        throw new IllegalStateException(String.format("Failed to find the %s texture: %s\n(and the bundled texture data was missing or bad)", texture.name, e));
                    }
                    this.source = Base64.getDecoder().decode(texture.source.substring("data:image/png;base64,".length()));
                    this.path = Intermediary.this.locatedWithin + Intermediary.this.name + "." + this.name;
                    FiguraMod.debug((String)"Loaded {} texture \"{}\" as path {} (bundled)", (Object[])new Object[]{this.textureType, this.name, this.path});
                }
                if (!this.textureType.equals("d")) {
                    this.name = this.name.substring(0, this.name.length() - 2);
                }
                if (texture.width != null) {
                    this.fixedSize = FiguraVec2.of((double)(texture.width.floatValue() / texture.uv_width.floatValue()), (double)(texture.height.floatValue() / texture.uv_height.floatValue()));
                } else {
                    BlockbenchCommonTypes.IntPair imageSize = BlockbenchCommonTypes.getPNGDimensions(this.source);
                    this.fixedSize = FiguraVec2.of((double)((float)imageSize.x / (float)Intermediary.this.defaultRes.x), (double)((float)imageSize.y / (float)Intermediary.this.defaultRes.y));
                }
            }

            public ByteArrayTag getSourceNBT() {
                return new ByteArrayTag(this.source);
            }
        }

        public class AnimationRepresentation {
            public final int globalID;
            final String mdl;
            final String name;
            final String loop;
            final boolean override;
            final float length;
            final float offset;
            final float blend;
            final float startDelay;
            final float loopDelay;
            public final Map<String, BlockbenchCommonTypes.Animator> partAnimators;
            @Nullable
            public final BlockbenchCommonTypes.Animator fxAnimator;

            public AnimationRepresentation(int globalID, BlockbenchCommonTypes.Animation animation) {
                this.mdl = Intermediary.this.locatedWithin.isBlank() ? Intermediary.this.name : Intermediary.this.locatedWithin + Intermediary.this.name;
                this.globalID = globalID;
                this.name = animation.name;
                this.loop = animation.loop == null ? "once" : animation.loop;
                this.override = Boolean.TRUE.equals(animation.override);
                this.length = animation.length;
                this.offset = BlockbenchCommonTypes.parseFloatOr(animation.anim_time_update, 0.0f);
                this.blend = BlockbenchCommonTypes.parseFloatOr(animation.blend_weight, 1.0f);
                this.startDelay = BlockbenchCommonTypes.parseFloatOr(animation.start_delay, 0.0f);
                this.loopDelay = BlockbenchCommonTypes.parseFloatOr(animation.loop_delay, 0.0f);
                if (animation.animators != null) {
                    HashMap<String, BlockbenchCommonTypes.Animator> filtered = new HashMap<String, BlockbenchCommonTypes.Animator>(animation.animators);
                    this.fxAnimator = (BlockbenchCommonTypes.Animator)filtered.remove("effects");
                    this.partAnimators = filtered;
                } else {
                    this.fxAnimator = null;
                    this.partAnimators = new HashMap<String, BlockbenchCommonTypes.Animator>();
                }
                for (Map.Entry<String, BlockbenchCommonTypes.Animator> entry : this.partAnimators.entrySet()) {
                    Intermediary.this.animationsByElement.compute(entry.getKey(), (k, v) -> {
                        if (v == null) {
                            v = new LinkedHashSet<AnimationRepresentation>();
                        }
                        v.add(this);
                        return v;
                    });
                }
            }

            public CompoundTag getAnimNBT() {
                ListTag code;
                CompoundTag tag = new CompoundTag();
                tag.putString("mdl", this.mdl);
                tag.putString("name", this.name);
                if (!this.loop.equals("once")) {
                    tag.putString("loop", this.loop);
                }
                if (this.override) {
                    tag.putBoolean("ovr", true);
                }
                if (this.length != 0.0f) {
                    tag.putFloat("len", this.length);
                }
                if (this.offset != 0.0f) {
                    tag.putFloat("off", this.offset);
                }
                if (this.blend != 1.0f) {
                    tag.putFloat("bld", this.blend);
                }
                if (this.startDelay != 0.0f) {
                    tag.putFloat("sdel", this.startDelay);
                }
                if (this.loopDelay != 0.0f) {
                    tag.putFloat("ldel", this.loopDelay);
                }
                if ((code = this.getEffectsNBT()) != null) {
                    tag.put("code", (Tag)code);
                }
                return tag;
            }

            @Nullable
            private ListTag getEffectsNBT() {
                if (this.fxAnimator == null) {
                    return null;
                }
                ListTag fxData = new ListTag();
                if (this.fxAnimator.keyframes != null) {
                    for (BlockbenchCommonTypes.Keyframe keyframe : this.fxAnimator.keyframes) {
                        if (!keyframe.channel.equalsIgnoreCase("timeline") || !(keyframe instanceof BlockbenchCommonTypes.Keyframe.InstructionKeyframe)) continue;
                        BlockbenchCommonTypes.Keyframe.InstructionKeyframe ik = (BlockbenchCommonTypes.Keyframe.InstructionKeyframe)keyframe;
                        CompoundTag kfTag = new CompoundTag();
                        kfTag.putFloat("time", ik.time);
                        kfTag.putString("src", ik.data_points[0].script);
                        fxData.add((Object)kfTag);
                    }
                }
                return fxData;
            }
        }

        public class CollectionRepresentation {
            public final String name;
            public final int localID;

            public CollectionRepresentation(int localID, BlockbenchCommonTypes.Collection source) {
                this.name = source.name;
                this.localID = localID;
                source.children.forEach(it -> Intermediary.this.collectionsByElement.put(it, (Object)localID));
            }
        }
    }

    public static class LoadOptions {
        public static final LoadOptions DEFAULT = new LoadOptions();
        public boolean partsWithUUIDs;
    }
}

