/*
 * Decompiled with CFR 0.152.
 */
package dev.penguinencounter.figurav5addon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapterFactory;
import dev.penguinencounter.figurav5addon.BlockbenchParser2;
import dev.penguinencounter.figurav5addon.BlockbenchV4Model;
import dev.penguinencounter.figurav5addon.BlockbenchV5Model;
import dev.penguinencounter.figurav5addon.GsonTypeByField;
import dev.penguinencounter.figurav5addon.availability.UUIDUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.figuramc.figura.math.vector.FiguraVec2;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.math.vector.FiguraVec4;
import org.figuramc.figura.model.ParentType;
import org.jetbrains.annotations.Nullable;

public class BlockbenchCommonTypes {
    public static final byte FORMATLESS = 0;
    public static final byte FORMAT_V4 = 1;
    public static final byte FORMAT_V5 = 2;
    private static final FiguraVec3 ZERO = FiguraVec3.of((double)0.0, (double)0.0, (double)0.0);
    private static final FiguraVec4 ZERO4 = FiguraVec4.of((double)0.0, (double)0.0, (double)0.0, (double)0.0);
    public static final JsonDeserializer<FiguraVec4> VEC4_DESERIALIZER = (json, typeOfT, context) -> {
        JsonArray four = json.getAsJsonArray();
        if (four.size() != 4) {
            throw new JsonParseException("Trying to parse a Vector4, but the list has " + four.size() + " items (expected 4)");
        }
        return FiguraVec4.of((double)BlockbenchCommonTypes.floatOrZero(four.get(0)), (double)BlockbenchCommonTypes.floatOrZero(four.get(1)), (double)BlockbenchCommonTypes.floatOrZero(four.get(2)), (double)BlockbenchCommonTypes.floatOrZero(four.get(3)));
    };
    public static final JsonDeserializer<FiguraVec3> VEC3_DESERIALIZER = (json, typeOfT, context) -> {
        JsonArray three = json.getAsJsonArray();
        if (three.size() != 3) {
            throw new JsonParseException("Trying to parse a Vector3, but the list has " + three.size() + " items (expected 3)");
        }
        return FiguraVec3.of((double)BlockbenchCommonTypes.floatOrZero(three.get(0)), (double)BlockbenchCommonTypes.floatOrZero(three.get(1)), (double)BlockbenchCommonTypes.floatOrZero(three.get(2)));
    };
    public static final JsonDeserializer<FiguraVec2> VEC2_DESERIALIZER = (json, typeOfT, context) -> {
        JsonArray two = json.getAsJsonArray();
        if (two.size() != 2) {
            throw new JsonParseException("Trying to parse a Vector2, but the list has " + two.size() + " items (expected 2)");
        }
        return FiguraVec2.of((double)BlockbenchCommonTypes.floatOrZero(two.get(0)), (double)BlockbenchCommonTypes.floatOrZero(two.get(1)));
    };

    public static Gson getGson() {
        return new GsonBuilder().registerTypeAdapter(BlockbenchV5Model.class, BlockbenchV5Model.MODEL_DESERIALIZER).registerTypeAdapter(BlockbenchV4Model.class, BlockbenchV4Model.MODEL_DESERIALIZER).registerTypeAdapter(FiguraVec4.class, VEC4_DESERIALIZER).registerTypeAdapter(FiguraVec3.class, VEC3_DESERIALIZER).registerTypeAdapter(FiguraVec2.class, VEC2_DESERIALIZER).registerTypeAdapter(BlockbenchV5Model.OutlinerItem.class, BlockbenchV5Model.OutlinerItem.DESERIALIZER).registerTypeAdapter(BlockbenchV4Model.OutlinerItem.Element.class, BlockbenchV4Model.OutlinerItem.Element.DESERIALIZER).registerTypeAdapterFactory(ModelFormat.ADAPTER_FACTORY).registerTypeAdapterFactory(Element.ADAPTER_FACTORY).registerTypeAdapterFactory(Keyframe.ADAPTER_FACTORY).registerTypeAdapterFactory(BlockbenchV4Model.OutlinerItem.ADAPTER_FACTORY).create();
    }

    public static void parseParent(String name, CompoundTag nbt) {
        ParentType parentType = ParentType.get((String)name);
        if (parentType != ParentType.None) {
            nbt.putString("pt", parentType.name());
        }
    }

    public static IntPair getPNGDimensions(byte[] png) {
        int w = png[16] & 0xFF;
        w = (w << 8) + (png[17] & 0xFF);
        w = (w << 8) + (png[18] & 0xFF);
        w = (w << 8) + (png[19] & 0xFF);
        int h = png[20] & 0xFF;
        h = (h << 8) + (png[21] & 0xFF);
        h = (h << 8) + (png[22] & 0xFF);
        h = (h << 8) + (png[23] & 0xFF);
        return new IntPair(w, h);
    }

    public static void attachCollections(BlockbenchParser2.Intermediary context, String uuid, CompoundTag target) {
        ArrayList collections = new ArrayList(context.collectionsByElement.get((Object)uuid));
        if (!collections.isEmpty()) {
            byte[] prs = new byte[collections.size()];
            for (int i = 0; i < collections.size(); ++i) {
                prs[i] = ((Integer)collections.get(i)).byteValue();
            }
            target.put("pr", (Tag)new ByteArrayTag(prs));
        }
    }

    private static float floatOrZero(JsonElement it) {
        if (!it.isJsonPrimitive()) {
            return 0.0f;
        }
        JsonPrimitive prim = it.getAsJsonPrimitive();
        if (!prim.isNumber()) {
            return 0.0f;
        }
        return prim.getAsFloat();
    }

    public static ListTag floatArrToList(float[] fa) {
        int type = 0;
        for (float c : fa) {
            if (c % 1.0f == 0.0f) {
                if (c < -127.0f || c >= 128.0f) {
                    type = 1;
                }
                if (!(c < -16383.0f) && !(c >= 16384.0f)) continue;
                type = 2;
                break;
            }
            type = 2;
            break;
        }
        ListTag tag = new ListTag();
        block6: for (float c : fa) {
            switch (type) {
                case 0: {
                    tag.add((Object)ByteTag.valueOf((byte)((byte)c)));
                    continue block6;
                }
                case 1: {
                    tag.add((Object)ShortTag.valueOf((short)((short)c)));
                    continue block6;
                }
                case 2: {
                    tag.add((Object)FloatTag.valueOf((float)c));
                }
            }
        }
        return tag;
    }

    public static ListTag vecToList(FiguraVec3 vector) {
        return BlockbenchCommonTypes.floatArrToList(new float[]{(float)vector.x, (float)vector.y, (float)vector.z});
    }

    public static ListTag vecToList(FiguraVec4 vector) {
        return BlockbenchCommonTypes.floatArrToList(new float[]{(float)vector.x, (float)vector.y, (float)vector.z, (float)vector.w});
    }

    public static float parseFloatOr(@Nullable String floatLike, float fallback) {
        if (floatLike == null || floatLike.isBlank()) {
            return fallback;
        }
        try {
            return Float.parseFloat(floatLike);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static abstract class ModelFormat {
        String formatVersion;
        public static final Pattern FORMAT_VERSION_MATCHER = Pattern.compile("^(\\d+?)\\.");
        public static final TypeAdapterFactory ADAPTER_FACTORY = new GsonTypeByField<ModelFormat>(ModelFormat.class, obj -> {
            String version = obj.getAsJsonObject().getAsJsonObject("meta").get("format_version").getAsString();
            Matcher matcher = FORMAT_VERSION_MATCHER.matcher(version);
            if (!matcher.find()) {
                throw new IllegalStateException("No match on version number");
            }
            return matcher.group(1);
        }).bind("5", BlockbenchV5Model.class).bind("4", BlockbenchV4Model.class);
        String modelFormat;

        public abstract Map<String, UUIDReferable> getAllReferences();

        public abstract CompoundTag convert(BlockbenchParser2.Intermediary var1);
    }

    public static abstract class Element
    implements UUIDReferable,
    NBTRepresentation<CompoundTag> {
        public static final TypeAdapterFactory ADAPTER_FACTORY = new GsonTypeByField<Element>(Element.class, "type").bind("cube", CubeElement.class).bind("mesh", MeshElement.class).bind("locator", PointElement.class).bind("null_object", PointElement.class).withFallback(UnknownElement.class);
        String name;
        String type;
        String uuid;
        FiguraVec3 rotation;
        FiguraVec3 origin;
        @Nullable
        Boolean visibility;
        @Nullable
        Boolean export;

        @Override
        public String getUUID() {
            return this.uuid;
        }

        @Override
        @Nullable
        public CompoundTag toNBT(BlockbenchParser2.Intermediary context) {
            CompoundTag tag = new CompoundTag();
            if (Boolean.FALSE.equals(this.export)) {
                return null;
            }
            tag.putString("name", this.name);
            if (context.options.partsWithUUIDs) {
                try {
                    tag.putIntArray("nr", UUIDUtil.uuidToIntArray(UUID.fromString(this.uuid)));
                }
                catch (IllegalArgumentException ignored) {
                    tag.putString("nr", this.uuid);
                }
            }
            if (this.rotation != null && !this.rotation.equals((Object)ZERO)) {
                tag.put("rot", (Tag)BlockbenchCommonTypes.vecToList(this.rotation));
            }
            if (this.origin != null && !this.origin.equals((Object)ZERO)) {
                tag.put("piv", (Tag)BlockbenchCommonTypes.vecToList(this.origin));
            }
            if (Boolean.FALSE.equals(this.visibility)) {
                tag.putBoolean("vsb", false);
            }
            BlockbenchCommonTypes.attachCollections(context, this.uuid, tag);
            return tag;
        }
    }

    public static class Keyframe {
        public static final TypeAdapterFactory ADAPTER_FACTORY = new GsonTypeByField<Keyframe>(Keyframe.class, "channel").bind("position", Keyframe3.class).bind("rotation", Keyframe3.class).bind("scale", Keyframe3.class).bind("timeline", InstructionKeyframe.class).withFallback(Keyframe.class);
        String channel;
        @Nullable
        String interpolation;
        float time;
        FiguraVec3 bezier_left_time;
        FiguraVec3 bezier_left_value;
        FiguraVec3 bezier_right_time;
        FiguraVec3 bezier_right_value;

        public static Object kfData(String in, float fallback) {
            if (in == null || in.isBlank()) {
                return Float.valueOf(fallback);
            }
            try {
                return Float.valueOf(Float.parseFloat(in));
            }
            catch (NumberFormatException e) {
                return in;
            }
        }

        public static class Keyframe3
        extends Keyframe {
            Data[] data_points;

            public static class Data {
                String x;
                String y;
                String z;

                /*
                 * Enabled aggressive block sorting
                 */
                public ListTag toNBT(String channel, boolean invX, boolean invY) {
                    float fallback = channel.equals("scale") ? 1.0f : 0.0f;
                    Object x = Keyframe.kfData(this.x, fallback);
                    Object y = Keyframe.kfData(this.y, fallback);
                    Object z = Keyframe.kfData(this.z, fallback);
                    ListTag tag = new ListTag();
                    if (x instanceof Float) {
                        Float xf = (Float)x;
                        if (y instanceof Float) {
                            Float yf = (Float)y;
                            if (z instanceof Float) {
                                Float zf = (Float)z;
                                float xs = invX ? -1.0f : 1.0f;
                                float ys = invY ? -1.0f : 1.0f;
                                tag.add((Object)FloatTag.valueOf((float)(xf.floatValue() * xs)));
                                tag.add((Object)FloatTag.valueOf((float)(yf.floatValue() * ys)));
                                tag.add((Object)FloatTag.valueOf((float)zf.floatValue()));
                                return tag;
                            }
                        }
                    }
                    if (invX) {
                        tag.add((Object)StringTag.valueOf((String)BlockbenchV5Model.negateLua(String.valueOf(x))));
                    } else {
                        tag.add((Object)StringTag.valueOf((String)String.valueOf(x)));
                    }
                    if (invY) {
                        tag.add((Object)StringTag.valueOf((String)BlockbenchV5Model.negateLua(String.valueOf(y))));
                    } else {
                        tag.add((Object)StringTag.valueOf((String)String.valueOf(y)));
                    }
                    tag.add((Object)StringTag.valueOf((String)String.valueOf(z)));
                    return tag;
                }
            }
        }

        public static class InstructionKeyframe
        extends Keyframe {
            Data[] data_points;

            public static class Data {
                String script;
            }
        }
    }

    public static class IntPair {
        public int x;
        public int y;

        public IntPair(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class Collection
    implements UUIDReferable {
        String uuid;
        String name;
        List<String> children;

        @Override
        public String getUUID() {
            return this.uuid;
        }
    }

    public static class Texture {
        String name;
        @Nullable
        String source;
        @Nullable
        String relative_path;
        Float width;
        Float height;
        Float uv_width;
        Float uv_height;
    }

    public static class Animator {
        public static final FiguraVec3 v5_ROT_TRANS = FiguraVec3.of((double)-1.0, (double)-1.0, (double)1.0);
        public static final FiguraVec3 v5_POS_TRANS = FiguraVec3.of((double)-1.0, (double)1.0, (double)1.0);
        private static final FiguraVec3 DO_NOTHING = FiguraVec3.of((double)1.0, (double)1.0, (double)1.0);
        private static final FiguraVec3 LEFT_TIMING = FiguraVec3.of((double)-0.1f, (double)-0.1f, (double)-0.1f);
        private static final FiguraVec3 RIGHT_TIMING = FiguraVec3.of((double)0.1f, (double)0.1f, (double)0.1f);
        String name;
        String type;
        @Nullable
        Boolean rotation_global;
        @Nullable
        Boolean quaternion_interpolation;
        @Nullable
        List<Keyframe> keyframes;

        @Nullable
        public CompoundTag getNBT(BlockbenchParser2.Intermediary.AnimationRepresentation animContext, boolean isV5) {
            if ("effect".equals(this.type)) {
                throw new RuntimeException("Shouldn't be attaching FX animators to parts!");
            }
            FiguraVec3 rotTrans = isV5 ? v5_ROT_TRANS : DO_NOTHING;
            FiguraVec3 posTrans = isV5 ? v5_POS_TRANS : DO_NOTHING;
            ListTag rot = new ListTag();
            ListTag pos = new ListTag();
            ListTag scale = new ListTag();
            if (this.keyframes != null) {
                for (Keyframe kf : this.keyframes) {
                    if (!(kf instanceof Keyframe.Keyframe3)) continue;
                    Keyframe.Keyframe3 kf3 = (Keyframe.Keyframe3)kf;
                    CompoundTag kfTag = new CompoundTag();
                    kfTag.putFloat("time", kf3.time);
                    kfTag.putString("int", kf3.interpolation != null ? kf3.interpolation : "linear");
                    Keyframe.Keyframe3.Data pre = kf3.data_points[0];
                    boolean transX = isV5 && (kf3.channel.equals("rotation") || kf3.channel.equals("position"));
                    boolean transY = isV5 && kf3.channel.equals("rotation");
                    FiguraVec3 trans = switch (kf3.channel) {
                        case "rotation" -> rotTrans;
                        case "position" -> posTrans;
                        default -> DO_NOTHING;
                    };
                    kfTag.put("pre", (Tag)pre.toNBT(kf3.channel, transX, transY));
                    if (kf3.data_points.length > 1) {
                        Keyframe.Keyframe3.Data post = kf3.data_points[1];
                        kfTag.put("end", (Tag)post.toNBT(kf3.channel, transX, transY));
                    }
                    if (kf3.bezier_left_value != null && !kf3.bezier_left_value.equals((Object)ZERO)) {
                        kfTag.put("bl", (Tag)BlockbenchCommonTypes.vecToList(kf3.bezier_left_value.copy().multiply(trans)));
                    }
                    if (kf3.bezier_right_value != null && !kf3.bezier_right_value.equals((Object)ZERO)) {
                        kfTag.put("br", (Tag)BlockbenchCommonTypes.vecToList(kf3.bezier_right_value.copy().multiply(trans)));
                    }
                    if (kf3.bezier_left_time != null && !kf3.bezier_left_time.equals((Object)LEFT_TIMING)) {
                        kfTag.put("blt", (Tag)BlockbenchCommonTypes.vecToList(kf3.bezier_left_time));
                    }
                    if (kf3.bezier_right_time != null && !kf3.bezier_right_time.equals((Object)RIGHT_TIMING)) {
                        kfTag.put("brt", (Tag)BlockbenchCommonTypes.vecToList(kf3.bezier_right_time));
                    }
                    switch (kf3.channel) {
                        case "position": {
                            pos.add((Object)kfTag);
                            break;
                        }
                        case "rotation": {
                            rot.add((Object)kfTag);
                            break;
                        }
                        case "scale": {
                            scale.add((Object)kfTag);
                        }
                    }
                }
            }
            CompoundTag animatorTag = new CompoundTag();
            CompoundTag channels = new CompoundTag();
            if (!rot.isEmpty()) {
                if (Boolean.TRUE.equals(this.rotation_global)) {
                    channels.put("grot", (Tag)rot);
                } else {
                    channels.put("rot", (Tag)rot);
                }
            }
            if (!pos.isEmpty()) {
                channels.put("pos", (Tag)pos);
            }
            if (!scale.isEmpty()) {
                channels.put("scl", (Tag)scale);
            }
            if (channels.isEmpty()) {
                return null;
            }
            animatorTag.putInt("id", animContext.globalID);
            animatorTag.put("data", (Tag)channels);
            return animatorTag;
        }
    }

    public static class Animation {
        String name;
        @Nullable
        String loop;
        @Nullable
        Boolean override;
        float length;
        @Nullable
        String anim_time_update;
        @Nullable
        String blend_weight;
        @Nullable
        String start_delay;
        @Nullable
        String loop_delay;
        @Nullable
        Map<String, Animator> animators;
    }

    public static class PointElement
    extends Element {
        FiguraVec3 position;

        @Override
        @Nullable
        public CompoundTag toNBT(BlockbenchParser2.Intermediary context) {
            CompoundTag tag = super.toNBT(context);
            if (tag == null) {
                return null;
            }
            if (this.position != null && this.origin == null && !this.position.equals((Object)ZERO)) {
                tag.put("piv", (Tag)BlockbenchCommonTypes.vecToList(this.position));
            }
            BlockbenchCommonTypes.parseParent(this.name, tag);
            return tag;
        }
    }

    public static class MeshFace {
        Map<String, FiguraVec2> uv;
        String[] vertices;
        Integer texture;
        private static final FiguraVec3 temp1 = new FiguraVec3();
        private static final FiguraVec3 temp2 = new FiguraVec3();
        private static final FiguraVec3 temp3 = new FiguraVec3();
        private static final FiguraVec3 temp4 = new FiguraVec3();

        public void reorder(Map<String, FiguraVec3> vertexIDtoPos) {
            FiguraVec3 v4;
            FiguraVec3 v3;
            if (this.vertices.length != 4) {
                return;
            }
            FiguraVec3 v1 = vertexIDtoPos.get(this.vertices[0]);
            FiguraVec3 v2 = vertexIDtoPos.get(this.vertices[1]);
            if (MeshFace.testOppositeSides(v2, v3 = vertexIDtoPos.get(this.vertices[2]), v1, v4 = vertexIDtoPos.get(this.vertices[3]))) {
                this.vertices = new String[]{this.vertices[2], this.vertices[0], this.vertices[1], this.vertices[3]};
            } else if (MeshFace.testOppositeSides(v1, v2, v3, v4)) {
                this.vertices = new String[]{this.vertices[0], this.vertices[2], this.vertices[1], this.vertices[3]};
            }
        }

        private static boolean testOppositeSides(FiguraVec3 line1, FiguraVec3 line2, FiguraVec3 point1, FiguraVec3 point2) {
            temp1.set(line1);
            temp2.set(line2);
            temp3.set(point1);
            temp4.set(point2);
            temp2.subtract(temp1);
            temp3.subtract(temp1);
            temp4.subtract(temp1);
            temp1.set(temp2);
            temp1.cross(temp3);
            temp2.cross(temp4);
            return temp1.dot(temp2) < 0.0;
        }
    }

    public static class MeshElement
    extends Element {
        Map<String, MeshFace> faces;
        Map<String, FiguraVec3> vertices;
        String shading;

        @Override
        @Nullable
        public CompoundTag toNBT(BlockbenchParser2.Intermediary context) {
            CompoundTag tag = super.toNBT(context);
            if (tag == null) {
                return null;
            }
            if (Objects.equals(this.shading, "smooth")) {
                tag.putBoolean("smo", true);
            }
            CompoundTag meshData = new CompoundTag();
            HashMap<String, Integer> vert2idx = new HashMap<String, Integer>();
            HashMap<String, FiguraVec3> vert2pos = new HashMap<String, FiguraVec3>();
            ListTag vtx = new ListTag();
            int i = 0;
            for (Map.Entry<String, FiguraVec3> entry : this.vertices.entrySet()) {
                FiguraVec3 combined = entry.getValue().copy().add(this.origin);
                vert2idx.put(entry.getKey(), i++);
                vert2pos.put(entry.getKey(), combined);
                vtx.add((Object)FloatTag.valueOf((float)((float)combined.x)));
                vtx.add((Object)FloatTag.valueOf((float)((float)combined.y)));
                vtx.add((Object)FloatTag.valueOf((float)((float)combined.z)));
            }
            ListTag tex = new ListTag();
            ListTag uvs = new ListTag();
            ListTag fac = new ListTag();
            int intType = 0;
            if (i > 255) {
                intType = 1;
            }
            if (i > 65535) {
                intType = 2;
            }
            for (Map.Entry<String, MeshFace> entry : this.faces.entrySet()) {
                Integer textureID;
                MeshFace face = entry.getValue();
                if (face.texture == null || face.vertices == null || face.uv == null || face.vertices.length < 3 || face.vertices.length > 4 || (textureID = context.getTextureGlobalID(face.texture)) == null) continue;
                short texBase = (short)((textureID << 4) + face.vertices.length);
                tex.add((Object)ShortTag.valueOf((short)texBase));
                if (face.vertices.length == 4) {
                    face.reorder(vert2pos);
                }
                for (String vertID : face.vertices) {
                    ByteTag value = switch (intType) {
                        case 0 -> ByteTag.valueOf((byte)((Integer)vert2idx.get(vertID)).byteValue());
                        case 1 -> ShortTag.valueOf((short)((Integer)vert2idx.get(vertID)).shortValue());
                        case 2 -> IntTag.valueOf((int)((Integer)vert2idx.get(vertID)));
                        default -> throw new IllegalStateException("bad int size key " + intType);
                    };
                    fac.add((Object)value);
                    FiguraVec2 uv = face.uv.get(vertID);
                    FiguraVec2 fixedSize = context.getTextureFixedSize(face.texture);
                    uvs.add((Object)FloatTag.valueOf((float)((float)(uv.x * fixedSize.x))));
                    uvs.add((Object)FloatTag.valueOf((float)((float)(uv.y * fixedSize.y))));
                }
            }
            meshData.put("vtx", (Tag)vtx);
            meshData.put("tex", (Tag)tex);
            meshData.put("fac", (Tag)fac);
            meshData.put("uvs", (Tag)uvs);
            tag.put("mesh_data", (Tag)meshData);
            return tag;
        }
    }

    public static class CubeFace
    implements NBTRepresentation<CompoundTag> {
        static final String[] FACES = new String[]{"north", "south", "west", "east", "up", "down"};
        FiguraVec4 uv;
        float rotation;
        @Nullable
        Integer texture;

        @Override
        @Nullable
        public CompoundTag toNBT(BlockbenchParser2.Intermediary context) {
            if (this.texture == null) {
                return null;
            }
            CompoundTag tag = new CompoundTag();
            Integer textureID = context.getTextureGlobalID(this.texture);
            if (textureID == null) {
                return null;
            }
            tag.putInt("tex", textureID.intValue());
            if (this.rotation != 0.0f) {
                tag.putFloat("rot", this.rotation);
            }
            if (this.uv != null && !this.uv.equals((Object)ZERO4)) {
                FiguraVec2 size = context.getTextureFixedSize(this.texture);
                FiguraVec4 sizeTwice = FiguraVec4.of((double)size.x, (double)size.y, (double)size.x, (double)size.y);
                FiguraVec4 corrected = sizeTwice.multiply(this.uv);
                tag.put("uv", (Tag)BlockbenchCommonTypes.vecToList(corrected));
            }
            return tag;
        }
    }

    public static class CubeElement
    extends Element {
        FiguraVec3 from;
        FiguraVec3 to;
        float inflate;
        Map<String, CubeFace> faces;

        @Override
        @Nullable
        public CompoundTag toNBT(BlockbenchParser2.Intermediary context) {
            CompoundTag tag = super.toNBT(context);
            if (tag == null) {
                return null;
            }
            if (this.from != null && !this.from.equals((Object)ZERO)) {
                tag.put("f", (Tag)BlockbenchCommonTypes.vecToList(this.from));
            }
            if (this.to != null && !this.to.equals((Object)ZERO)) {
                tag.put("t", (Tag)BlockbenchCommonTypes.vecToList(this.to));
            }
            if (this.inflate != 0.0f) {
                tag.putFloat("inf", this.inflate);
            }
            CompoundTag cubeData = new CompoundTag();
            for (String face : CubeFace.FACES) {
                CompoundTag faceNBT;
                CubeFace faceData = this.faces.get(face);
                if (faceData == null || (faceNBT = faceData.toNBT(context)) == null) continue;
                cubeData.put(String.valueOf(face.charAt(0)), (Tag)faceNBT);
            }
            tag.put("cube_data", (Tag)cubeData);
            return tag;
        }
    }

    public static class UnknownElement
    extends Element {
        @Override
        @Nullable
        public CompoundTag toNBT(BlockbenchParser2.Intermediary context) {
            return null;
        }
    }

    public static interface NBTRepresentation<T extends Tag> {
        public T toNBT(BlockbenchParser2.Intermediary var1);
    }

    public static interface UUIDReferable {
        public String getUUID();
    }
}

