/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common.recipe;

import fonnymunkey.simplehats.SimpleHatsCommon;
import fonnymunkey.simplehats.common.item.HatItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class HatVariantRecipe
extends CustomRecipe {
    public HatVariantRecipe(CraftingBookCategory category) {
        super(category);
    }

    public String getGroup() {
        return "simplehats:hatvariants";
    }

    public boolean matches(CraftingInput craftingInventory, Level level) {
        return HatVariantRecipe.processInventory(craftingInventory) != null;
    }

    public ItemStack assemble(CraftingInput craftingInventory, HolderLookup.Provider reg) {
        ItemStack hat = HatVariantRecipe.processInventory(craftingInventory);
        if (hat != null) {
            ItemStack hat1 = hat.copy();
            if (hat1.has(DataComponents.CUSTOM_MODEL_DATA)) {
                int modelData = ((CustomModelData)hat1.get(DataComponents.CUSTOM_MODEL_DATA)).value();
                modelData = modelData + 1 > ((HatItem)hat1.getItem()).getHatEntry().getHatVariantRange() ? 0 : ++modelData;
                hat1.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(modelData));
            } else {
                hat1.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(1));
            }
            return hat1;
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack processInventory(CraftingInput craftingInventory) {
        int totalItems = 0;
        ItemStack hatItem = null;
        for (int i = 0; i < craftingInventory.size(); ++i) {
            HatItem hat;
            ItemStack slot = craftingInventory.getItem(i);
            if (slot.isEmpty()) continue;
            ++totalItems;
            Item item = slot.getItem();
            if (!(item instanceof HatItem) || (hat = (HatItem)item).getHatEntry().getHatVariantRange() <= 0) continue;
            hatItem = slot;
        }
        return totalItems == 1 && hatItem != null ? hatItem : null;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 1;
    }

    public RecipeSerializer<?> getSerializer() {
        return SimpleHatsCommon.MOD_REGISTRY.getHatVariantSerializer();
    }
}

