/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mushroomquest.entity;

import java.util.function.Predicate;
import net.mcreator.mushroomquest.init.MushroomquestModEntities;
import net.mcreator.mushroomquest.procedures.NBTWanderProcedure;
import net.mcreator.mushroomquest.procedures.RedAmanitaFunglingRightClickedOnEntityProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class BrownAmanitaFunglingEntity
extends PathfinderMob {
    public BrownAmanitaFunglingEntity(EntityType<BrownAmanitaFunglingEntity> type, Level world) {
        super(type, world);
        this.xpReward = 1;
        this.setNoAi(false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new TemptGoal(this, 1.5, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DEAD_BUSH.asItem()}), false){

            public boolean canUse() {
                double x = BrownAmanitaFunglingEntity.this.getX();
                double y = BrownAmanitaFunglingEntity.this.getY();
                double z = BrownAmanitaFunglingEntity.this.getZ();
                BrownAmanitaFunglingEntity entity = BrownAmanitaFunglingEntity.this;
                Level world = BrownAmanitaFunglingEntity.this.level();
                return super.canUse() && NBTWanderProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = BrownAmanitaFunglingEntity.this.getX();
                double y = BrownAmanitaFunglingEntity.this.getY();
                double z = BrownAmanitaFunglingEntity.this.getZ();
                BrownAmanitaFunglingEntity entity = BrownAmanitaFunglingEntity.this;
                Level world = BrownAmanitaFunglingEntity.this.level();
                return super.canContinueToUse() && NBTWanderProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal(this, 1.0){

            public boolean canUse() {
                double x = BrownAmanitaFunglingEntity.this.getX();
                double y = BrownAmanitaFunglingEntity.this.getY();
                double z = BrownAmanitaFunglingEntity.this.getZ();
                BrownAmanitaFunglingEntity entity = BrownAmanitaFunglingEntity.this;
                Level world = BrownAmanitaFunglingEntity.this.level();
                return super.canUse() && NBTWanderProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = BrownAmanitaFunglingEntity.this.getX();
                double y = BrownAmanitaFunglingEntity.this.getY();
                double z = BrownAmanitaFunglingEntity.this.getZ();
                BrownAmanitaFunglingEntity entity = BrownAmanitaFunglingEntity.this;
                Level world = BrownAmanitaFunglingEntity.this.level();
                return super.canContinueToUse() && NBTWanderProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.rabbit.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.rabbit.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.rabbit.death"));
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        BrownAmanitaFunglingEntity entity = this;
        Level world = this.level();
        RedAmanitaFunglingRightClickedOnEntityProcedure.execute((LevelAccessor)world, x, y, z, (Entity)sourceentity);
        return retval;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)MushroomquestModEntities.BROWN_AMANITA_FUNGLING.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

