/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.SkinHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeSkinMessage(UUID uuid, SkinDataEntry skinDataEntry) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_skin");
    public static final CustomPacketPayload.Type<ChangeSkinMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeSkinMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeSkinMessage::create);

    public static ChangeSkinMessage create(FriendlyByteBuf buffer) {
        return new ChangeSkinMessage(buffer.readUUID(), new SkinDataEntry(buffer.readNbt()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeNbt((Tag)this.skinDataEntry.createTag());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null || this.skinDataEntry == null || easyNPC.getEasyNPCSkinData() == null) {
            log.error("Skin validation failed for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (!SkinHandler.setSkin((EasyNPC)easyNPC, (SkinDataEntry)this.skinDataEntry)) {
            log.error("Failed changing skin data entry:{} for {} from {}", (Object)this.skinDataEntry, (Object)easyNPC, (Object)serverPlayer);
        }
    }
}

