/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelAnimationData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelAnimationDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeModelAnimationDataMessage(UUID uuid, ModelAnimationData animationData) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_model_animation_data");
    public static final CustomPacketPayload.Type<ChangeModelAnimationDataMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeModelAnimationDataMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeModelAnimationDataMessage::create);

    public static ChangeModelAnimationDataMessage create(FriendlyByteBuf buffer) {
        return new ChangeModelAnimationDataMessage(buffer.readUUID(), ModelAnimationData.decode((FriendlyByteBuf)buffer));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        this.animationData.encode(buffer);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (!(easyNPC instanceof ModelAnimationDataCapable)) {
            log.error("Invalid model animation data capable for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        ModelAnimationDataCapable capable = (ModelAnimationDataCapable)easyNPC;
        log.debug("Change animation data {} for {} from {}", (Object)this.animationData, (Object)easyNPC, (Object)serverPlayer);
        capable.setModelAnimationData(this.animationData);
    }
}

