/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.menu.editor;

import de.markusbordihn.easynpc.configui.data.editor.EditorType;
import de.markusbordihn.easynpc.configui.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class EditorMenuHandler {
    private EditorMenuHandler() {
    }

    public static MenuProvider getMenuProvider(final EditorType editorType, final EasyNPC<?> easyNPC, final MenuType<? extends EditorMenu> menuType, final ScreenData screenData) {
        final Component displayName = EditorMenuHandler.getEditorTitle(editorType, easyNPC);
        return new MenuProvider(){

            public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
                return new EditorMenu(menuType, containerId, playerInventory, screenData.encode());
            }

            public Component getDisplayName() {
                return displayName;
            }

            public String toString() {
                return "EditorMenuHandler{editorType=" + String.valueOf((Object)editorType) + ", easyNPC=" + String.valueOf(easyNPC) + ", screenData=" + String.valueOf(screenData) + "}";
            }
        };
    }

    public static ScreenData getScreenData(EditorType editorType, EasyNPC<? extends LivingEntity> easyNPC, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, UUID conditionDataEntryId, int pageIndex, CompoundTag additionalSyncData) {
        UUID npcUUID = easyNPC.getEntityUUID();
        switch (editorType) {
            case DIALOG: 
            case DIALOG_BUTTON: 
            case DIALOG_TEXT: {
                AdditionalScreenData.addDialogDataSet(additionalSyncData, easyNPC);
                break;
            }
            case ACTION_DATA: 
            case ACTION_DATA_ENTRY: {
                AdditionalScreenData.addActionEventSet(additionalSyncData, easyNPC);
                AdditionalScreenData.addDialogDataSet(additionalSyncData, easyNPC);
                break;
            }
            case CONDITION_DATA: 
            case CONDITION_DATA_ENTRY: {
                AdditionalScreenData.addDialogDataSet(additionalSyncData, easyNPC);
                break;
            }
        }
        return new ScreenData(npcUUID, dialogId, dialogButtonId, actionDataEntryId, conditionDataEntryId, pageIndex, additionalSyncData);
    }

    private static Component getEditorTitle(EditorType editorType, EasyNPC<?> easyNPC) {
        return TextComponent.getTranslatedConfigText((String)(editorType.name().toLowerCase(Locale.ROOT) + ".title"), (String)easyNPC.getEntity().getName().getString(20));
    }
}

