/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.dialog;

import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.EditorScreen;
import de.markusbordihn.easynpc.configui.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogTextData;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class DialogTextEditorScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private static final int MAX_NUMBER_OF_DIALOG_TEXTS = 6;
    private final Set<TextField> dialogTextFields = new HashSet<TextField>();
    protected Button homeButton;
    protected Button dialogButton;
    protected Button dialogTextButton;
    protected Button saveButton;
    protected Button cancelButton;

    public DialogTextEditorScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    protected void saveDialogData() {
        HashSet<DialogTextData> validDialogTexts = new HashSet<DialogTextData>();
        for (TextField textfield : this.dialogTextFields) {
            String text = textfield.getValue();
            if (text.isEmpty()) continue;
            validDialogTexts.add(new DialogTextData(text));
        }
        DialogDataEntry dialogDataEntry = this.getDialogData(this.getDialogUUID());
        dialogDataEntry.setDialogTexts(validDialogTexts);
        NetworkMessageHandlerManager.getServerHandler().saveDialog(this.getEasyNPCUUID(), this.getDialogUUID(), dialogDataEntry);
    }

    public void init() {
        super.init();
        this.homeButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.leftPos + 7, this.topPos + 7, 10, 16, "<", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG)));
        this.dialogButton = (Button)this.addRenderableWidget((GuiEventListener)new DialogButton(this.homeButton.getX() + this.homeButton.getWidth(), this.topPos + 7, 140, this.getDialogData().getName(21), onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID())));
        this.dialogTextButton = (Button)this.addRenderableWidget((GuiEventListener)new DialogButton(this.dialogButton.getX() + this.dialogButton.getWidth(), this.topPos + 7, 140, "Dialog Text", onPress -> {}));
        this.dialogTextButton.active = false;
        int dialogTextIndex = 0;
        int dialogTextLeftPos = this.leftPos + 20;
        int dialogTextTopPos = this.topPos + 50;
        int dialogTextWidth = 290;
        Set dialogTexts = this.getDialogData(this.getDialogUUID()).getDialogTexts();
        for (DialogTextData dialogText : dialogTexts) {
            if (dialogTextIndex >= 6) break;
            TextField textfield = (TextField)this.addRenderableWidget((GuiEventListener)new TextField(this.font, dialogTextLeftPos, dialogTextTopPos + dialogTextIndex * 20, dialogTextWidth, dialogText.text(), 512));
            this.dialogTextFields.add(textfield);
            ++dialogTextIndex;
        }
        for (int i = dialogTextIndex; i < 6; ++i) {
            TextField textfield = (TextField)this.addRenderableWidget((GuiEventListener)new TextField(this.font, dialogTextLeftPos, dialogTextTopPos + i * 20, dialogTextWidth, "", 512));
            this.dialogTextFields.add(textfield);
        }
        this.saveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.leftPos + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.saveDialogData();
            NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID());
        }));
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)new CancelButton(this.saveButton.getX() + 95 + this.saveButton.getWidth() + 10, this.bottomPos - 35, 85, "cancel", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG)));
    }

    protected void renderEditLabels(GuiGraphics guiGraphics) {
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"dialog.text", (int)(this.leftPos + 10), (int)(this.topPos + 34), (int)0);
        for (int i = 1; i <= 6; ++i) {
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)(i + ":"), (int)(this.leftPos + 10), (int)(this.topPos + 35 + i * 20), (int)0);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        this.renderEditLabels(guiGraphics);
    }
}

