/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.dialog;

import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.SpriteButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextEditButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.EditorScreen;
import de.markusbordihn.easynpc.configui.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.configui.client.screen.components.DialogButtonButton;
import de.markusbordihn.easynpc.configui.client.screen.components.DialogPriorityButton;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class DialogEditorScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private static final int MAX_NUMBER_OF_BUTTONS = 6;
    protected Button homeButton;
    protected Button dialogButton;
    protected Button conditionsButton;
    protected Button dialogTextButton;
    protected Button addDialogButton;
    protected Button saveButton;
    protected Button cancelButton;
    protected Button deleteButton;
    protected TextField dialogLabelTextField;
    protected Checkbox dialogLabelCheckbox;
    protected Button dialogNameToLabelButton;
    protected DialogPriorityButton dialogPriorityButton;
    protected TextField dialogPriorityTextField;
    protected TextField dialogNameTextField;
    private String dialogLabelValue = "";
    private String dialogNameValue = "";
    private int dialogPriorityValue = 0;

    public DialogEditorScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void openPreviousScreen() {
        NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG);
    }

    private void deleteDialog() {
        Minecraft minecraft = this.minecraft;
        if (minecraft == null) {
            return;
        }
        minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.getEasyNPCUUID() != null) {
                NetworkMessageHandlerManager.getServerHandler().removeDialog(this.getEasyNPCUUID(), this.getDialogUUID());
                NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG);
            } else {
                minecraft.setScreen((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedConfigText((String)"removeDialog.deleteQuestion"), (Component)TextComponent.getTranslatedConfigText((String)"removeDialog.deleteWarning", (String)this.getDialogData().getName()), (Component)TextComponent.getTranslatedConfigText((String)"removeDialog.deleteButton"), CommonComponents.GUI_CANCEL));
    }

    private void renderEditLabels(GuiGraphics guiGraphics) {
        if (this.dialogNameTextField != null) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"dialog.name", (int)(this.leftPos + 10), (int)(this.dialogNameTextField.getY() + 4), (int)0);
        }
        if (this.dialogLabelTextField != null) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"label_id", (int)(this.leftPos + 10), (int)(this.dialogLabelTextField.getY() + 4), (int)0);
        }
        if (this.dialogPriorityButton != null) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"dialog.priority", (int)(this.leftPos + 10), (int)(this.dialogPriorityButton.getY() + 4), (int)0);
        }
        if (this.conditionsButton != null) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"dialog.conditions", (int)(this.leftPos + 10), (int)(this.conditionsButton.getY() + 4), (int)0);
        }
        if (this.dialogTextButton != null) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"dialog.text", (int)(this.leftPos + 10), (int)(this.dialogTextButton.getY() - 12), (int)0);
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"dialog.buttons", (int)(this.leftPos + 10), (int)(this.dialogTextButton.getY() + 25), (int)0);
        }
    }

    private void saveDialogData() {
        boolean hasChanged;
        int currentPriority = this.dialogPriorityButton.getPriority();
        if (this.dialogPriorityButton.isCustom() && this.dialogPriorityTextField != null) {
            try {
                currentPriority = Integer.parseInt(this.dialogPriorityTextField.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean bl = hasChanged = !this.dialogNameTextField.getValue().equals(this.dialogNameValue) || !this.dialogLabelTextField.getValue().equals(this.dialogLabelValue) || currentPriority != this.dialogPriorityValue;
        if (!hasChanged) {
            return;
        }
        DialogDataEntry dialogDataEntry = this.getDialogData();
        dialogDataEntry.setName(this.dialogNameTextField.getValue());
        dialogDataEntry.setLabel(this.dialogLabelTextField.getValue());
        dialogDataEntry.setPriority(currentPriority);
        NetworkMessageHandlerManager.getServerHandler().saveDialog(this.getEasyNPCUUID(), this.getDialogUUID(), dialogDataEntry);
    }

    public void init() {
        super.init();
        this.homeButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.leftPos + 7, this.topPos + 7, 10, 16, "<", onPress -> this.openPreviousScreen()));
        DialogDataEntry dialogDataEntry = this.getDialogData();
        this.dialogButton = (Button)this.addRenderableWidget((GuiEventListener)new DialogButton(this.homeButton.getX() + this.homeButton.getWidth(), this.topPos + 7, 140, dialogDataEntry.getName(21), onPress -> {}));
        this.dialogButton.active = false;
        this.dialogNameValue = this.getDialogData().getName();
        this.dialogNameTextField = new TextField(this.font, this.leftPos + 100, this.topPos + 28, 150, this.dialogNameValue);
        this.dialogNameTextField.setMaxLength(64);
        this.addRenderableWidget((GuiEventListener)this.dialogNameTextField);
        this.dialogNameToLabelButton = (Button)this.addRenderableWidget((GuiEventListener)new SpriteButton(this.dialogNameTextField.getX() + this.dialogNameTextField.getWidth() + 1, this.dialogNameTextField.getY() - 1, 18, 18, 4, 4, 80, 80, 12, 12, onPress -> {
            if (this.dialogNameTextField != null && this.dialogLabelTextField != null) {
                String buttonName = this.dialogNameTextField.getValue();
                this.dialogLabelTextField.setValue(DialogUtils.generateButtonLabel((String)buttonName));
            }
        }));
        this.dialogLabelValue = dialogDataEntry.getLabel();
        this.dialogLabelTextField = new TextField(this.font, this.leftPos + 100, this.topPos + 48, 100);
        this.dialogLabelTextField.setMaxLength(32);
        this.dialogLabelTextField.setValue(this.dialogLabelValue);
        this.dialogLabelTextField.setEditable(this.dialogLabelTextField.getValue().isEmpty());
        this.addRenderableWidget((GuiEventListener)this.dialogLabelTextField);
        this.dialogLabelCheckbox = new Checkbox(this.leftPos + 203, this.dialogLabelTextField.getY() + 1, "locked", !dialogDataEntry.getLabel().isEmpty(), checkbox -> this.dialogLabelTextField.setEditable(!checkbox.selected()));
        this.addRenderableWidget((GuiEventListener)this.dialogLabelCheckbox);
        this.conditionsButton = (Button)this.addRenderableWidget((GuiEventListener)new DialogButton(this.leftPos + 99, this.topPos + 67, 140, dialogDataEntry.hasConditions() ? "dialog.edit_conditions" : "dialog.create_conditions", onPress -> {
            this.saveDialogData();
            NetworkMessageHandlerManager.getServerHandler().openConditionDataEditor(this.getEasyNPCUUID(), this.getDialogUUID());
        }));
        this.dialogPriorityValue = dialogDataEntry.getPriority();
        this.dialogPriorityButton = (DialogPriorityButton)this.addRenderableWidget((GuiEventListener)new DialogPriorityButton(this.leftPos + 99, this.topPos + 86, 110, 16, this.dialogPriorityValue, button -> {
            if (this.dialogPriorityTextField != null) {
                this.dialogPriorityTextField.setVisible(this.dialogPriorityButton.isCustom());
                if (this.dialogPriorityButton.isCustom() && this.dialogPriorityTextField.getValue().isEmpty()) {
                    this.dialogPriorityTextField.setValue(String.valueOf(this.dialogPriorityValue));
                }
            }
        }));
        this.dialogPriorityTextField = new TextField(this.font, this.dialogPriorityButton.getX() + this.dialogPriorityButton.getWidth() + 2, this.dialogPriorityButton.getY(), 30, this.dialogPriorityButton.isCustom() ? String.valueOf(this.dialogPriorityValue) : "", 3);
        this.dialogPriorityTextField.setVisible(this.dialogPriorityButton.isCustom());
        this.addRenderableWidget((GuiEventListener)this.dialogPriorityTextField);
        this.dialogTextButton = (Button)this.addRenderableWidget((GuiEventListener)new TextEditButton(this.leftPos + 7, this.topPos + 122, 315, "dialog.edit_text", onPress -> {
            this.saveDialogData();
            NetworkMessageHandlerManager.getServerHandler().openDialogTextEditor(this.getEasyNPCUUID(), this.getDialogUUID());
        }));
        this.defineDialogButtons(dialogDataEntry);
        this.saveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.leftPos + 8, this.bottomPos - 30, 130, "save", onPress -> {
            this.saveDialogData();
            this.openPreviousScreen();
        }));
        this.deleteButton = (Button)this.addRenderableWidget((GuiEventListener)new DeleteButton(this.saveButton.getX() + this.saveButton.getWidth() + 10, this.bottomPos - 30, 85, onPress -> this.deleteDialog()));
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)new CancelButton(this.deleteButton.getX() + this.deleteButton.getWidth() + 5, this.bottomPos - 30, 85, "cancel", onPress -> this.openPreviousScreen()));
    }

    private void defineDialogButtons(DialogDataEntry dialogDataEntry) {
        Set dialogButtons = dialogDataEntry.getDialogButtons();
        boolean smallButtons = dialogButtons.size() < 4;
        int buttonIndex = 0;
        int buttonBaseLeftPos = this.leftPos + 7;
        int buttonTopPos = this.topPos + 157;
        int buttonLeftPos = buttonBaseLeftPos;
        int buttonSpace = 3;
        int buttonWidth = smallButtons ? 156 : 103;
        int buttonMaxTextLength = smallButtons ? 22 : 14;
        for (DialogButtonEntry dialogButtonEntry : dialogButtons) {
            if (buttonIndex > 5) break;
            if (smallButtons && buttonIndex == 2 || !smallButtons && buttonIndex == 3) {
                buttonTopPos += 18;
                buttonLeftPos = buttonBaseLeftPos;
            }
            DialogButtonButton dialogActionButton = new DialogButtonButton(buttonLeftPos, buttonTopPos, buttonWidth, dialogButtonEntry.getButtonName(buttonMaxTextLength).getString(), onPress -> {
                log.info("Edit dialog button {}", (Object)dialogButtonEntry.id());
                NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID(), dialogButtonEntry.id());
            });
            this.addRenderableWidget((GuiEventListener)dialogActionButton);
            buttonLeftPos += buttonWidth + buttonSpace;
            ++buttonIndex;
        }
        if (buttonIndex < 6) {
            this.addDialogButton = new AddButton(dialogButtons.size() < 5 && buttonIndex != 2 ? buttonLeftPos : buttonBaseLeftPos, dialogButtons.size() < 5 && buttonIndex != 2 ? buttonTopPos : buttonTopPos + 18, smallButtons ? buttonWidth : 208, "dialog.add_button", onPress -> {
                this.saveDialogData();
                NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), this.getDialogUUID());
            });
            this.addRenderableWidget((GuiEventListener)this.addDialogButton);
        }
    }

    public void updateTick() {
        super.updateTick();
        if (this.saveButton != null) {
            int currentPriority = this.dialogPriorityButton.getPriority();
            if (this.dialogPriorityButton.isCustom() && this.dialogPriorityTextField != null) {
                try {
                    currentPriority = Integer.parseInt(this.dialogPriorityTextField.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            boolean bl = this.saveButton.active = !this.dialogNameTextField.getValue().equals(this.dialogNameValue) || !this.dialogLabelTextField.getValue().equals(this.dialogLabelValue) || currentPriority != this.dialogPriorityValue;
        }
        if (this.dialogLabelCheckbox != null && this.dialogNameToLabelButton != null) {
            this.dialogNameToLabelButton.active = !this.dialogLabelCheckbox.selected();
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        this.renderEditLabels(guiGraphics);
        if (this.dialogNameToLabelButton != null && this.dialogNameToLabelButton.isMouseOver((double)x, (double)y)) {
            guiGraphics.renderTooltip(this.font, (Component)TextComponent.getTranslatedConfigText((String)"name_to_label.tooltip"), x, y);
        }
    }
}

