/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.dialog;

import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.EditButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.SpriteButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.EditorScreen;
import de.markusbordihn.easynpc.configui.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.configui.client.screen.components.DialogButtonButton;
import de.markusbordihn.easynpc.configui.data.editor.EditorType;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;

public class DialogButtonEditorScreen<T extends EditorMenu>
extends EditorScreen<T> {
    protected Button homeButton;
    protected Button dialogButton;
    protected Button dialogButtonButton;
    protected Button saveButton;
    protected Button cancelButton;
    protected Button deleteButton;
    protected TextField buttonNameBox;
    protected Button buttonNameToLabelButton;
    protected TextField buttonLabelBox;
    protected Checkbox buttonLabelCheckbox;
    private String buttonLabelValue = "";
    private String buttonNameValue = "";

    public DialogButtonEditorScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void deleteDialogButton() {
        if (this.minecraft == null) {
            return;
        }
        this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.getDialogUUID() != null) {
                NetworkMessageHandlerManager.getServerHandler().removeDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID());
                NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID());
            } else {
                this.minecraft.setScreen((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedConfigText((String)"removeDialogButton.deleteQuestion"), (Component)TextComponent.getTranslatedConfigText((String)"removeDialogButton.deleteWarning", (String)this.getDialogButtonData().name()), (Component)TextComponent.getTranslatedConfigText((String)"removeDialogButton.deleteButton"), CommonComponents.GUI_CANCEL));
    }

    protected void renderEditLabels(GuiGraphics guiGraphics) {
        if (this.buttonNameBox != null) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"button.name", (int)(this.leftPos + 12), (int)(this.buttonNameBox.getY() + 4));
        }
        if (this.buttonLabelBox != null) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"label_id", (int)(this.leftPos + 12), (int)(this.buttonLabelBox.getY() + 4));
        }
    }

    public void init() {
        super.init();
        this.homeButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.leftPos + 7, this.topPos + 7, 10, 16, "<", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DIALOG)));
        this.dialogButton = (Button)this.addRenderableWidget((GuiEventListener)new DialogButton(this.homeButton.getX() + this.homeButton.getWidth(), this.topPos + 7, 140, this.getDialogData().getName(21), onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID())));
        this.dialogButtonButton = (Button)this.addRenderableWidget((GuiEventListener)new DialogButtonButton(this.dialogButton.getX() + this.dialogButton.getWidth(), this.topPos + 7, 140, this.getDialogButtonData().getButtonName(21).getString(), onPress -> {}));
        this.dialogButtonButton.active = false;
        this.buttonNameValue = this.getDialogButtonData().name();
        this.buttonNameBox = new TextField(this.font, this.leftPos + 100, this.topPos + 30, 150);
        this.buttonNameBox.setMaxLength(64);
        this.buttonNameBox.setValue(this.buttonNameValue);
        this.addRenderableWidget((GuiEventListener)this.buttonNameBox);
        this.buttonNameToLabelButton = (Button)this.addRenderableWidget((GuiEventListener)new SpriteButton(this.buttonNameBox.getX() + this.buttonNameBox.getWidth() + 1, this.buttonNameBox.getY() - 1, 18, 18, 4, 4, 80, 80, 12, 12, onPress -> {
            if (this.buttonNameBox != null && this.buttonLabelBox != null) {
                String buttonName = this.buttonNameBox.getValue();
                this.buttonLabelBox.setValue(DialogUtils.generateButtonLabel((String)buttonName));
            }
        }));
        this.buttonLabelValue = this.getDialogButtonData().label();
        this.buttonLabelBox = new TextField(this.font, this.leftPos + 100, this.topPos + 50, 100);
        this.buttonLabelBox.setMaxLength(32);
        this.buttonLabelBox.setValue(this.buttonLabelValue);
        this.buttonLabelBox.setEditable(false);
        this.addRenderableWidget((GuiEventListener)this.buttonLabelBox);
        this.buttonLabelCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)new Checkbox(this.leftPos + 204, this.buttonLabelBox.getY() + 1, "locked", true, onPress -> this.buttonLabelBox.setEditable(!this.buttonLabelCheckbox.selected())));
        this.addRenderableWidget((GuiEventListener)this.getActionDataButton(this.leftPos + 10, this.topPos + 70));
        this.saveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.leftPos + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.saveDialogButton();
            NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID());
        }));
        this.deleteButton = (Button)this.addRenderableWidget((GuiEventListener)new DeleteButton(this.saveButton.getX() + this.saveButton.getWidth() + 10, this.bottomPos - 35, 85, onPress -> this.deleteDialogButton()));
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)new CancelButton(this.deleteButton.getX() + this.deleteButton.getWidth() + 10, this.bottomPos - 35, 85, "cancel", onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID())));
    }

    private void saveDialogButton() {
        DialogButtonEntry dialogButtonEntry = this.getDialogButtonData();
        if (dialogButtonEntry == null) {
            return;
        }
        DialogButtonEntry newDialogButtonEntry = dialogButtonEntry.withName(this.buttonNameBox.getValue()).withLabel(this.buttonLabelBox.getValue());
        NetworkMessageHandlerManager.getServerHandler().saveDialogButton(this.getEasyNPCUUID(), this.getDialogUUID(), this.getDialogButtonUUID(), newDialogButtonEntry);
    }

    public void updateTick() {
        super.updateTick();
        if (this.saveButton != null) {
            boolean bl = this.saveButton.active = !this.buttonNameBox.getValue().equals(this.buttonNameValue) || !this.buttonLabelBox.getValue().equals(this.buttonLabelValue);
        }
        if (this.buttonLabelCheckbox != null && this.buttonNameToLabelButton != null) {
            this.buttonNameToLabelButton.active = !this.buttonLabelCheckbox.selected();
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        this.renderEditLabels(guiGraphics);
        if (this.buttonNameToLabelButton != null && this.buttonNameToLabelButton.isMouseOver((double)x, (double)y)) {
            guiGraphics.renderTooltip(this.font, (Component)TextComponent.getTranslatedConfigText((String)"name_to_label.tooltip"), x, y);
        }
    }

    protected Button getActionDataButton(int left, int top) {
        int buttonWidth = 300;
        ActionDataSet actionDataSet = this.getDialogButtonData().actionDataSet();
        if (actionDataSet == null || actionDataSet.isEmpty()) {
            MutableComponent buttonLabel = TextComponent.getTextComponent((String)"add_action", (String)"button");
            return new AddButton(left, top, buttonWidth, (Component)buttonLabel, onPress -> NetworkMessageHandlerManager.getServerHandler().openActionDataEntryEditor(this.getEasyNPCUUID(), EditorType.DIALOG_BUTTON, this.getDialogUUID(), this.getDialogButtonUUID(), new ActionDataEntry())).setRenderCenter(false);
        }
        MutableComponent buttonLabel = TextComponent.getTextComponent((String)"edit_action", (String)"button");
        return new EditButton(left, top, buttonWidth, (Component)buttonLabel, onPress -> NetworkMessageHandlerManager.getServerHandler().openActionDataEditor(this.getEasyNPCUUID(), EditorType.DIALOG_BUTTON, this.getDialogUUID(), this.getDialogButtonUUID())).setRenderCenter(false);
    }
}

