/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.condition;

import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.SpinButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.client.screen.EditorScreen;
import de.markusbordihn.easynpc.configui.client.screen.components.DialogButton;
import de.markusbordihn.easynpc.configui.client.screen.editor.condition.entry.ConditionEntryWidget;
import de.markusbordihn.easynpc.configui.client.screen.editor.condition.entry.ExecutionLimitConditionEntry;
import de.markusbordihn.easynpc.configui.client.screen.editor.condition.entry.ScoreboardConditionEntry;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.data.condition.ConditionDataSet;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ConditionDataEntryEditorContainerScreen<T extends EditorMenu>
extends EditorScreen<T> {
    private final ConditionDataEntry conditionDataEntry;
    private final ConditionDataSet conditionDataSet = this.getConditionDataSet();
    private final UUID conditionDataEntryId = this.getConditionDataEntryUUID();
    protected Button homeButton;
    protected Button dialogButton;
    protected Button conditionsButton;
    protected Button saveButton;
    protected Button cancelButton;
    protected Button deleteButton;
    protected Button conditionTypeButton;
    protected int contentTop;
    private ConditionEntryWidget conditionEntryWidget;
    private ConditionType conditionType;

    public ConditionDataEntryEditorContainerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.conditionDataEntry = this.getConditionDataEntry();
        this.conditionType = this.conditionDataEntry.conditionType() != ConditionType.NONE ? this.conditionDataEntry.conditionType() : ConditionType.SCOREBOARD;
    }

    private ConditionDataSet getConditionDataSet() {
        DialogDataEntry dialogData = this.getDialogData();
        if (dialogData != null && dialogData.getConditions() != null) {
            return new ConditionDataSet(dialogData.getConditions());
        }
        log.error("No valid condition data set found!");
        return new ConditionDataSet();
    }

    private ConditionDataEntry getConditionDataEntry() {
        if (this.conditionDataSet != null && this.conditionDataEntryId != null && this.conditionDataSet.hasCondition(this.conditionDataEntryId)) {
            return this.conditionDataSet.getCondition(this.conditionDataEntryId);
        }
        return new ConditionDataEntry(ConditionType.SCOREBOARD);
    }

    private void navigateToConditionDataEditor() {
        NetworkMessageHandlerManager.getServerHandler().openConditionDataEditor(this.getEasyNPCUUID(), this.getDialogUUID());
    }

    protected void changeConditionType(SpinButton<?> spinButton) {
        log.info("Change condition type to {}", spinButton.get());
        this.conditionType = (ConditionType)spinButton.get();
        this.clearWidgets();
        this.init();
    }

    private void saveConditionDataEntry() {
        if (this.conditionDataSet == null) {
            return;
        }
        ConditionDataEntry newConditionDataEntry = this.conditionEntryWidget != null ? this.conditionEntryWidget.getConditionDataEntry() : new ConditionDataEntry(this.conditionType);
        this.conditionDataSet.put(this.conditionDataEntryId, newConditionDataEntry);
        DialogDataEntry dialogData = this.getDialogData();
        dialogData.setConditions(this.conditionDataSet.getConditions());
        NetworkMessageHandlerManager.getServerHandler().saveDialog(this.getEasyNPCUUID(), this.getDialogUUID(), dialogData);
    }

    private void deleteConditionDataEntry() {
        if (this.minecraft == null || this.conditionDataSet == null || this.conditionDataEntryId == null || this.conditionDataEntryId == Constants.EMPTY_UUID) {
            return;
        }
        this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                this.conditionDataSet.remove(this.conditionDataEntryId);
                DialogDataEntry dialogData = this.getDialogData();
                dialogData.setConditions(this.conditionDataSet.getConditions());
                NetworkMessageHandlerManager.getServerHandler().saveDialog(this.getEasyNPCUUID(), this.getDialogUUID(), dialogData);
                this.navigateToConditionDataEditor();
            } else {
                this.minecraft.setScreen((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedConfigText((String)"removeConditionDataEntry.deleteQuestion"), (Component)TextComponent.getTranslatedConfigText((String)"removeConditionDataEntry.deleteWarning", (String)"SCOREBOARD"), (Component)TextComponent.getTranslatedConfigText((String)"removeConditionDataEntry.deleteButton"), CommonComponents.GUI_CANCEL));
    }

    public void init() {
        super.init();
        this.contentTop = this.topPos + 20;
        this.homeButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.leftPos + 7, this.topPos + 7, 10, 16, "<", onPress -> this.navigateToConditionDataEditor()));
        this.dialogButton = (Button)this.addRenderableWidget((GuiEventListener)new DialogButton(this.homeButton.getX() + this.homeButton.getWidth(), this.topPos + 7, 140, this.getDialogData().getName(21), onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID(), this.getDialogUUID())));
        this.conditionsButton = (Button)this.addRenderableWidget((GuiEventListener)new DialogButton(this.dialogButton.getX() + this.dialogButton.getWidth(), this.topPos + 7, 140, "Conditions", onPress -> this.navigateToConditionDataEditor()));
        this.conditionTypeButton = (Button)this.addRenderableWidget((GuiEventListener)new SpinButton(this.leftPos + 133, this.contentTop + 5, 160, 16, (Set)Arrays.stream(ConditionType.values()).filter(type -> type != ConditionType.NONE).sorted().collect(Collectors.toCollection(LinkedHashSet::new)), (Object)this.conditionType, this::changeConditionType));
        this.saveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.leftPos + 25, this.bottomPos - 35, 85, "save", onPress -> {
            this.saveConditionDataEntry();
            this.navigateToConditionDataEditor();
        }));
        this.deleteButton = (Button)this.addRenderableWidget((GuiEventListener)new DeleteButton(this.saveButton.getX() + this.saveButton.getWidth() + 10, this.bottomPos - 35, 85, onPress -> this.deleteConditionDataEntry()));
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)new CancelButton(this.deleteButton.getX() + this.deleteButton.getWidth() + 10, this.bottomPos - 35, 85, "cancel", onPress -> this.navigateToConditionDataEditor()));
        switch (this.conditionType) {
            case SCOREBOARD: {
                this.conditionEntryWidget = new ScoreboardConditionEntry(this.conditionDataEntry, this.conditionDataSet, this);
                break;
            }
            case EXECUTION_LIMIT: {
                this.conditionEntryWidget = new ExecutionLimitConditionEntry(this.conditionDataEntry, this.conditionDataSet, this);
                break;
            }
            default: {
                this.conditionEntryWidget = null;
                log.error("Unsupported condition type {}!", (Object)this.conditionType);
            }
        }
        if (this.conditionEntryWidget != null) {
            this.conditionEntryWidget.init(this.leftPos + 10, this.contentTop + 50);
        }
    }

    public <W extends GuiEventListener & Renderable> W addConditionEntryWidget(W widget) {
        return (W)this.addRenderableWidget(widget);
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"condition.type", (int)(this.leftPos + 10), (int)(this.topPos + 30), (int)0);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"condition.help_text", (int)(this.leftPos + 10), (int)(this.topPos + 50), (int)0xAAAAAA);
        if (this.conditionEntryWidget != null) {
            this.conditionEntryWidget.render(guiGraphics, this.leftPos + 10, this.contentTop + 50);
        }
    }
}

