/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.trading;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.configui.client.screen.configuration.trading.TradingConfigurationContainerScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class NoneTradingConfigurationContainerScreen<T extends ConfigurationMenu>
extends TradingConfigurationContainerScreen<T> {
    private static TradingType formerTradingType = TradingType.BASIC;
    protected Checkbox noneTradingCheckbox;
    protected int numberOfTextLines = 1;
    private List<FormattedCharSequence> textComponents = Collections.emptyList();

    public NoneTradingConfigurationContainerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    public static void setFormerTradingType(TradingType dialogType) {
        formerTradingType = dialogType;
    }

    @Override
    public void init() {
        super.init();
        this.noneTradesButton.active = false;
        TradingDataCapable tradingData = this.getEasyNPC().getEasyNPCTradingData();
        TradingDataSet tradingDataSet = tradingData.getTradingDataSet();
        NoneTradingConfigurationContainerScreen.setFormerTradingType(tradingDataSet.getType());
        this.noneTradingCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)new Checkbox(this.contentLeftPos + 100, this.topPos + 170, "disable_trading_checkbox", tradingDataSet.isType(TradingType.NONE), checkbox -> {
            if (checkbox.selected()) {
                NetworkMessageHandlerManager.getServerHandler().changeTradingType(this.getEasyNPCUUID(), TradingType.NONE);
            } else {
                NetworkMessageHandlerManager.getServerHandler().changeTradingType(this.getEasyNPCUUID(), formerTradingType != null && formerTradingType != TradingType.NONE ? formerTradingType : TradingType.BASIC);
            }
        }));
        this.textComponents = this.font.split((FormattedText)TextComponent.getTranslatedConfigText((String)"disable_trading_text"), this.imageWidth - 20);
        this.numberOfTextLines = this.textComponents.size();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        if (!this.textComponents.isEmpty()) {
            for (int line = 0; line < this.numberOfTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.textComponents.get(line);
                Objects.requireNonNull(this.font);
                Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (FormattedCharSequence)formattedCharSequence, (int)(this.leftPos + 15), (int)(this.topPos + 60 + line * (9 + 2)));
            }
        }
    }
}

