/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.trading;

import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.PositiveNumberField;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.client.screen.configuration.trading.TradingConfigurationContainerScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import de.markusbordihn.easynpc.utils.ValueUtils;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;

public class AdvancedTradingConfigurationContainerScreen<T extends ConfigurationMenu>
extends TradingConfigurationContainerScreen<T> {
    protected static final int NAVIGATION_TICKER = 20;
    protected static final int TRADING_OFFERS_TICKER = 20;
    protected final HashMap<Integer, EditBox> maxUsesEditBoxes = new HashMap();
    protected final HashMap<Integer, EditBox> rewardExpEditBoxes = new HashMap();
    protected final HashMap<Integer, EditBox> priceMultiplierEditBoxes = new HashMap();
    protected final HashMap<Integer, EditBox> demandEditBoxes = new HashMap();
    protected Button previousPageButton;
    protected Button nextPageButton;
    protected EditBox resetsEveryMinEditBox;
    private int navigationTicker = 20;
    private int tradingOffersTicker = 20;

    public AdvancedTradingConfigurationContainerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void onResetsEveryMinEditBoxChanged(String text) {
        if (ValueUtils.isNumericValue((String)text) && !text.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setAdvancedTradingResetsEveryMin(this.getEasyNPCUUID(), Integer.parseInt(text));
        }
    }

    private void onMaxUsesEditBoxChanged(int offerIndex, String value, String formerValue) {
        if (!Objects.equals(value, formerValue) && offerIndex >= 0 && ValueUtils.isPositiveNumericValueOrZero((String)value) && !value.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setAdvancedTradingMaxUses(this.getEasyNPCUUID(), offerIndex, Integer.parseInt(value));
        }
    }

    private void onRewardExpEditBoxChanged(int offerIndex, String value, String formerValue) {
        if (!Objects.equals(value, formerValue) && offerIndex >= 0 && ValueUtils.isNumericValue((String)value) && !value.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setAdvancedTradingRewardExp(this.getEasyNPCUUID(), offerIndex, Integer.parseInt(value));
        }
    }

    private void onPriceMultiplierEditBoxChanged(int offerIndex, String value, String formerValue) {
        if (!Objects.equals(value, formerValue) && offerIndex >= 0 && ValueUtils.isFloatValue((String)value) && !value.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setAdvancedTradingPriceMultiplier(this.getEasyNPCUUID(), offerIndex, Float.parseFloat(value));
        }
    }

    private void onDemandEditBoxChanged(int offerIndex, String value, String formerValue) {
        if (!Objects.equals(value, formerValue) && offerIndex >= 0 && ValueUtils.isNumericValue((String)value) && !value.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setAdvancedTradingDemand(this.getEasyNPCUUID(), offerIndex, Integer.parseInt(value));
        }
    }

    @Override
    public void init() {
        super.init();
        this.advancedTradesButton.active = false;
        TradingDataCapable tradingData = this.getEasyNPC().getEasyNPCTradingData();
        TradingDataSet tradingDataSet = tradingData.getTradingDataSet();
        this.resetsEveryMinEditBox = new TextField(this.font, this.contentLeftPos + 250, this.contentTopPos + 172, 32);
        this.resetsEveryMinEditBox.setMaxLength(3);
        this.resetsEveryMinEditBox.setValue("" + tradingDataSet.getResetsEveryMin());
        this.resetsEveryMinEditBox.setResponder(this::onResetsEveryMinEditBoxChanged);
        this.resetsEveryMinEditBox.setFilter(ValueUtils::isNumericValue);
        this.addRenderableWidget((GuiEventListener)this.resetsEveryMinEditBox);
        int editBoxPositionX = this.contentLeftPos + 140;
        int editBoxPositionY = this.topPos + 40;
        MerchantOffers merchantOffers = tradingData.getTradingOffers();
        for (int tradingOffer = 0; tradingOffer < 5; ++tradingOffer) {
            int tradingOfferIndex = ((ConfigurationMenu)this.menu).getPageIndex() * 5 + tradingOffer;
            MerchantOffer merchantOffer = merchantOffers.size() > tradingOfferIndex ? (MerchantOffer)merchantOffers.get(tradingOfferIndex) : this.getEmptyMerchangeOffer();
            boolean hasValidOffer = (!merchantOffer.getBaseCostA().isEmpty() || !merchantOffer.getCostB().isEmpty()) && !merchantOffer.getResult().isEmpty();
            log.info("Trading Offer {} : {}", (Object)tradingOfferIndex, (Object)merchantOffer);
            PositiveNumberField maxUsesEditBox = new PositiveNumberField(this.font, editBoxPositionX, editBoxPositionY, 32);
            maxUsesEditBox.setMaxLength(4);
            maxUsesEditBox.setValue((String)(merchantOffer.getMaxUses() > 0 ? "" + merchantOffer.getMaxUses() : "16"));
            maxUsesEditBox.setResponder(text -> this.onMaxUsesEditBoxChanged(tradingOfferIndex, (String)text, "" + merchantOffer.getMaxUses()));
            maxUsesEditBox.setEditable(hasValidOffer);
            this.maxUsesEditBoxes.put(tradingOfferIndex, (EditBox)maxUsesEditBox);
            this.addRenderableWidget((GuiEventListener)maxUsesEditBox);
            TextField rewardExpEditBox = new TextField(this.font, editBoxPositionX + 45, editBoxPositionY, 26);
            rewardExpEditBox.setMaxLength(3);
            rewardExpEditBox.setValue((String)(merchantOffer.getXp() >= 0 ? "" + merchantOffer.getXp() : "0"));
            rewardExpEditBox.setResponder(text -> this.onRewardExpEditBoxChanged(tradingOfferIndex, (String)text, "" + merchantOffer.getXp()));
            rewardExpEditBox.setFilter(ValueUtils::isNumericValue);
            rewardExpEditBox.setEditable(hasValidOffer);
            this.rewardExpEditBoxes.put(tradingOfferIndex, (EditBox)rewardExpEditBox);
            this.addRenderableWidget((GuiEventListener)rewardExpEditBox);
            TextField priceMultiplierEditBox = new TextField(this.font, editBoxPositionX + 85, editBoxPositionY, 32);
            priceMultiplierEditBox.setMaxLength(4);
            priceMultiplierEditBox.setValue((String)(merchantOffer.getPriceMultiplier() >= 0.0f ? "" + merchantOffer.getPriceMultiplier() : "0"));
            priceMultiplierEditBox.setResponder(text -> this.onPriceMultiplierEditBoxChanged(tradingOfferIndex, (String)text, "" + merchantOffer.getPriceMultiplier()));
            priceMultiplierEditBox.setFilter(ValueUtils::isFloatValue);
            priceMultiplierEditBox.setEditable(hasValidOffer);
            this.priceMultiplierEditBoxes.put(tradingOfferIndex, (EditBox)priceMultiplierEditBox);
            this.addRenderableWidget((GuiEventListener)priceMultiplierEditBox);
            TextField demandEditBox = new TextField(this.font, editBoxPositionX + 135, editBoxPositionY, 20);
            demandEditBox.setMaxLength(2);
            demandEditBox.setValue((String)(merchantOffer.getDemand() >= 0 ? "" + merchantOffer.getDemand() : "0"));
            demandEditBox.setResponder(text -> this.onDemandEditBoxChanged(tradingOfferIndex, (String)text, "" + merchantOffer.getDemand()));
            demandEditBox.setFilter(ValueUtils::isNumericValue);
            demandEditBox.setEditable(hasValidOffer);
            this.demandEditBoxes.put(tradingOfferIndex, (EditBox)demandEditBox);
            this.addRenderableWidget((GuiEventListener)demandEditBox);
            editBoxPositionY += 19;
        }
        this.previousPageButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.contentLeftPos, this.contentTopPos + 115, 70, "previous_page", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.ADVANCED_TRADING, ((ConfigurationMenu)this.menu).getPageIndex() - 1)));
        this.nextPageButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.contentLeftPos + 235, this.contentTopPos + 115, 70, "next_page", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.ADVANCED_TRADING, ((ConfigurationMenu)this.menu).getPageIndex() + 1)));
    }

    public void containerTick() {
        super.containerTick();
        if (this.navigationTicker++ > 20) {
            if (this.previousPageButton != null) {
                boolean bl = this.previousPageButton.active = ((ConfigurationMenu)this.menu).getPageIndex() > 0;
            }
            if (this.nextPageButton != null) {
                this.nextPageButton.active = ((ConfigurationMenu)this.menu).getPageIndex() < this.getMaxPages() - 1;
            }
            this.navigationTicker = 0;
        }
        if (this.tradingOffersTicker++ > 20) {
            for (int tradingOffer = 0; tradingOffer < 5; ++tradingOffer) {
                EditBox demandEditBox;
                EditBox priceMultiplierEditBox;
                EditBox rewardExpEditBox;
                int tradingOfferIndex = ((ConfigurationMenu)this.menu).getPageIndex() * 5 + tradingOffer;
                boolean hasValidOffer = this.isValidOffer(tradingOfferIndex);
                EditBox maxUsesEditBox = this.maxUsesEditBoxes.get(tradingOfferIndex);
                if (maxUsesEditBox != null) {
                    maxUsesEditBox.setEditable(hasValidOffer);
                }
                if ((rewardExpEditBox = this.rewardExpEditBoxes.get(tradingOfferIndex)) != null) {
                    rewardExpEditBox.setEditable(hasValidOffer);
                }
                if ((priceMultiplierEditBox = this.priceMultiplierEditBoxes.get(tradingOfferIndex)) != null) {
                    priceMultiplierEditBox.setEditable(hasValidOffer);
                }
                if ((demandEditBox = this.demandEditBoxes.get(tradingOfferIndex)) == null) continue;
                demandEditBox.setEditable(hasValidOffer);
            }
            this.tradingOffersTicker = 0;
        }
    }

    private boolean isValidOffer(int tradingOfferIndex) {
        TradingDataCapable tradingData = this.getEasyNPC().getEasyNPCTradingData();
        MerchantOffers merchantOffers = tradingData.getTradingOffers();
        MerchantOffer merchantOffer = merchantOffers.size() > tradingOfferIndex ? (MerchantOffer)merchantOffers.get(tradingOfferIndex) : this.getEmptyMerchangeOffer();
        return (!merchantOffer.getBaseCostA().isEmpty() || !merchantOffer.getCostB().isEmpty()) && !merchantOffer.getResult().isEmpty();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        this.renderTooltip(guiGraphics, x, y);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int legendTopPositionY = this.contentTopPos + 2;
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Cost A", (int)(this.leftPos + 18), (int)legendTopPositionY, (int)0xA04040);
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Cost B", (int)(this.leftPos + 60), (int)legendTopPositionY, (int)0x40A040);
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Result", (int)(this.leftPos + 102), (int)legendTopPositionY, (int)0x4040A0);
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Max Uses", (int)(this.leftPos + 140), (int)legendTopPositionY, (int)16448);
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"XP", (int)(this.leftPos + 198), (int)legendTopPositionY, (int)0x400040);
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Multiplier", (int)(this.leftPos + 225), (int)legendTopPositionY, (int)0x404040);
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Demand", (int)(this.leftPos + 275), (int)legendTopPositionY, (int)0x404000);
        int slotPositionX = this.leftPos + 30 - 1;
        int slotPositionY = this.topPos + 40 - 1;
        for (int tradingOffer = 0; tradingOffer < 5; ++tradingOffer) {
            int tradingOfferIndex = ((ConfigurationMenu)this.menu).getPageIndex() * 5 + tradingOffer;
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)((tradingOfferIndex < 9 ? " " : "") + (tradingOfferIndex + 1) + "."), (int)(slotPositionX - 15), (int)(slotPositionY + 5), (int)0x404040);
            int itemASlotTopPosition = slotPositionY;
            Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)slotPositionX, (int)itemASlotTopPosition, (int)7, (int)7, (int)18, (int)18);
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"+", (int)(slotPositionX + 18 + 6), (int)(itemASlotTopPosition + 5), (int)0x404040);
            int itemBSlotLeftPosition = slotPositionX + 18 + 18;
            int itemBSlotTopPosition = slotPositionY;
            Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)itemBSlotLeftPosition, (int)itemBSlotTopPosition, (int)7, (int)7, (int)18, (int)18);
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"=", (int)(itemBSlotLeftPosition + 18 + 12), (int)(itemBSlotTopPosition + 5), (int)0x404040);
            Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)(slotPositionX + 82), (int)slotPositionY, (int)7, (int)7, (int)18, (int)18);
            slotPositionY += 19;
        }
        Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)(this.contentLeftPos + 72), (int)(this.contentTopPos + 135), (int)7, (int)83, (int)162, (int)54);
        Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)(this.contentLeftPos + 72), (int)(this.contentTopPos + 191), (int)7, (int)141, (int)162, (int)18);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"trading.minutes_for_trade_reset", (int)(this.contentLeftPos + 236), (int)(this.contentTopPos + 160), (int)0x404040);
    }

    public int getMaxPages() {
        return 5;
    }

    private MerchantOffer getEmptyMerchangeOffer() {
        return new MerchantOffer(new ItemCost((ItemLike)ItemStack.EMPTY.getItem(), 0), ItemStack.EMPTY, 0, 0, 0.0f);
    }
}

