/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.preset;

import de.markusbordihn.easynpc.configui.client.screen.configuration.preset.ImportPresetConfigurationScreen;
import de.markusbordihn.easynpc.configui.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ImportWorldPresetConfigurationScreen<T extends ConfigurationMenu>
extends ImportPresetConfigurationScreen<T> {
    private final Set<ResourceLocation> worldPresets;

    public ImportWorldPresetConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.importPresetButtonLabel = "import_world_preset";
        this.importPresetHeaderLabel = "preset_world_for";
        this.worldPresets = CompoundTagUtils.readResourceLocations((ListTag)((AdditionalScreenData)this.getAdditionalScreenData()).getList("WorldPresets")).stream().filter(resourceLocation -> resourceLocation.getPath().contains("/" + this.getSkinModel().getName() + "/")).collect(Collectors.toSet());
    }

    @Override
    public void loadPreset(ResourceLocation resourceLocation) {
        NetworkMessageHandlerManager.getServerHandler().importWorldPreset(this.getEasyNPCUUID(), resourceLocation);
    }

    @Override
    public void init() {
        super.init();
        this.worldImportPresetButton.active = false;
        ImportPresetConfigurationScreen.updatePresets(this.worldPresets.stream().toList());
        this.presetSelectionList.updatePresets();
    }
}

