/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.attribute;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.configui.client.screen.configuration.attribute.AttributeConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.attribute.CombatAttributeType;
import de.markusbordihn.easynpc.data.attribute.EntityAttribute;
import de.markusbordihn.easynpc.data.attribute.EntityAttributes;
import de.markusbordihn.easynpc.data.attribute.EnvironmentalAttributeType;
import de.markusbordihn.easynpc.data.attribute.InteractionAttributeType;
import de.markusbordihn.easynpc.data.attribute.MovementAttributeType;
import de.markusbordihn.easynpc.entity.easynpc.data.AttributeDataCapable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class AbilitiesAttributeConfigurationScreen<T extends ConfigurationMenu>
extends AttributeConfigurationScreen<T> {
    RangeSliderButton healthRegenerationSlider;

    public AbilitiesAttributeConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void init() {
        super.init();
        this.abilitiesAttributeButton.active = false;
        int firstButtonRow = this.leftPos + 10;
        int secondButtonRow = this.leftPos + 100;
        int thirdButtonRow = this.leftPos + 200;
        AttributeDataCapable attributeData = this.getEasyNPC().getEasyNPCAttributeData();
        EntityAttributes entityAttributes = attributeData.getEntityAttributes();
        this.addRenderableWidget((GuiEventListener)new Checkbox(firstButtonRow, this.buttonTopPos + 25, EnvironmentalAttributeType.CAN_FLOAT.getAttributeName(), entityAttributes.getEnvironmentalAttributes().canFloat(), checkbox -> NetworkMessageHandlerManager.getServerHandler().environmentalAttributeChange(this.getEasyNPCUUID(), EnvironmentalAttributeType.CAN_FLOAT, checkbox.selected())));
        this.addRenderableWidget((GuiEventListener)new Checkbox(secondButtonRow, this.buttonTopPos + 25, EnvironmentalAttributeType.CAN_BREATHE_UNDERWATER.getAttributeName(), entityAttributes.getEnvironmentalAttributes().canBreatheUnderwater(), checkbox -> NetworkMessageHandlerManager.getServerHandler().environmentalAttributeChange(this.getEasyNPCUUID(), EnvironmentalAttributeType.CAN_BREATHE_UNDERWATER, checkbox.selected())));
        this.addRenderableWidget((GuiEventListener)new Checkbox(firstButtonRow, this.buttonTopPos + 45, MovementAttributeType.CAN_OPEN_DOOR.getAttributeName(), entityAttributes.getMovementAttributes().canOpenDoor(), checkbox -> NetworkMessageHandlerManager.getServerHandler().movementAttributeChange(this.getEasyNPCUUID(), MovementAttributeType.CAN_OPEN_DOOR, checkbox.selected())));
        this.addRenderableWidget((GuiEventListener)new Checkbox(secondButtonRow, this.buttonTopPos + 45, MovementAttributeType.CAN_CLOSE_DOOR.getAttributeName(), entityAttributes.getMovementAttributes().canCloseDoor(), checkbox -> NetworkMessageHandlerManager.getServerHandler().movementAttributeChange(this.getEasyNPCUUID(), MovementAttributeType.CAN_CLOSE_DOOR, checkbox.selected())));
        this.addRenderableWidget((GuiEventListener)new Checkbox(thirdButtonRow, this.buttonTopPos + 45, MovementAttributeType.CAN_PASS_DOOR.getAttributeName(), entityAttributes.getMovementAttributes().canPassDoor(), checkbox -> NetworkMessageHandlerManager.getServerHandler().movementAttributeChange(this.getEasyNPCUUID(), MovementAttributeType.CAN_PASS_DOOR, checkbox.selected())));
        this.addRenderableWidget((GuiEventListener)new Checkbox(firstButtonRow, this.buttonTopPos + 65, InteractionAttributeType.IS_PUSHABLE.getAttributeName(), entityAttributes.getInteractionAttributes().isPushable(), checkbox -> NetworkMessageHandlerManager.getServerHandler().interactionAttributeChange(this.getEasyNPCUUID(), InteractionAttributeType.IS_PUSHABLE, checkbox.selected())));
        this.addRenderableWidget((GuiEventListener)new Checkbox(secondButtonRow, this.buttonTopPos + 65, InteractionAttributeType.CAN_BE_HIT_BY_PROJECTILE.getAttributeName(), entityAttributes.getInteractionAttributes().canBeHitByProjectile(), checkbox -> NetworkMessageHandlerManager.getServerHandler().interactionAttributeChange(this.getEasyNPCUUID(), InteractionAttributeType.CAN_BE_HIT_BY_PROJECTILE, checkbox.selected())));
        this.addRenderableWidget((GuiEventListener)new Checkbox(thirdButtonRow, this.buttonTopPos + 65, InteractionAttributeType.PUSH_ENTITIES.getAttributeName(), entityAttributes.getInteractionAttributes().pushEntities(), checkbox -> NetworkMessageHandlerManager.getServerHandler().interactionAttributeChange(this.getEasyNPCUUID(), InteractionAttributeType.PUSH_ENTITIES, checkbox.selected())));
        this.addRenderableWidget((GuiEventListener)new Checkbox(firstButtonRow, this.buttonTopPos + 85, InteractionAttributeType.CAN_BE_LEASHED.getAttributeName(), entityAttributes.getInteractionAttributes().canBeLeashed(), checkbox -> NetworkMessageHandlerManager.getServerHandler().interactionAttributeChange(this.getEasyNPCUUID(), InteractionAttributeType.CAN_BE_LEASHED, checkbox.selected())));
        this.addRenderableWidget((GuiEventListener)new Checkbox(firstButtonRow, this.buttonTopPos + 105, MovementAttributeType.CAN_USE_NETHER_PORTAL.getAttributeName(), entityAttributes.getMovementAttributes().canUseNetherPortal(), checkbox -> NetworkMessageHandlerManager.getServerHandler().movementAttributeChange(this.getEasyNPCUUID(), MovementAttributeType.CAN_USE_NETHER_PORTAL, checkbox.selected())));
        this.addRenderableWidget((GuiEventListener)new Checkbox(firstButtonRow, this.buttonTopPos + 125, EntityAttribute.SILENT.getAttributeName(), attributeData.getAttributeSilent(), checkbox -> NetworkMessageHandlerManager.getServerHandler().entityAttributeChange(this.getEasyNPCUUID(), EntityAttribute.SILENT, checkbox.selected())));
        this.healthRegenerationSlider = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(firstButtonRow + 135, this.buttonTopPos + 210, entityAttributes.getCombatAttributes().healthRegeneration(), 0.0, 32.0, 0.0, 0.1, slider -> NetworkMessageHandlerManager.getServerHandler().combatAttributeChange(this.getEasyNPCUUID(), CombatAttributeType.HEALTH_REGENERATION, slider.getTargetDoubleValue())));
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        int sliderXOffset = -125;
        int sliderYOffset = 3;
        if (this.healthRegenerationSlider != null) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"health_regeneration", (int)(this.healthRegenerationSlider.getX() + sliderXOffset), (int)(this.healthRegenerationSlider.getY() + sliderYOffset));
        }
    }
}

