/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.components;

import de.markusbordihn.easynpc.client.screen.components.SpinButton;
import de.markusbordihn.easynpc.data.dialog.DialogPriority;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class DialogPriorityButton
extends SpinButton<PriorityValue> {
    public DialogPriorityButton(int x, int y, int width, int height, int initialPriority, SpinButton.OnChange onChange) {
        super(x, y, width, height, DialogPriorityButton.getPresetPriorities(), (Object)DialogPriorityButton.findPresetOrCustom(initialPriority), onChange);
    }

    private static Set<PriorityValue> getPresetPriorities() {
        LinkedHashSet<PriorityValue> priorities = new LinkedHashSet<PriorityValue>();
        priorities.add(new PriorityValue(-1));
        priorities.add(new PriorityValue(0));
        priorities.add(new PriorityValue(1));
        priorities.add(new PriorityValue(5));
        priorities.add(new PriorityValue(10));
        priorities.add(new PriorityValue(100));
        priorities.add(new PriorityValue(Integer.MAX_VALUE, true));
        return priorities;
    }

    private static PriorityValue findPresetOrCustom(int priority) {
        for (PriorityValue preset : DialogPriorityButton.getPresetPriorities()) {
            if (preset.isCustom || preset.value != priority) continue;
            return preset;
        }
        return new PriorityValue(priority, true);
    }

    public int getPriority() {
        PriorityValue current = (PriorityValue)this.get();
        return current != null ? current.value : 0;
    }

    public boolean isCustom() {
        PriorityValue current = (PriorityValue)this.get();
        return current != null && current.isCustom;
    }

    public static class PriorityValue {
        public final int value;
        public final boolean isCustom;

        public PriorityValue(int value) {
            this(value, false);
        }

        public PriorityValue(int value, boolean isCustom) {
            this.value = value;
            this.isCustom = isCustom;
        }

        public String toString() {
            return this.isCustom ? "Custom" : DialogPriority.getDisplayName((int)this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PriorityValue)) {
                return false;
            }
            PriorityValue other = (PriorityValue)obj;
            if (this.isCustom && other.isCustom) {
                return true;
            }
            return !this.isCustom && !other.isCustom && this.value == other.value;
        }

        public int hashCode() {
            return this.isCustom ? Integer.MAX_VALUE : Objects.hash(this.value);
        }
    }
}

