/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.integration.jei.category;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.azurune.runiclib.RunicLib;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.yirmiri.dungeonsdelight.core.init.DDTags;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.integration.jei.DDRecipeTypes;
import vectorwing.farmersdelight.common.utility.ClientRenderUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;
import vectorwing.farmersdelight.integration.jei.resource.DecompositionDummy;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SculkingRecipeCategory
implements IRecipeCategory<DecompositionDummy> {
    private static final int slotSize = 22;
    private final Component title = TextUtils.getTranslation((String)"jei.sculking", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable slotIcon;
    private final IDrawable icon;
    private final ItemStack embeddedEggs;
    private final ItemStack heapOfAncientEggs;

    public SculkingRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = RunicLib.customid((String)"dungeonsdelight", (String)"textures/gui/sculking_jei.png");
        this.background = helper.createDrawable(backgroundImage, 0, 0, 118, 80);
        this.embeddedEggs = new ItemStack((ItemLike)DDBlocks.EMBEDDED_EGGS.get());
        this.heapOfAncientEggs = new ItemStack((ItemLike)DDBlocks.HEAP_OF_ANCIENT_EGGS.get());
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)this.heapOfAncientEggs);
        this.slotIcon = helper.createDrawable(backgroundImage, 119, 0, 22, 22);
    }

    public RecipeType<DecompositionDummy> getRecipeType() {
        return DDRecipeTypes.SCULKING;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DecompositionDummy recipe, IFocusGroup focusGroup) {
        ArrayList accelerators = new ArrayList();
        BuiltInRegistries.BLOCK.getTag(DDTags.BlockT.SCULKING_ACTIVATORS).ifPresent(s -> s.forEach(f -> accelerators.add(new ItemStack((ItemLike)f.value()))));
        builder.addSlot(RecipeIngredientRole.INPUT, 9, 26).addItemStack(this.embeddedEggs);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 93, 26).addItemStack(this.heapOfAncientEggs);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 64, 54).addItemStacks(accelerators);
    }

    public void draw(DecompositionDummy recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.slotIcon.draw(guiGraphics, 63, 53);
        this.slotIcon.draw(guiGraphics, 47, 53);
    }

    public List<Component> getTooltipStrings(DecompositionDummy recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (ClientRenderUtils.isCursorInsideBounds((int)40, (int)38, (int)11, (int)11, (double)mouseX, (double)mouseY)) {
            return ImmutableList.of((Object)SculkingRecipeCategory.translateKey(".night"));
        }
        if (ClientRenderUtils.isCursorInsideBounds((int)53, (int)38, (int)11, (int)11, (double)mouseX, (double)mouseY)) {
            return ImmutableList.of((Object)SculkingRecipeCategory.translateKey(".spawner"));
        }
        if (ClientRenderUtils.isCursorInsideBounds((int)67, (int)38, (int)11, (int)11, (double)mouseX, (double)mouseY)) {
            return ImmutableList.of((Object)SculkingRecipeCategory.translateKey(".accelerators"));
        }
        return Collections.emptyList();
    }

    private static MutableComponent translateKey(@Nonnull String suffix) {
        return Component.translatable((String)("dungeonsdelight.jei.sculking" + suffix));
    }
}

