/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.azurune.runiclib.RunicLib;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.yirmiri.dungeonsdelight.DDConfigClient;
import net.yirmiri.dungeonsdelight.common.util.misc.RottenHeartData;
import net.yirmiri.dungeonsdelight.common.util.misc.RottenHeartManager;
import net.yirmiri.dungeonsdelight.core.init.DDHeartTypes;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Shadow
    private int tickCount;
    @Shadow
    @Final
    private RandomSource random;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private static ResourceLocation VIGNETTE_LOCATION;
    @Unique
    private static final ResourceLocation DUNDELIGHT$FOOD_EMPTY_BURROW_GUT_TEXTURE;
    @Unique
    private static final ResourceLocation DUNDELIGHT$FOOD_HALF_BURROW_GUT_TEXTURE;
    @Unique
    private static final ResourceLocation DUNDELIGHT$FOOD_FULL_BURROW_GUT_TEXTURE;
    @Unique
    private static final ResourceLocation DUNDELIGHT$FOOD_EMPTY_VORACITY_TEXTURE;
    @Unique
    private static final ResourceLocation DUNDELIGHT$FOOD_HALF_VORACITY_TEXTURE;
    @Unique
    private static final ResourceLocation DUNDELIGHT$FOOD_FULL_VORACITY_TEXTURE;
    @Unique
    private static final ResourceLocation DUNDELIGHT$VORACITY_OVERLAY_LOCATION;
    @Unique
    private static final ResourceLocation DUNDELIGHT$HEART_HALF_ROTGUT_TEXTURE;
    @Unique
    private static final ResourceLocation DUNDELIGHT$HEART_FULL_ROTGUT_TEXTURE;
    @Unique
    private static final ResourceLocation DUNDELIGHT$RAVENOUS_RUSH_OVERLAY_LOCATION;

    @Shadow
    @Nullable
    protected abstract Player getCameraPlayer();

    @Shadow
    protected abstract void renderTextureOverlay(GuiGraphics var1, ResourceLocation var2, float var3);

    @ModifyVariable(method={"renderHearts"}, at=@At(value="HEAD"), ordinal=6, argsOnly=true)
    private int dungeonsdelight$removeAbsorptionHearts(int j) {
        if (this.getCameraPlayer() != null && this.getCameraPlayer().hasEffect(DDEffects.EXUDATION)) {
            return 0;
        }
        return j;
    }

    @Inject(at={@At(value="HEAD")}, method={"renderHearts"})
    private void dungeonsdelight$renderHearts(GuiGraphics ctx, Player player, int x, int y, int lines, int regeneratingHeartIndex, float maxHealth, int lastHealth, int health, int absorption, boolean blinking, CallbackInfo ci) {
        int absorption2 = Mth.ceil((float)player.getAbsorptionAmount());
        boolean hardcore = player.level().getLevelData().isHardcore();
        int maxHealthBars = Mth.ceil((double)((double)maxHealth / 2.0));
        int maxAbsorptionBars = Mth.ceil((double)((double)absorption2 / 2.0));
        int maxHp = maxHealthBars * 2;
        int currentHealthBars = Mth.ceil((float)((float)health / 2.0f));
        float currentHealth = player.getHealth();
        if (player.hasEffect(DDEffects.EXUDATION)) {
            for (int lastHealthPoint = maxHealthBars + maxAbsorptionBars - 1; lastHealthPoint >= 0; --lastHealthPoint) {
                int absorptionHp;
                boolean hasAbsorptionHp;
                int m = lastHealthPoint / 10;
                int n = lastHealthPoint % 10;
                int xPos = x + n * 8;
                int yPos = y - m * lines;
                if (lastHealthPoint < maxHealthBars && lastHealthPoint == regeneratingHeartIndex) {
                    yPos -= 2;
                }
                yPos += this.random.nextInt(2);
                int q = lastHealthPoint * 2;
                boolean bl = hasAbsorptionHp = lastHealthPoint >= maxHealthBars;
                if (!hasAbsorptionHp || (absorptionHp = q - maxHp) >= absorption2) continue;
                this.drawExudationHeart(ctx, DDHeartTypes.EXUDATION_CONTAINER, xPos, yPos, hardcore, blinking, false);
                boolean absorptionHearts = absorptionHp + 1 == absorption2;
                this.drawExudationHeart(ctx, DDHeartTypes.EXUDATION, xPos, yPos, hardcore, false, absorptionHearts);
            }
        }
        RottenHeartData rottenData = RottenHeartManager.get((LivingEntity)player);
        int rotten = rottenData.getRottenHearts();
        if (player.hasEffect(DDEffects.ROTGUT) && rotten > 0) {
            int fullHearts = rotten / 2;
            boolean halfHeart = rotten % 2 != 0;
            int startIndex = currentHealthBars;
            if (currentHealth % 2.0f != 0.0f) {
                --startIndex;
            }
            for (int i = 0; i < fullHearts + (halfHeart ? 1 : 0); ++i) {
                int totalIndex = startIndex + i;
                int m = totalIndex / 10;
                int n = totalIndex % 10;
                int xPos = x + n * 8;
                int yPos = y - m * lines;
                if (currentHealth <= 4.0f) {
                    yPos += this.random.nextInt(2);
                }
                boolean half = halfHeart && i == fullHearts;
                this.drawRottenHeart(ctx, DDHeartTypes.ROTGUT, xPos, yPos, hardcore, blinking, half);
            }
        }
    }

    private void drawExudationHeart(GuiGraphics ctx, DDHeartTypes type, int x, int y, boolean hardcore, boolean blinking, boolean half) {
        RenderSystem.enableBlend();
        ctx.blitSprite(type.getTexture(hardcore, half, blinking), x, y, 9, 9);
        RenderSystem.disableBlend();
    }

    private void drawRottenHeart(GuiGraphics ctx, DDHeartTypes type, int x, int y, boolean hardcore, boolean blinking, boolean half) {
        RenderSystem.enableBlend();
        ctx.pose().pushPose();
        ctx.pose().translate(0.0f, 0.0f, 200.0f);
        ctx.blitSprite(type.getTexture(hardcore, half, blinking), x, y, 9, 9);
        ctx.pose().popPose();
        RenderSystem.disableBlend();
    }

    @Inject(at={@At(value="HEAD")}, method={"renderFood"}, cancellable=true)
    private void dungeonsdelight$renderFood(GuiGraphics ctx, Player player, int top, int right, CallbackInfo ci) {
        FoodData hungerManager = player.getFoodData();
        int i = hungerManager.getFoodLevel();
        RenderSystem.enableBlend();
        for (int j = 0; j < 10; ++j) {
            int k = top;
            ResourceLocation emptyTexture = null;
            ResourceLocation halfTexture = null;
            ResourceLocation fullTexture = null;
            if (player.hasEffect(DDEffects.BURROW_GUT)) {
                emptyTexture = DUNDELIGHT$FOOD_EMPTY_BURROW_GUT_TEXTURE;
                halfTexture = DUNDELIGHT$FOOD_HALF_BURROW_GUT_TEXTURE;
                fullTexture = DUNDELIGHT$FOOD_FULL_BURROW_GUT_TEXTURE;
                ci.cancel();
            } else if (player.hasEffect(DDEffects.VORACITY)) {
                emptyTexture = DUNDELIGHT$FOOD_EMPTY_VORACITY_TEXTURE;
                halfTexture = DUNDELIGHT$FOOD_HALF_VORACITY_TEXTURE;
                fullTexture = DUNDELIGHT$FOOD_FULL_VORACITY_TEXTURE;
                ci.cancel();
            }
            if (player.getFoodData().getSaturationLevel() <= 0.0f && this.tickCount % (i * 3 + 1) == 0) {
                k += this.random.nextInt(3) - 1;
            }
            if (emptyTexture == null) continue;
            int l = right - j * 8 - 9;
            ctx.blitSprite(emptyTexture, l, k, 9, 9);
            if (j * 2 + 1 < i) {
                ctx.blitSprite(fullTexture, l, k, 9, 9);
            }
            if (j * 2 + 1 != i) continue;
            ctx.blitSprite(halfTexture, l, k, 9, 9);
        }
        RenderSystem.disableBlend();
    }

    @Inject(at={@At(value="TAIL")}, method={"renderCameraOverlays"})
    private void dungeonsdelight$renderCameraOverlaysOnTail(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        ItemStack itemstack = this.minecraft.player.getInventory().getArmor(3);
        if (this.minecraft.options.getCameraType().isFirstPerson() && itemstack.is(DDBlocks.CARVED_ROTGOURD.get().asItem())) {
            this.renderTextureOverlay(guiGraphics, ResourceLocation.withDefaultNamespace((String)"textures/misc/pumpkinblur.png"), 1.0f);
        }
        if (((Boolean)DDConfigClient.VORACITY_OVERLAY.get()).booleanValue() && this.minecraft.player.hasEffect(DDEffects.VORACITY)) {
            float alpha = (Boolean)DDConfigClient.VORACITY_TRANSPARENCY.get() != false ? this.dundelight$getPercentVoracity((Player)this.minecraft.player) / 2.0f : this.dundelight$getPercentVoracity((Player)this.minecraft.player);
            this.renderTextureOverlay(guiGraphics, DUNDELIGHT$VORACITY_OVERLAY_LOCATION, alpha);
        }
        if (this.minecraft.player.hasEffect(DDEffects.RAVENOUS_RUSH) && ((Boolean)DDConfigClient.RAVENOUS_RUSH_OVERLAY.get()).booleanValue() && !this.minecraft.player.hasEffect(DDEffects.VORACITY)) {
            this.renderTextureOverlay(guiGraphics, DUNDELIGHT$RAVENOUS_RUSH_OVERLAY_LOCATION, this.dundelight$getPercentRavenous((Player)this.minecraft.player));
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIFFIIII)V", shift=At.Shift.BEFORE)}, method={"renderVignette"})
    private void dungeonsdelight$overlayRRushPractica(GuiGraphics guiGraphics, Entity entity, CallbackInfo ci) {
        if (this.minecraft.player.hasEffect(DDEffects.RAVENOUS_RUSH)) {
            float alphaXIQ = this.dundelight$getPercentRavenousVignette((Player)this.minecraft.player);
            guiGraphics.setColor(0.0f, alphaXIQ, alphaXIQ, 1.0f);
        }
    }

    @Unique
    public float dundelight$getPercentVoracity(Player player) {
        if (player.getEffect(DDEffects.VORACITY).getDuration() == -1) {
            return 1.0f;
        }
        return (float)Math.min(player.getEffect(DDEffects.VORACITY).getDuration(), 200) / 200.0f;
    }

    @Unique
    public float dundelight$getPercentRavenous(Player player) {
        if (player.hasEffect(DDEffects.RAVENOUS_RUSH) && player.getEffect(DDEffects.RAVENOUS_RUSH).getDuration() == -1) {
            return 1.0f;
        }
        if (player.hasEffect(DDEffects.RAVENOUS_RUSH)) {
            return (float)Math.min(player.getEffect(DDEffects.RAVENOUS_RUSH).getDuration(), 200) / 200.0f;
        }
        return 0.0f;
    }

    @Unique
    public float dundelight$getPercentRavenousVignette(Player player) {
        if (player.getEffect(DDEffects.RAVENOUS_RUSH).getDuration() == -1 || player.getEffect(DDEffects.RAVENOUS_RUSH).getDuration() >= 80) {
            return 0.4f;
        }
        return (float)(player.getEffect(DDEffects.RAVENOUS_RUSH).getDuration() / 2) / 100.0f;
    }

    static {
        DUNDELIGHT$FOOD_EMPTY_BURROW_GUT_TEXTURE = RunicLib.customid((String)"dungeonsdelight", (String)"hud/hunger/burrow_gut_empty");
        DUNDELIGHT$FOOD_HALF_BURROW_GUT_TEXTURE = RunicLib.customid((String)"dungeonsdelight", (String)"hud/hunger/burrow_gut_half");
        DUNDELIGHT$FOOD_FULL_BURROW_GUT_TEXTURE = RunicLib.customid((String)"dungeonsdelight", (String)"hud/hunger/burrow_gut_full");
        DUNDELIGHT$FOOD_EMPTY_VORACITY_TEXTURE = RunicLib.customid((String)"dungeonsdelight", (String)"hud/hunger/voracity_empty");
        DUNDELIGHT$FOOD_HALF_VORACITY_TEXTURE = RunicLib.customid((String)"dungeonsdelight", (String)"hud/hunger/voracity_half");
        DUNDELIGHT$FOOD_FULL_VORACITY_TEXTURE = RunicLib.customid((String)"dungeonsdelight", (String)"hud/hunger/voracity_full");
        DUNDELIGHT$VORACITY_OVERLAY_LOCATION = RunicLib.customid((String)"dungeonsdelight", (String)"textures/misc/voracity_overlay.png");
        DUNDELIGHT$HEART_HALF_ROTGUT_TEXTURE = RunicLib.customid((String)"dungeonsdelight", (String)"textures/gui/sprites/hud/heart/rotgut_half.png");
        DUNDELIGHT$HEART_FULL_ROTGUT_TEXTURE = RunicLib.customid((String)"dungeonsdelight", (String)"textures/gui/sprites/hud/heart/rotgut_full.png");
        DUNDELIGHT$RAVENOUS_RUSH_OVERLAY_LOCATION = RunicLib.customid((String)"dungeonsdelight", (String)"textures/misc/ravenous_rush_overlay.png");
    }
}

